/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class RegexFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 4269646126155225062L;
    private final @UnknownKeyFor @NonNull @Initialized Pattern pattern;

    public RegexFileFilter(@UnknownKeyFor @NonNull @Initialized String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern is missing");
        }
        this.pattern = Pattern.compile(pattern);
    }

    public RegexFileFilter(@UnknownKeyFor @NonNull @Initialized String pattern, @Nullable @UnknownKeyFor @Initialized IOCase caseSensitivity) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern is missing");
        }
        int flags = 0;
        if (caseSensitivity != null && !caseSensitivity.isCaseSensitive()) {
            flags = 2;
        }
        this.pattern = Pattern.compile(pattern, flags);
    }

    public RegexFileFilter(@UnknownKeyFor @NonNull @Initialized String pattern, @UnknownKeyFor @NonNull @Initialized int flags) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern is missing");
        }
        this.pattern = Pattern.compile(pattern, flags);
    }

    public RegexFileFilter(@UnknownKeyFor @NonNull @Initialized Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern is missing");
        }
        this.pattern = pattern;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean accept(@UnknownKeyFor @NonNull @Initialized File dir, @UnknownKeyFor @NonNull @Initialized String name) {
        return this.pattern.matcher(name).matches();
    }
}

