/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.comparator;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.commons.io.comparator.AbstractFileComparator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.value.qual.ArrayLen;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class CompositeFileComparator
extends AbstractFileComparator
implements Serializable {
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Comparator<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> @ArrayLen(value={0}) @UnknownKeyFor @NonNull @Initialized [] EMPTY_COMPARATOR_ARRAY = new Comparator[0];
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -2224170307287243428L;
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Comparator<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> @UnknownKeyFor @NonNull @Initialized [] NO_COMPARATORS = new Comparator[0];
    private final @UnknownKeyFor @NonNull @Initialized Comparator<@UnknownKeyFor @NonNull @Initialized File> @UnknownKeyFor @NonNull @Initialized [] delegates;

    public CompositeFileComparator(Comparator<File> ... delegates) {
        if (delegates == null) {
            this.delegates = NO_COMPARATORS;
        } else {
            this.delegates = new Comparator[delegates.length];
            System.arraycopy(delegates, 0, this.delegates, 0, delegates.length);
        }
    }

    public CompositeFileComparator(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Comparator<@UnknownKeyFor @NonNull @Initialized File>> delegates) {
        if (delegates == null) {
            this.delegates = NO_COMPARATORS;
        } else {
            ArrayList<Comparator<File>> list = new ArrayList<Comparator<File>>();
            for (Comparator<File> comparator : delegates) {
                list.add(comparator);
            }
            this.delegates = list.toArray(EMPTY_COMPARATOR_ARRAY);
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int compare(@UnknownKeyFor @NonNull @Initialized File file1, @UnknownKeyFor @NonNull @Initialized File file2) {
        Comparator<File> delegate;
        int result = 0;
        Comparator<File>[] comparatorArray = this.delegates;
        int n = comparatorArray.length;
        for (int i = 0; i < n && (result = (delegate = comparatorArray[i]).compare(file1, file2)) == 0; ++i) {
        }
        return result;
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append('{');
        for (int i = 0; i < this.delegates.length; ++i) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append(this.delegates[i]);
        }
        builder.append('}');
        return builder.toString();
    }
}

