/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.ThreadMonitor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Deprecated
public class FileSystemUtils {
    private static final @UnknownKeyFor @NonNull @Initialized FileSystemUtils INSTANCE = new FileSystemUtils();
    private static final @UnknownKeyFor @NonNull @Initialized int INIT_PROBLEM = -1;
    private static final @UnknownKeyFor @NonNull @Initialized int OTHER = 0;
    private static final @UnknownKeyFor @NonNull @Initialized int WINDOWS = 1;
    private static final @UnknownKeyFor @NonNull @Initialized int UNIX = 2;
    private static final @UnknownKeyFor @NonNull @Initialized int POSIX_UNIX = 3;
    private static final @UnknownKeyFor @NonNull @Initialized int OS;
    private static final @UnknownKeyFor @NonNull @Initialized String DF;

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized long freeSpace(@UnknownKeyFor @NonNull @Initialized String path) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return INSTANCE.freeSpaceOS(path, OS, false, -1L);
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized long freeSpaceKb(@UnknownKeyFor @NonNull @Initialized String path) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return FileSystemUtils.freeSpaceKb(path, -1L);
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized long freeSpaceKb(@UnknownKeyFor @NonNull @Initialized String path, @UnknownKeyFor @NonNull @Initialized long timeout) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return INSTANCE.freeSpaceOS(path, OS, true, timeout);
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized long freeSpaceKb() throws @UnknownKeyFor @NonNull @Initialized IOException {
        return FileSystemUtils.freeSpaceKb(-1L);
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized long freeSpaceKb(@UnknownKeyFor @NonNull @Initialized long timeout) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return FileSystemUtils.freeSpaceKb(new File(".").getAbsolutePath(), timeout);
    }

    @UnknownKeyFor @NonNull @Initialized long freeSpaceOS(@UnknownKeyFor @NonNull @Initialized String path, @UnknownKeyFor @NonNull @Initialized int os, @UnknownKeyFor @NonNull @Initialized boolean kb, @UnknownKeyFor @NonNull @Initialized long timeout) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (path == null) {
            throw new IllegalArgumentException("Path must not be null");
        }
        switch (os) {
            case 1: {
                return kb ? this.freeSpaceWindows(path, timeout) / 1024L : this.freeSpaceWindows(path, timeout);
            }
            case 2: {
                return this.freeSpaceUnix(path, kb, false, timeout);
            }
            case 3: {
                return this.freeSpaceUnix(path, kb, true, timeout);
            }
            case 0: {
                throw new IllegalStateException("Unsupported operating system");
            }
        }
        throw new IllegalStateException("Exception caught when determining operating system");
    }

    @UnknownKeyFor @NonNull @Initialized long freeSpaceWindows(@UnknownKeyFor @NonNull @Initialized String path, @UnknownKeyFor @NonNull @Initialized long timeout) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String normPath = FilenameUtils.normalize(path, false);
        if (normPath == null) {
            throw new IllegalArgumentException(path);
        }
        if (normPath.length() > 0 && normPath.charAt(0) != '\"') {
            normPath = "\"" + normPath + "\"";
        }
        String[] cmdAttribs = new String[]{"cmd.exe", "/C", "dir /a /-c " + normPath};
        List<String> lines = this.performCommand(cmdAttribs, Integer.MAX_VALUE, timeout);
        for (int i = lines.size() - 1; i >= 0; --i) {
            String line = lines.get(i);
            if (line.length() <= 0) continue;
            return this.parseDir(line, normPath);
        }
        throw new IOException("Command line 'dir /-c' did not return any info for path '" + normPath + "'");
    }

    @UnknownKeyFor @NonNull @Initialized long parseDir(@UnknownKeyFor @NonNull @Initialized String line, @UnknownKeyFor @NonNull @Initialized String path) throws @UnknownKeyFor @NonNull @Initialized IOException {
        char c;
        int j;
        int bytesStart = 0;
        int bytesEnd = 0;
        for (j = line.length() - 1; j >= 0; --j) {
            c = line.charAt(j);
            if (!Character.isDigit(c)) continue;
            bytesEnd = j + 1;
            break;
        }
        while (j >= 0) {
            c = line.charAt(j);
            if (!Character.isDigit(c) && c != ',' && c != '.') {
                bytesStart = j + 1;
                break;
            }
            --j;
        }
        if (j < 0) {
            throw new IOException("Command line 'dir /-c' did not return valid info for path '" + path + "'");
        }
        StringBuilder buf = new StringBuilder(line.substring(bytesStart, bytesEnd));
        for (int k = 0; k < buf.length(); ++k) {
            if (buf.charAt(k) != ',' && buf.charAt(k) != '.') continue;
            buf.deleteCharAt(k--);
        }
        return this.parseBytes(buf.toString(), path);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @UnknownKeyFor @NonNull @Initialized long freeSpaceUnix(@UnknownKeyFor @NonNull @Initialized String path, @UnknownKeyFor @NonNull @Initialized boolean kb, @UnknownKeyFor @NonNull @Initialized boolean posix, @UnknownKeyFor @NonNull @Initialized long timeout) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String[] stringArray;
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Path must not be empty");
        }
        String flags = "-";
        if (kb) {
            flags = flags + "k";
        }
        if (posix) {
            flags = flags + "P";
        }
        if (flags.length() > 1) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = DF;
            stringArray2[1] = flags;
            stringArray = stringArray2;
            stringArray2[2] = path;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = DF;
            stringArray = stringArray3;
            stringArray3[1] = path;
        }
        String[] cmdAttribs = stringArray;
        List<String> lines = this.performCommand(cmdAttribs, 3, timeout);
        if (lines.size() < 2) {
            throw new IOException("Command line '" + DF + "' did not return info as expected for path '" + path + "'- response was " + lines);
        }
        String line2 = lines.get(1);
        StringTokenizer tok = new StringTokenizer(line2, " ");
        if (tok.countTokens() < 4) {
            if (tok.countTokens() != 1 || lines.size() < 3) throw new IOException("Command line '" + DF + "' did not return data as expected for path '" + path + "'- check path is valid");
            String line3 = lines.get(2);
            tok = new StringTokenizer(line3, " ");
        } else {
            tok.nextToken();
        }
        tok.nextToken();
        tok.nextToken();
        String freeSpace = tok.nextToken();
        return this.parseBytes(freeSpace, path);
    }

    @UnknownKeyFor @NonNull @Initialized long parseBytes(@UnknownKeyFor @NonNull @Initialized String freeSpace, @UnknownKeyFor @NonNull @Initialized String path) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            long bytes = Long.parseLong(freeSpace);
            if (bytes < 0L) {
                throw new IOException("Command line '" + DF + "' did not find free space in response for path '" + path + "'- check path is valid");
            }
            return bytes;
        }
        catch (NumberFormatException ex) {
            throw new IOException("Command line '" + DF + "' did not return numeric data as expected for path '" + path + "'- check path is valid", ex);
        }
    }

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> performCommand(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] cmdAttribs, @UnknownKeyFor @NonNull @Initialized int max, @UnknownKeyFor @NonNull @Initialized long timeout) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList<String> arrayList;
        ArrayList<String> lines = new ArrayList<String>(20);
        Process proc = null;
        InputStream in = null;
        OutputStream out = null;
        InputStream err = null;
        BufferedReader inr = null;
        try {
            Thread monitor = ThreadMonitor.start(timeout);
            proc = this.openProcess(cmdAttribs);
            in = proc.getInputStream();
            out = proc.getOutputStream();
            err = proc.getErrorStream();
            inr = new BufferedReader(new InputStreamReader(in, Charset.defaultCharset()));
            String line = inr.readLine();
            while (line != null && lines.size() < max) {
                line = line.toLowerCase(Locale.ENGLISH).trim();
                lines.add(line);
                line = inr.readLine();
            }
            proc.waitFor();
            ThreadMonitor.stop(monitor);
            if (proc.exitValue() != 0) {
                throw new IOException("Command line returned OS error code '" + proc.exitValue() + "' for command " + Arrays.asList(cmdAttribs));
            }
            if (lines.isEmpty()) {
                throw new IOException("Command line did not return any info for command " + Arrays.asList(cmdAttribs));
            }
            inr.close();
            inr = null;
            in.close();
            in = null;
            if (out != null) {
                out.close();
                out = null;
            }
            if (err != null) {
                err.close();
                err = null;
            }
            arrayList = lines;
        }
        catch (InterruptedException ex) {
            try {
                throw new IOException("Command line threw an InterruptedException for command " + Arrays.asList(cmdAttribs) + " timeout=" + timeout, ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                IOUtils.closeQuietly(err);
                IOUtils.closeQuietly(inr);
                if (proc != null) {
                    proc.destroy();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
        IOUtils.closeQuietly(out);
        IOUtils.closeQuietly(err);
        IOUtils.closeQuietly(inr);
        if (proc != null) {
            proc.destroy();
        }
        return arrayList;
    }

    @UnknownKeyFor @NonNull @Initialized Process openProcess(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] cmdAttribs) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return Runtime.getRuntime().exec(cmdAttribs);
    }

    static {
        int os = 0;
        String dfPath = "df";
        try {
            String osName = System.getProperty("os.name");
            if (osName == null) {
                throw new IOException("os.name not found");
            }
            if ((osName = osName.toLowerCase(Locale.ENGLISH)).contains("windows")) {
                os = 1;
            } else if (osName.contains("linux") || osName.contains("mpe/ix") || osName.contains("freebsd") || osName.contains("openbsd") || osName.contains("irix") || osName.contains("digital unix") || osName.contains("unix") || osName.contains("mac os x")) {
                os = 2;
            } else if (osName.contains("sun os") || osName.contains("sunos") || osName.contains("solaris")) {
                os = 3;
                dfPath = "/usr/xpg4/bin/df";
            } else {
                os = osName.contains("hp-ux") || osName.contains("aix") ? 3 : 0;
            }
        }
        catch (Exception ex) {
            os = -1;
        }
        OS = os;
        DF = dfPath;
    }
}

