/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.xml.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.model.xml.Model;
import org.camunda.bpm.model.xml.ModelException;
import org.camunda.bpm.model.xml.impl.util.ModelUtil;
import org.camunda.bpm.model.xml.impl.util.QName;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.type.ModelElementType;

public class ModelImpl
implements Model {
    private final Map<QName, ModelElementType> typesByName = new HashMap<QName, ModelElementType>();
    private final Map<Class<? extends ModelElementInstance>, ModelElementType> typesByClass = new HashMap<Class<? extends ModelElementInstance>, ModelElementType>();
    private final String modelName;
    protected final Map<String, Set<String>> actualNsToAlternative = new HashMap<String, Set<String>>();
    protected final Map<String, String> alternativeNsToActual = new HashMap<String, String>();

    public ModelImpl(String modelName) {
        this.modelName = modelName;
    }

    public void declareAlternativeNamespace(String alternativeNs, String actualNs) {
        Set<String> alternativeNamespaces = this.actualNsToAlternative.get(actualNs);
        if (alternativeNamespaces == null) {
            alternativeNamespaces = new LinkedHashSet<String>();
            this.actualNsToAlternative.put(actualNs, alternativeNamespaces);
        }
        alternativeNamespaces.add(alternativeNs);
        this.alternativeNsToActual.put(alternativeNs, actualNs);
    }

    public void undeclareAlternativeNamespace(String alternativeNs) {
        if (!this.alternativeNsToActual.containsKey(alternativeNs)) {
            return;
        }
        String actual = this.alternativeNsToActual.remove(alternativeNs);
        this.actualNsToAlternative.remove(actual);
    }

    @Override
    public Set<String> getAlternativeNamespaces(String actualNs) {
        return this.actualNsToAlternative.get(actualNs);
    }

    @Override
    public String getAlternativeNamespace(String actualNs) {
        Set<String> alternatives = this.getAlternativeNamespaces(actualNs);
        if (alternatives == null || alternatives.size() == 0) {
            return null;
        }
        if (alternatives.size() == 1) {
            return alternatives.iterator().next();
        }
        throw new ModelException("There is more than one alternative namespace registered");
    }

    @Override
    public String getActualNamespace(String alternativeNs) {
        return this.alternativeNsToActual.get(alternativeNs);
    }

    @Override
    public Collection<ModelElementType> getTypes() {
        return new ArrayList<ModelElementType>(this.typesByName.values());
    }

    @Override
    public ModelElementType getType(Class<? extends ModelElementInstance> instanceClass) {
        return this.typesByClass.get(instanceClass);
    }

    @Override
    public ModelElementType getTypeForName(String typeName) {
        return this.getTypeForName(null, typeName);
    }

    @Override
    public ModelElementType getTypeForName(String namespaceUri, String typeName) {
        return this.typesByName.get(ModelUtil.getQName(namespaceUri, typeName));
    }

    public void registerType(ModelElementType modelElementType, Class<? extends ModelElementInstance> instanceType) {
        QName qName = ModelUtil.getQName(modelElementType.getTypeNamespace(), modelElementType.getTypeName());
        this.typesByName.put(qName, modelElementType);
        this.typesByClass.put(instanceType, modelElementType);
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.modelName == null ? 0 : this.modelName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelImpl other = (ModelImpl)obj;
        return !(this.modelName == null ? other.modelName != null : !this.modelName.equals(other.modelName));
    }
}

