/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.spring;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.scripting.engine.Resolver;
import org.camunda.bpm.engine.impl.scripting.engine.ResolverFactory;
import org.springframework.context.ApplicationContext;

public class SpringBeansResolverFactory
implements ResolverFactory,
Resolver {
    private ApplicationContext applicationContext;
    private Set<String> keySet;

    public SpringBeansResolverFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        String[] beannames = applicationContext.getBeanDefinitionNames();
        this.keySet = new HashSet<String>(Arrays.asList(beannames));
    }

    public Resolver createResolver(VariableScope variableScope) {
        return this;
    }

    public boolean containsKey(Object key) {
        if (key instanceof String) {
            return this.keySet.contains((String)key);
        }
        return false;
    }

    public Object get(Object key) {
        if (key instanceof String) {
            return this.applicationContext.getBean((String)key);
        }
        return null;
    }

    public Set<String> keySet() {
        return this.keySet;
    }
}

