/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.extra.config.generic;

import java.io.InputStream;
import java.util.LinkedList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.cache2k.extra.config.generic.AbstractConfigurationTokenizer;
import org.cache2k.extra.config.generic.ConfigurationTokenizer;
import org.cache2k.extra.config.generic.TokenizerFactory;

public class StaxConfigTokenizer
extends AbstractConfigurationTokenizer {
    private final XMLStreamReader input;
    private final LinkedList<String> hierarchy = new LinkedList();
    private String startName;
    private String value;

    public StaxConfigTokenizer(String source, InputStream in, String encoding) throws XMLStreamException {
        super(source);
        XMLInputFactory f = XMLInputFactory.newInstance();
        this.input = f.createXMLStreamReader(in, encoding);
    }

    @Override
    public int getLineNumber() {
        return this.input.getLocation().getLineNumber();
    }

    @Override
    public ConfigurationTokenizer.Item next() throws Exception {
        while (this.input.hasNext()) {
            int type = this.input.next();
            switch (type) {
                case 1: {
                    if (this.startName != null) {
                        this.hierarchy.push(this.startName);
                        this.startName = this.input.getLocalName();
                        return this.returnNest(this.hierarchy.element());
                    }
                    this.startName = this.input.getLocalName();
                    break;
                }
                case 4: {
                    this.value = this.input.getText();
                    break;
                }
                case 2: {
                    String name = this.input.getLocalName();
                    if (this.startName != null && this.startName.equals(name)) {
                        this.startName = null;
                        return this.returnProperty(name, this.value);
                    }
                    if (!name.equals(this.hierarchy.element())) break;
                    this.hierarchy.pop();
                    return this.returnUnnest();
                }
            }
        }
        return null;
    }

    public static class Factory
    implements TokenizerFactory {
        @Override
        public ConfigurationTokenizer createTokenizer(String source, InputStream in, String encoding) throws XMLStreamException {
            return new StaxConfigTokenizer(source, in, encoding);
        }
    }
}

