/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.extra.config.generic;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import org.cache2k.config.CacheType;
import org.cache2k.extra.config.generic.PropertyParser;
import org.cache2k.extra.config.generic.ValueConverter;

public class StandardPropertyParser
implements PropertyParser {
    private final Map<Class<?>, ValueConverter> type2parser = new HashMap();
    private static final Map<String, Long> UNIT2LONG = new HashMap<String, Long>(){
        {
            this.put("KiB", 1024L);
            this.put("MiB", 0x100000L);
            this.put("GiB", 0x40000000L);
            this.put("TiB", 0x10000000000L);
            this.put("k", 1000L);
            this.put("M", 1000000L);
            this.put("G", 1000000000L);
            this.put("T", 1000000000000L);
            this.put("s", 1000L);
            this.put("m", 60000L);
            this.put("h", 3600000L);
            this.put("d", 86400000L);
        }
    };

    public StandardPropertyParser() {
        this.addParser(Integer.TYPE, Integer.class, new ValueConverter<Integer>(){

            @Override
            public Integer parse(String v) {
                return Integer.valueOf(v);
            }
        });
        this.addParser(Boolean.TYPE, Boolean.class, new ValueConverter<Boolean>(){

            @Override
            public Boolean parse(String v) {
                if ("true".equals(v = v.toLowerCase())) {
                    return true;
                }
                if ("false".equals(v)) {
                    return false;
                }
                throw new IllegalArgumentException("no boolean, true/false expected");
            }
        });
        this.addParser(Long.TYPE, Long.class, new ValueConverter<Long>(){

            @Override
            public Long parse(String v) {
                return StandardPropertyParser.parseLongWithUnitSuffix(v);
            }
        });
        this.addParser(Duration.class, new ValueConverter<Duration>(){

            @Override
            public Duration parse(String v) {
                return Duration.of(StandardPropertyParser.parseLongWithUnitSuffix(v), ChronoUnit.MILLIS);
            }
        });
        this.addParser(String.class, new ValueConverter<String>(){

            @Override
            public String parse(String v) {
                return v;
            }
        });
        this.addParser(CacheType.class, new ValueConverter<CacheType>(){

            @Override
            public CacheType parse(String v) throws Exception {
                if (!v.contains(".")) {
                    v = "java.lang." + v;
                }
                return CacheType.of(Class.forName(v));
            }
        });
    }

    @Override
    public Object parse(Class<?> targetType, String value) throws Exception {
        ValueConverter p = this.type2parser.get(targetType);
        if (p == null) {
            throw new IllegalArgumentException("Unknown target type: " + targetType);
        }
        return p.parse(value);
    }

    private void addParser(Class<?> type, ValueConverter<?> p) {
        this.type2parser.put(type, p);
    }

    private void addParser(Class<?> primitiveType, Class<?> type, ValueConverter<?> p) {
        this.type2parser.put(primitiveType, p);
        this.type2parser.put(type, p);
    }

    public static long parseLongWithUnitSuffix(String v) {
        v = v.replace("_", "");
        long multiplier = 1L;
        int pos = v.length();
        while (--pos >= 0 && !Character.isDigit(v.charAt(pos))) {
        }
        if (pos < v.length() - 1) {
            String unitSuffix = v.substring(pos + 1);
            Long newMultiplier = UNIT2LONG.get(unitSuffix);
            if (newMultiplier == null) {
                throw new NumberFormatException("Unknown unit suffix in: \"" + v + "\"");
            }
            v = v.substring(0, pos + 1);
            multiplier = newMultiplier;
        }
        return Long.valueOf(v) * multiplier;
    }
}

