/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.tesseract;

import java.util.Arrays;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.annotation.StdString;
import org.bytedeco.javacpp.annotation.ValueSetter;
import org.bytedeco.tesseract.presets.tesseract;

@Name(value={"std::vector<std::string>"})
@Properties(inherit={tesseract.class})
public class StringVector
extends Pointer {
    public StringVector(Pointer p) {
        super(p);
    }

    public StringVector(BytePointer value) {
        this(1L);
        this.put(0L, value);
    }

    public StringVector(BytePointer ... array) {
        this(array.length);
        this.put(array);
    }

    public StringVector(String value) {
        this(1L);
        this.put(0L, value);
    }

    public StringVector(String ... array) {
        this(array.length);
        this.put(array);
    }

    public StringVector() {
        this.allocate();
    }

    public StringVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native StringVector put(@ByRef StringVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    @Index(function="at")
    @StdString
    public native BytePointer get(@Cast(value={"size_t"}) long var1);

    public native StringVector put(@Cast(value={"size_t"}) long var1, BytePointer var3);

    @ValueSetter
    @Index(function="at")
    public native StringVector put(@Cast(value={"size_t"}) long var1, @StdString String var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @StdString BytePointer var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public BytePointer[] get() {
        BytePointer[] array = new BytePointer[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.get());
    }

    public BytePointer pop_back() {
        long size = this.size();
        BytePointer value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public StringVector push_back(BytePointer value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public StringVector put(BytePointer value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public StringVector put(BytePointer ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put((long)i, array[i]);
        }
        return this;
    }

    public StringVector push_back(String value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public StringVector put(String value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public StringVector put(String ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put((long)i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @StdString
        public native BytePointer get();
    }
}

