/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.leptonica;

import java.nio.DoubleBuffer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.Indexable;
import org.bytedeco.leptonica.DPIX;
import org.bytedeco.leptonica.presets.lept;

@Properties(inherit={lept.class})
public abstract class AbstractDPIX
extends Pointer
implements Indexable {
    public AbstractDPIX(Pointer p) {
        super(p);
    }

    public static DPIX create(int width, int height) {
        DPIX p = org.bytedeco.leptonica.global.lept.dpixCreate(width, height);
        if (p != null) {
            p.deallocator(new DestroyDeallocator(p));
        }
        return p;
    }

    public static DPIX createTemplate(DPIX dpixs) {
        DPIX p = org.bytedeco.leptonica.global.lept.dpixCreateTemplate(dpixs);
        if (p != null) {
            p.deallocator(new DestroyDeallocator(p));
        }
        return p;
    }

    public DPIX clone() {
        DPIX p = new DPIX(org.bytedeco.leptonica.global.lept.dpixClone((DPIX)this));
        if (p != null) {
            p.deallocator(new DestroyDeallocator(p));
        }
        return p;
    }

    public DoubleBuffer createBuffer() {
        return this.createBuffer(0);
    }

    public DoubleBuffer createBuffer(int index) {
        int[] w = new int[]{0};
        int[] h = new int[]{0};
        org.bytedeco.leptonica.global.lept.dpixGetDimensions((DPIX)this, w, h);
        int wpl = org.bytedeco.leptonica.global.lept.dpixGetWpl((DPIX)this);
        DoublePointer data = new DoublePointer((Pointer)org.bytedeco.leptonica.global.lept.dpixGetData((DPIX)this)).position((long)index).capacity((long)(h[0] * wpl));
        return data.asBuffer();
    }

    public DoubleIndexer createIndexer() {
        return this.createIndexer(true);
    }

    public DoubleIndexer createIndexer(boolean direct) {
        int[] w = new int[]{0};
        int[] h = new int[]{0};
        org.bytedeco.leptonica.global.lept.dpixGetDimensions((DPIX)this, w, h);
        int wpl = org.bytedeco.leptonica.global.lept.dpixGetWpl((DPIX)this);
        long[] sizes = new long[]{h[0], w[0], wpl / w[0]};
        long[] strides = new long[]{wpl, wpl / w[0], 1L};
        DoublePointer data = new DoublePointer((Pointer)org.bytedeco.leptonica.global.lept.dpixGetData((DPIX)this)).capacity((long)(h[0] * wpl));
        return DoubleIndexer.create((DoublePointer)data, (long[])sizes, (long[])strides, (boolean)direct);
    }

    public void destroy() {
        this.deallocate();
    }

    protected static class DestroyDeallocator
    extends DPIX
    implements Pointer.Deallocator {
        DestroyDeallocator(DPIX p) {
            super(p);
        }

        public void deallocate() {
            if (this.isNull()) {
                return;
            }
            org.bytedeco.leptonica.global.lept.dpixDestroy(this);
            this.setNull();
        }
    }
}

