/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.math.BigInteger;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Raw;
import org.bytedeco.javacpp.indexer.ULongIndexer;

public class ULongRawIndexer
extends ULongIndexer {
    protected static final Raw RAW = Raw.getInstance();
    protected LongPointer pointer;
    final long base;
    final long size;

    public ULongRawIndexer(LongPointer pointer) {
        this(pointer, new long[]{pointer.limit() - pointer.position()}, ONE_STRIDE);
    }

    public ULongRawIndexer(LongPointer pointer, long ... sizes) {
        this(pointer, sizes, ULongRawIndexer.strides(sizes));
    }

    public ULongRawIndexer(LongPointer pointer, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.pointer = pointer;
        this.base = pointer.address() + pointer.position() * 8L;
        this.size = pointer.limit() - pointer.position();
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    @Override
    public BigInteger get(long i) {
        return ULongRawIndexer.toBigInteger(RAW.getLong(this.base + ULongRawIndexer.checkIndex(i, this.size) * 8L));
    }

    @Override
    public ULongIndexer get(long i, BigInteger[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            l[offset + n] = this.get(i * this.strides[0] + (long)n);
        }
        return this;
    }

    @Override
    public BigInteger get(long i, long j) {
        return this.get(i * this.strides[0] + j);
    }

    @Override
    public ULongIndexer get(long i, long j, BigInteger[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            l[offset + n] = this.get(i * this.strides[0] + j * this.strides[1] + (long)n);
        }
        return this;
    }

    @Override
    public BigInteger get(long i, long j, long k) {
        return this.get(i * this.strides[0] + j * this.strides[1] + k);
    }

    @Override
    public BigInteger get(long ... indices) {
        return this.get(this.index(indices));
    }

    @Override
    public ULongIndexer get(long[] indices, BigInteger[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            l[offset + n] = this.get(this.index(indices) + (long)n);
        }
        return this;
    }

    @Override
    public ULongIndexer put(long i, BigInteger l) {
        RAW.putLong(this.base + ULongRawIndexer.checkIndex(i, this.size) * 8L, ULongRawIndexer.fromBigInteger(l));
        return this;
    }

    @Override
    public ULongIndexer put(long i, BigInteger[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(i * this.strides[0] + (long)n, l[offset + n]);
        }
        return this;
    }

    @Override
    public ULongIndexer put(long i, long j, BigInteger l) {
        this.put(i * this.strides[0] + j, l);
        return this;
    }

    @Override
    public ULongIndexer put(long i, long j, BigInteger[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(i * this.strides[0] + j * this.strides[1] + (long)n, l[offset + n]);
        }
        return this;
    }

    @Override
    public ULongIndexer put(long i, long j, long k, BigInteger l) {
        this.put(i * this.strides[0] + j * this.strides[1] + k, l);
        return this;
    }

    @Override
    public ULongIndexer put(long[] indices, BigInteger l) {
        this.put(this.index(indices), l);
        return this;
    }

    @Override
    public ULongIndexer put(long[] indices, BigInteger[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(this.index(indices) + (long)n, l[offset + n]);
        }
        return this;
    }

    @Override
    public void release() {
        this.pointer = null;
    }
}

