/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.indexer.Bfloat16Indexer;

public class Bfloat16ArrayIndexer
extends Bfloat16Indexer {
    protected short[] array;

    public Bfloat16ArrayIndexer(short[] array) {
        this(array, new long[]{array.length}, ONE_STRIDE);
    }

    public Bfloat16ArrayIndexer(short[] array, long ... sizes) {
        this(array, sizes, Bfloat16ArrayIndexer.strides(sizes));
    }

    public Bfloat16ArrayIndexer(short[] array, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.array = array;
    }

    public short[] array() {
        return this.array;
    }

    @Override
    public float get(long i) {
        return Bfloat16ArrayIndexer.toFloat(this.array[(int)i]);
    }

    @Override
    public Bfloat16Indexer get(long i, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            h[offset + n] = Bfloat16ArrayIndexer.toFloat(this.array[(int)i * (int)this.strides[0] + n]);
        }
        return this;
    }

    @Override
    public float get(long i, long j) {
        return Bfloat16ArrayIndexer.toFloat(this.array[(int)i * (int)this.strides[0] + (int)j]);
    }

    @Override
    public Bfloat16Indexer get(long i, long j, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            h[offset + n] = Bfloat16ArrayIndexer.toFloat(this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n]);
        }
        return this;
    }

    @Override
    public float get(long i, long j, long k) {
        return Bfloat16ArrayIndexer.toFloat(this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k]);
    }

    @Override
    public float get(long ... indices) {
        return Bfloat16ArrayIndexer.toFloat(this.array[(int)this.index(indices)]);
    }

    @Override
    public Bfloat16Indexer get(long[] indices, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            h[offset + n] = Bfloat16ArrayIndexer.toFloat(this.array[(int)this.index(indices) + n]);
        }
        return this;
    }

    @Override
    public Bfloat16Indexer put(long i, float h) {
        this.array[(int)i] = (short)Bfloat16ArrayIndexer.fromFloat(h);
        return this;
    }

    @Override
    public Bfloat16Indexer put(long i, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + n] = (short)Bfloat16ArrayIndexer.fromFloat(h[offset + n]);
        }
        return this;
    }

    @Override
    public Bfloat16Indexer put(long i, long j, float h) {
        this.array[(int)i * (int)this.strides[0] + (int)j] = (short)Bfloat16ArrayIndexer.fromFloat(h);
        return this;
    }

    @Override
    public Bfloat16Indexer put(long i, long j, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n] = (short)Bfloat16ArrayIndexer.fromFloat(h[offset + n]);
        }
        return this;
    }

    @Override
    public Bfloat16Indexer put(long i, long j, long k, float h) {
        this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k] = (short)Bfloat16ArrayIndexer.fromFloat(h);
        return this;
    }

    @Override
    public Bfloat16Indexer put(long[] indices, float h) {
        this.array[(int)this.index((long[])indices)] = (short)Bfloat16ArrayIndexer.fromFloat(h);
        return this;
    }

    @Override
    public Bfloat16Indexer put(long[] indices, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)this.index((long[])indices) + n] = (short)Bfloat16ArrayIndexer.fromFloat(h[offset + n]);
        }
        return this;
    }

    @Override
    public void release() {
        this.array = null;
    }
}

