/*
 * Decompiled with CFR 0.152.
 */
package hdf.hdf5lib;

import hdf.hdf5lib.exceptions.HDF5Exception;
import hdf.hdf5lib.exceptions.HDF5JavaException;

public class HDFNativeData {
    public static synchronized native int[] byteToInt(byte[] var0);

    public static synchronized native float[] byteToFloat(byte[] var0);

    public static synchronized native short[] byteToShort(byte[] var0);

    public static synchronized native long[] byteToLong(byte[] var0);

    public static synchronized native double[] byteToDouble(byte[] var0);

    public static synchronized native int[] byteToInt(int var0, int var1, byte[] var2);

    public static synchronized int byteToInt(byte[] data, int start) {
        int[] ival = new int[1];
        ival = HDFNativeData.byteToInt(start, 1, data);
        return ival[0];
    }

    public static synchronized native short[] byteToShort(int var0, int var1, byte[] var2);

    public static synchronized short byteToShort(byte[] data, int start) {
        short[] sval = new short[1];
        sval = HDFNativeData.byteToShort(start, 1, data);
        return sval[0];
    }

    public static synchronized native float[] byteToFloat(int var0, int var1, byte[] var2);

    public static synchronized float byteToFloat(byte[] data, int start) {
        float[] fval = new float[1];
        fval = HDFNativeData.byteToFloat(start, 1, data);
        return fval[0];
    }

    public static synchronized native long[] byteToLong(int var0, int var1, byte[] var2);

    public static synchronized long byteToLong(byte[] data, int start) {
        long[] lval = new long[1];
        lval = HDFNativeData.byteToLong(start, 1, data);
        return lval[0];
    }

    public static synchronized native double[] byteToDouble(int var0, int var1, byte[] var2);

    public static synchronized double byteToDouble(byte[] data, int start) {
        double[] dval = new double[1];
        dval = HDFNativeData.byteToDouble(start, 1, data);
        return dval[0];
    }

    public static synchronized native byte[] intToByte(int var0, int var1, int[] var2);

    public static synchronized native byte[] shortToByte(int var0, int var1, short[] var2);

    public static synchronized native byte[] floatToByte(int var0, int var1, float[] var2);

    public static synchronized native byte[] longToByte(int var0, int var1, long[] var2);

    public static synchronized native byte[] doubleToByte(int var0, int var1, double[] var2);

    public static synchronized native byte[] byteToByte(byte var0);

    public static synchronized byte[] byteToByte(Byte data) {
        return HDFNativeData.byteToByte((byte)data);
    }

    public static synchronized native byte[] intToByte(int var0);

    public static synchronized byte[] intToByte(Integer data) {
        return HDFNativeData.intToByte((int)data);
    }

    public static synchronized native byte[] shortToByte(short var0);

    public static synchronized byte[] shortToByte(Short data) {
        return HDFNativeData.shortToByte((short)data);
    }

    public static synchronized native byte[] floatToByte(float var0);

    public static synchronized byte[] floatToByte(Float data) {
        return HDFNativeData.floatToByte(data.floatValue());
    }

    public static synchronized native byte[] longToByte(long var0);

    public static synchronized byte[] longToByte(Long data) {
        return HDFNativeData.longToByte((long)data);
    }

    public static synchronized native byte[] doubleToByte(double var0);

    public static synchronized byte[] doubleToByte(Double data) {
        return HDFNativeData.doubleToByte((double)data);
    }

    public static synchronized Object byteToNumber(byte[] barray, Object obj) throws HDF5Exception {
        Class<?> theClass = obj.getClass();
        String type = theClass.getName();
        Number retobj = null;
        if (type.equals("java.lang.Integer")) {
            int[] i = HDFNativeData.byteToInt(0, 1, barray);
            retobj = i[0];
        } else if (type.equals("java.lang.Byte")) {
            retobj = barray[0];
        } else if (type.equals("java.lang.Short")) {
            short[] f = HDFNativeData.byteToShort(0, 1, barray);
            retobj = f[0];
        } else if (type.equals("java.lang.Float")) {
            float[] f = HDFNativeData.byteToFloat(0, 1, barray);
            retobj = Float.valueOf(f[0]);
        } else if (type.equals("java.lang.Long")) {
            long[] f = HDFNativeData.byteToLong(0, 1, barray);
            retobj = f[0];
        } else if (type.equals("java.lang.Double")) {
            double[] f = HDFNativeData.byteToDouble(0, 1, barray);
            retobj = f[0];
        } else {
            HDF5JavaException ex = new HDF5JavaException("byteToNumber: setfield bad type: " + obj + " " + type);
            throw ex;
        }
        return retobj;
    }
}

