/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.util;

import java.util.List;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.transaction.UserTransaction;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jboss.ejb3.entity.HibernateSession;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HibernateUtil {
    private static EntityManager session;
    private static final Logger log;

    static {
        log = Logger.getLogger(HibernateUtil.class);
    }

    public static synchronized void initEM() {
        if (session == null) {
            try {
                InitialContext ctx = new InitialContext();
                session = (EntityManager)ctx.lookup("java:/EntityManagers/mail");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static UserTransaction getUserTransaction() throws Exception {
        InitialContext ctx = new InitialContext();
        return (UserTransaction)ctx.lookup("UserTransaction");
    }

    public static Session getSession() throws HibernateException {
        if (session == null) {
            HibernateUtil.initEM();
        }
        return ((HibernateSession)session).getHibernateSession();
    }

    public static Transaction getTransaction(Session session, String name) throws HibernateException {
        Transaction t = session.beginTransaction();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Begin Transaction: " + name + ":" + System.identityHashCode(t)));
        }
        return t;
    }

    public static void safeCloseSession(Logger log, Session session) {
        if (session == null) {
            log.warn((Object)"Session is null");
        }
    }

    public static void safeCommit(Logger log, Transaction tx) {
        block6: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Commit Transaction: " + System.identityHashCode(tx)));
            }
            if (tx != null) {
                try {
                    tx.commit();
                }
                catch (Exception e) {
                    if (log != null) {
                        log.error((Object)e.toString(), (Throwable)e);
                        break block6;
                    }
                    e.printStackTrace();
                }
            } else {
                log.warn((Object)"Transaction is null");
            }
        }
    }

    public static void safeRollback(Logger log, Transaction tx) {
        block6: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Rollback Transaction: " + System.identityHashCode(tx)));
            }
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e) {
                    if (log != null) {
                        log.error((Object)e.toString(), (Throwable)e);
                        break block6;
                    }
                    e.printStackTrace();
                }
            } else {
                log.warn((Object)"Transaction is null");
            }
        }
    }

    public static <T> T singleResult(Query query, Class<T> entityClass) {
        List resultlist = query.getResultList();
        T result = null;
        if (resultlist.size() > 1) {
            throw new RuntimeException("Constraint Violation - singleResult returned " + resultlist.size());
        }
        if (resultlist.size() == 1) {
            result = (T)resultlist.get(0);
        }
        return result;
    }
}

