/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.store.paged;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.buni.meldware.common.logging.Log;
import org.buni.meldware.mail.store.AbstractStore;
import org.buni.meldware.mail.store.BlobInputStream;
import org.buni.meldware.mail.store.BlobOutputStream;
import org.buni.meldware.mail.store.StoreException;
import org.buni.meldware.mail.store.StoreItemMetaData;
import org.buni.meldware.mail.store.paged.Blob;
import org.buni.meldware.mail.store.paged.Page;
import org.buni.meldware.mail.store.paged.PagedStoreMBean;
import org.hibernate.HibernateException;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationBase;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aspects.tx.Tx;
import org.jboss.aspects.tx.TxType;
import org.jboss.ejb3.entity.HibernateSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagedStore
extends AbstractStore
implements PagedStoreMBean,
Advised {
    static final Log log;
    private static ClassAdvisor aop$classAdvisor$aop;
    private static WeakReference aop$MethodInfo_read_N_150580156191630418;
    private static WeakReference aop$MethodInfo_getPage1818472756407716154;
    private static WeakReference aop$MethodInfo_write_N_7611023959546435916;
    private static WeakReference aop$MethodInfo_getBuffer_N_8328802641894955898;
    private static WeakReference aop$MethodInfo_delete_N_169551518371285982;
    private static WeakReference aop$MethodInfo_doCreate3781003712992460599;
    private static WeakReference aop$MethodInfo_getInputStream_N_2488121277901438923;
    private static WeakReference aop$MethodInfo_getOutputStream_N_3211327161428875046;
    private static WeakReference aop$MethodInfo_listBlobs5933545041233380426;
    private static WeakReference aop$MethodInfo_cleanUp_N_192585779096417288;

    static {
        aop$classAdvisor$aop = AspectManager.instance().getAdvisor(Class.forName("org.buni.meldware.mail.store.paged.PagedStore"));
        log = Log.getLog(PagedStore.class);
    }

    @Override
    public void init() throws StoreException {
    }

    public String idToString(Object id) {
        return id.toString();
    }

    public Object stringToId(String s) {
        return new Long(s);
    }

    @Tx(value=TxType.REQUIRED)
    public int org$buni$meldware$mail$store$paged$PagedStore$read$aop(Long id, long position, byte[] b, int off, int len) throws StoreException {
        this.emInit();
        log.debug("Read, Id: %d, Position: %d, Offset: %d, Length: %d", new Object[]{id, position, off, len});
        try {
            Blob blob = (Blob)this.session.find(Blob.class, (Object)id);
            int pageSize = blob.getPageSize();
            int firstPage = (int)(position / (long)pageSize);
            int pageOffset = (int)(position % (long)pageSize);
            int numPages = (int)Math.ceil((double)(pageOffset + len) / (double)pageSize);
            int totalBytes = 0;
            if (position < blob.getLength()) {
                int inputOffset = pageOffset;
                int outputOffset = off;
                int i = firstPage;
                while (i < firstPage + numPages && i < blob.getNumPages()) {
                    Page page = this.getPage(this.session, id, i);
                    int outputLength = Math.min(page.getSize() - inputOffset, len - totalBytes);
                    System.arraycopy(page.getData(), inputOffset, b, outputOffset, outputLength);
                    inputOffset = 0;
                    outputOffset += outputLength;
                    totalBytes += outputLength;
                    ++i;
                }
            } else {
                totalBytes = 0;
            }
            this.session.flush();
            ((HibernateSession)this.session).getHibernateSession().clear();
            return totalBytes;
        }
        catch (StoreException e) {
            String errorMsg = "Failed to read. " + PagedStore.formatArgs(id, position, off, len) + ". Reason:" + e.getMessage();
            log.error((Object)errorMsg);
            throw e;
        }
        catch (Throwable t) {
            String errorMsg = "Failed to read. " + PagedStore.formatArgs(id, position, off, len) + ". Reason:" + t.getMessage();
            log.error((Object)errorMsg);
            throw new StoreException(t);
        }
    }

    @Tx(value=TxType.REQUIRED)
    private Page org$buni$meldware$mail$store$paged$PagedStore$getPage$aop(EntityManager session, Long id, int pageNo) throws HibernateException, StoreException {
        this.emInit();
        String sql = "from Page where blobId = :bid and pageNo = :pid";
        Query q = session.createQuery(sql).setParameter("bid", (Object)id).setParameter("pid", (Object)pageNo).setMaxResults(1);
        List pages = q.getResultList();
        if (pages.size() == 0) {
            throw new StoreException("Page not found.  Id: " + id + " Page number: " + pageNo);
        }
        return (Page)pages.get(0);
    }

    @Tx(value=TxType.REQUIRED)
    public int org$buni$meldware$mail$store$paged$PagedStore$write$aop(Long id, long position, byte[] b, int off, int len) throws StoreException {
        this.emInit();
        log.debug("Write, Id: %d, Position: %d, Offset: %d, Length: %d", new Object[]{id, position, off, len});
        try {
            Blob blob = (Blob)this.session.find(Blob.class, (Object)id);
            int pageSize = blob.getPageSize();
            int firstPage = (int)(position / (long)pageSize);
            int pageOffset = (int)(position % (long)pageSize);
            int numPages = (int)Math.ceil((double)(pageOffset + len) / (double)pageSize);
            int i = blob.getNumPages();
            while (i < firstPage) {
                Page page = new Page();
                blob.addPage(page);
                this.session.persist((Object)page);
                ++i;
            }
            if (firstPage > blob.getNumPages()) {
                throw new RuntimeException("First page: " + firstPage + " is well after: " + blob);
            }
            if (off == 0 && b.length == len && (len == pageSize || len < pageSize && firstPage == blob.getNumPages()) && position % (long)pageSize == 0L) {
                Page page;
                if (firstPage < blob.getNumPages()) {
                    page = this.getPage(this.session, id, firstPage);
                } else {
                    page = new Page();
                    blob.addPage(page);
                }
                page.setData(b);
                blob.updateLength(page);
                this.session.persist((Object)page);
            } else {
                int inputOffset = off;
                int outputOffset = pageOffset;
                int i2 = firstPage;
                while (i2 < firstPage + numPages) {
                    Page page;
                    if (i2 < blob.getNumPages()) {
                        page = this.getPage(this.session, id, firstPage);
                    } else {
                        page = new Page();
                        blob.addPage(page);
                    }
                    int outputLength = Math.min(pageSize - outputOffset, len - (inputOffset - off));
                    byte[] data = page.getData();
                    if (data.length < outputLength + outputOffset) {
                        byte[] newData = new byte[outputLength + outputOffset];
                        System.arraycopy(data, 0, newData, 0, data.length);
                        data = newData;
                        page.setData(data);
                    }
                    System.arraycopy(b, inputOffset, data, outputOffset, outputLength);
                    blob.updateLength(page);
                    this.session.persist((Object)page);
                    outputOffset = 0;
                    inputOffset += outputLength;
                    ++i2;
                }
            }
            this.session.persist((Object)blob);
            this.session.flush();
            ((HibernateSession)this.session).getHibernateSession().clear();
            return len;
        }
        catch (StoreException e) {
            String errorMsg = "Failed to write. " + PagedStore.formatArgs(id, position, off, len) + ". Reason:" + e.getMessage();
            log.error((Object)errorMsg);
            throw e;
        }
        catch (Throwable t) {
            String errorMsg = "Failed to write. " + PagedStore.formatArgs(id, position, off, len) + ". Reason:" + t.getMessage();
            log.error((Object)errorMsg);
            throw new StoreException(t);
        }
    }

    @Tx(value=TxType.REQUIRED)
    public ByteBuffer org$buni$meldware$mail$store$paged$PagedStore$getBuffer$aop(Long id, long position, int len) throws StoreException {
        this.emInit();
        log.debug("Get Buffer, Id: %d, Position: %d, Length: %d", new Object[]{id, position, len});
        try {
            ByteBuffer buffer;
            Blob blob = (Blob)this.session.find(Blob.class, (Object)id);
            int pageSize = blob.getPageSize();
            int firstPage = (int)(position / (long)pageSize);
            int pageOffset = (int)(position % (long)pageSize);
            int numPages = (int)Math.ceil((double)(pageOffset + len) / (double)pageSize);
            if (position < blob.getLength()) {
                if (len == pageSize && position % (long)pageSize == 0L) {
                    Page page = this.getPage(this.session, id, firstPage);
                    buffer = ByteBuffer.wrap(page.getData());
                } else {
                    byte[] data = new byte[(int)Math.min((long)len, blob.getLength() - position)];
                    int inputOffset = pageOffset;
                    int outputOffset = 0;
                    int i = firstPage;
                    while (i < firstPage + numPages && i < blob.getNumPages()) {
                        Page page = this.getPage(this.session, id, i);
                        int outputLength = Math.min(page.getSize() - inputOffset, len - outputOffset);
                        System.arraycopy(page.getData(), inputOffset, data, outputOffset, outputLength);
                        inputOffset = 0;
                        outputOffset += outputLength;
                        ++i;
                    }
                    buffer = ByteBuffer.wrap(data);
                }
            } else {
                buffer = ByteBuffer.allocate(0);
            }
            this.session.flush();
            ((HibernateSession)this.session).getHibernateSession().clear();
            return buffer;
        }
        catch (StoreException e) {
            String errorMsg = "Failed to get buffer. " + PagedStore.formatArgs(id, position, 0, len) + ". Reason:" + e.getMessage();
            log.error((Object)errorMsg);
            throw e;
        }
        catch (Throwable t) {
            String errorMsg = "Failed to get buffer. " + PagedStore.formatArgs(id, position, 0, len) + ". Reason:" + t.getMessage();
            log.error((Object)errorMsg);
            throw new StoreException(errorMsg, t);
        }
    }

    @Tx(value=TxType.REQUIRED)
    public void org$buni$meldware$mail$store$paged$PagedStore$delete$aop(Long id) throws StoreException {
        this.emInit();
        try {
            String deleteBlob = "delete from Blob WHERE ID = :pms";
            String deletePage = "delete from Page WHERE blobId = :bid";
            this.session.createQuery(deletePage).setParameter("bid", (Object)id).executeUpdate();
            this.session.createQuery(deleteBlob).setParameter("pms", (Object)id).executeUpdate();
        }
        catch (Throwable t) {
            throw new StoreException("Unable to delete blob with id = " + id, t);
        }
    }

    @Tx(value=TxType.REQUIRED)
    public Long org$buni$meldware$mail$store$paged$PagedStore$doCreate$aop() throws StoreException {
        this.emInit();
        log.debug((Object)"Creating Store Item");
        try {
            Blob blob = new Blob();
            blob.setPageSize(this.getPageSize());
            Long id = (Long)((HibernateSession)this.session).getHibernateSession().save((Object)blob);
            this.session.flush();
            return id;
        }
        catch (HibernateException e) {
            String errorMsg = "Failed to create store item. " + e.getMessage();
            log.error((Object)errorMsg);
            throw new StoreException((Throwable)e);
        }
    }

    @Tx(value=TxType.REQUIRED)
    public InputStream org$buni$meldware$mail$store$paged$PagedStore$getInputStream$aop(Long id, StoreItemMetaData meta) throws StoreException {
        return new BlobInputStream(this, meta);
    }

    @Tx(value=TxType.REQUIRED)
    public OutputStream org$buni$meldware$mail$store$paged$PagedStore$getOutputStream$aop(Long id, StoreItemMetaData meta) throws StoreException {
        return new BlobOutputStream(this, meta);
    }

    private static String formatArgs(Object id, long position, int off, int len) {
        StringBuffer sb = new StringBuffer();
        sb.append("Id: ");
        sb.append(id);
        sb.append(" position: ");
        sb.append(position);
        sb.append(" offset ");
        sb.append(off);
        sb.append(" length: ");
        sb.append(len);
        return sb.toString();
    }

    @Tx(value=TxType.REQUIRED)
    public String org$buni$meldware$mail$store$paged$PagedStore$listBlobs$aop() throws HibernateException, NamingException {
        this.emInit();
        StringBuffer sb = new StringBuffer();
        org.hibernate.Query q = (org.hibernate.Query)this.session.createQuery("from org.buni.meldware.mail.store.paged.Blob");
        Iterator i = q.iterate();
        while (i.hasNext()) {
            Blob b = (Blob)i.next();
            sb.append("Id = " + b.getId());
            sb.append(", pages: " + b.getNumPages());
            sb.append(", size: " + b.getLength());
            sb.append("\n");
        }
        ((HibernateSession)this.session).getHibernateSession().clear();
        return sb.toString();
    }

    @Tx(value=TxType.REQUIRED)
    public void org$buni$meldware$mail$store$paged$PagedStore$cleanUp$aop(List<Long> bods) {
        this.emInit();
        String hql = "delete from Page where blobId in (:idlist)";
        this.session.createQuery(hql).setParameter("idlist", bods).executeUpdate();
        hql = "delete from Blob where id in (:idlist)";
        this.session.createQuery(hql).setParameter("idlist", bods).executeUpdate();
        hql = "delete from StoreItemMetaData s where s.pid in (:idlist)";
        this.session.createQuery(hql).setParameter("idlist", bods);
    }

    @Override
    public Advisor _getAdvisor() {
        return aop$classAdvisor$aop;
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public int read(Long l, long l2, byte[] byArray, int n, int n2) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_read_N_150580156191630418.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            read_N150580156191630418 read_N1505801561916304182 = new read_N150580156191630418(methodInfo, interceptorArray);
            read_N1505801561916304182.arg0 = l;
            read_N1505801561916304182.arg1 = l2;
            read_N1505801561916304182.arg2 = byArray;
            read_N1505801561916304182.arg3 = n;
            read_N1505801561916304182.arg4 = n2;
            read_N1505801561916304182.setTargetObject(this);
            read_N1505801561916304182.typedTargetObject = this;
            read_N1505801561916304182.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Integer)read_N1505801561916304182.invokeNext();
        }
        return this.org$buni$meldware$mail$store$paged$PagedStore$read$aop(l, l2, byArray, n, n2);
    }

    @Tx(value=TxType.REQUIRED)
    private Page getPage(EntityManager entityManager, Long l, int n) throws HibernateException, StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getPage1818472756407716154.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getPage_1818472756407716154 getPage_18184727564077161542 = new getPage_1818472756407716154(methodInfo, interceptorArray);
            getPage_18184727564077161542.arg0 = entityManager;
            getPage_18184727564077161542.arg1 = l;
            getPage_18184727564077161542.arg2 = n;
            getPage_18184727564077161542.setTargetObject(this);
            getPage_18184727564077161542.typedTargetObject = this;
            getPage_18184727564077161542.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Page)getPage_18184727564077161542.invokeNext();
        }
        return this.org$buni$meldware$mail$store$paged$PagedStore$getPage$aop(entityManager, l, n);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public int write(Long l, long l2, byte[] byArray, int n, int n2) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_write_N_7611023959546435916.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            write_N7611023959546435916 write_N76110239595464359162 = new write_N7611023959546435916(methodInfo, interceptorArray);
            write_N76110239595464359162.arg0 = l;
            write_N76110239595464359162.arg1 = l2;
            write_N76110239595464359162.arg2 = byArray;
            write_N76110239595464359162.arg3 = n;
            write_N76110239595464359162.arg4 = n2;
            write_N76110239595464359162.setTargetObject(this);
            write_N76110239595464359162.typedTargetObject = this;
            write_N76110239595464359162.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Integer)write_N76110239595464359162.invokeNext();
        }
        return this.org$buni$meldware$mail$store$paged$PagedStore$write$aop(l, l2, byArray, n, n2);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public ByteBuffer getBuffer(Long l, long l2, int n) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getBuffer_N_8328802641894955898.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getBuffer_N8328802641894955898 getBuffer_N83288026418949558982 = new getBuffer_N8328802641894955898(methodInfo, interceptorArray);
            getBuffer_N83288026418949558982.arg0 = l;
            getBuffer_N83288026418949558982.arg1 = l2;
            getBuffer_N83288026418949558982.arg2 = n;
            getBuffer_N83288026418949558982.setTargetObject(this);
            getBuffer_N83288026418949558982.typedTargetObject = this;
            getBuffer_N83288026418949558982.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (ByteBuffer)getBuffer_N83288026418949558982.invokeNext();
        }
        return this.org$buni$meldware$mail$store$paged$PagedStore$getBuffer$aop(l, l2, n);
    }

    @Tx(value=TxType.REQUIRED)
    public void delete(Long l) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_delete_N_169551518371285982.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            delete_N169551518371285982 delete_N1695515183712859822 = new delete_N169551518371285982(methodInfo, interceptorArray);
            delete_N1695515183712859822.arg0 = l;
            delete_N1695515183712859822.setTargetObject(this);
            delete_N1695515183712859822.typedTargetObject = this;
            delete_N1695515183712859822.setAdvisor((Advisor)aop$classAdvisor$aop);
            delete_N1695515183712859822.invokeNext();
        } else {
            this.org$buni$meldware$mail$store$paged$PagedStore$delete$aop(l);
        }
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public Long doCreate() throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_doCreate3781003712992460599.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            doCreate_3781003712992460599 doCreate_37810037129924605992 = new doCreate_3781003712992460599(methodInfo, interceptorArray);
            doCreate_37810037129924605992.setTargetObject(this);
            doCreate_37810037129924605992.typedTargetObject = this;
            doCreate_37810037129924605992.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (Long)doCreate_37810037129924605992.invokeNext();
        }
        return this.org$buni$meldware$mail$store$paged$PagedStore$doCreate$aop();
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public InputStream getInputStream(Long l, StoreItemMetaData storeItemMetaData) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getInputStream_N_2488121277901438923.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getInputStream_N2488121277901438923 getInputStream_N24881212779014389232 = new getInputStream_N2488121277901438923(methodInfo, interceptorArray);
            getInputStream_N24881212779014389232.arg0 = l;
            getInputStream_N24881212779014389232.arg1 = storeItemMetaData;
            getInputStream_N24881212779014389232.setTargetObject(this);
            getInputStream_N24881212779014389232.typedTargetObject = this;
            getInputStream_N24881212779014389232.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (InputStream)getInputStream_N24881212779014389232.invokeNext();
        }
        return this.org$buni$meldware$mail$store$paged$PagedStore$getInputStream$aop(l, storeItemMetaData);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public OutputStream getOutputStream(Long l, StoreItemMetaData storeItemMetaData) throws StoreException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getOutputStream_N_3211327161428875046.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getOutputStream_N3211327161428875046 getOutputStream_N32113271614288750462 = new getOutputStream_N3211327161428875046(methodInfo, interceptorArray);
            getOutputStream_N32113271614288750462.arg0 = l;
            getOutputStream_N32113271614288750462.arg1 = storeItemMetaData;
            getOutputStream_N32113271614288750462.setTargetObject(this);
            getOutputStream_N32113271614288750462.typedTargetObject = this;
            getOutputStream_N32113271614288750462.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (OutputStream)getOutputStream_N32113271614288750462.invokeNext();
        }
        return this.org$buni$meldware$mail$store$paged$PagedStore$getOutputStream$aop(l, storeItemMetaData);
    }

    @Override
    @Tx(value=TxType.REQUIRED)
    public String listBlobs() throws HibernateException, NamingException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_listBlobs5933545041233380426.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            listBlobs_5933545041233380426 listBlobs_59335450412333804262 = new listBlobs_5933545041233380426(methodInfo, interceptorArray);
            listBlobs_59335450412333804262.setTargetObject(this);
            listBlobs_59335450412333804262.typedTargetObject = this;
            listBlobs_59335450412333804262.setAdvisor((Advisor)aop$classAdvisor$aop);
            return (String)listBlobs_59335450412333804262.invokeNext();
        }
        return this.org$buni$meldware$mail$store$paged$PagedStore$listBlobs$aop();
    }

    @Tx(value=TxType.REQUIRED)
    public void cleanUp(List list) {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_cleanUp_N_192585779096417288.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            cleanUp_N192585779096417288 cleanUp_N1925857790964172882 = new cleanUp_N192585779096417288(methodInfo, interceptorArray);
            cleanUp_N1925857790964172882.arg0 = list;
            cleanUp_N1925857790964172882.setTargetObject(this);
            cleanUp_N1925857790964172882.typedTargetObject = this;
            cleanUp_N1925857790964172882.setAdvisor((Advisor)aop$classAdvisor$aop);
            cleanUp_N1925857790964172882.invokeNext();
        } else {
            this.org$buni$meldware$mail$store$paged$PagedStore$cleanUp$aop(list);
        }
    }

    public static class read_N150580156191630418
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public long arg1;
        public byte[] arg2;
        public int arg3;
        public int arg4;
        public PagedStore typedTargetObject;

        public read_N150580156191630418(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public read_N150580156191630418(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public read_N150580156191630418(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public read_N150580156191630418() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Integer(this.typedTargetObject.org$buni$meldware$mail$store$paged$PagedStore$read$aop(this.arg0, this.arg1, this.arg2, this.arg3, this.arg4));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
            this.arg1 = (Long)objectArray[1];
            Object object2 = objectArray[2];
            this.arg2 = (byte[])object2;
            this.arg3 = (Integer)objectArray[3];
            this.arg4 = (Integer)objectArray[4];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[5];
            this.arguments[0] = this.arg0;
            new Long(this.arg1);
            this.arguments[2] = this.arg2;
            new Integer(this.arg3);
            new Integer(this.arg4);
            return this.arguments;
        }

        public Invocation copy() {
            read_N150580156191630418 read_N1505801561916304182 = new read_N150580156191630418(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            read_N1505801561916304182.arguments = this.arguments;
            ((InvocationBase)read_N1505801561916304182).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)read_N1505801561916304182).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)read_N1505801561916304182).instanceResolver = ((InvocationBase)this).instanceResolver;
            read_N1505801561916304182.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)read_N1505801561916304182).targetObject = ((InvocationBase)this).targetObject;
            read_N1505801561916304182.arg0 = this.arg0;
            read_N1505801561916304182.arg1 = this.arg1;
            read_N1505801561916304182.arg2 = this.arg2;
            read_N1505801561916304182.arg3 = this.arg3;
            read_N1505801561916304182.arg4 = this.arg4;
            return read_N1505801561916304182;
        }
    }

    public static class getPage_1818472756407716154
    extends MethodInvocation
    implements Untransformable {
        public EntityManager arg0;
        public Long arg1;
        public int arg2;
        public PagedStore typedTargetObject;

        public getPage_1818472756407716154(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getPage_1818472756407716154(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getPage_1818472756407716154(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getPage_1818472756407716154() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$paged$PagedStore$getPage$aop(this.arg0, this.arg1, this.arg2);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (EntityManager)object;
            Object object2 = objectArray[1];
            this.arg1 = (Long)object2;
            this.arg2 = (Integer)objectArray[2];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            new Integer(this.arg2);
            return this.arguments;
        }

        public Invocation copy() {
            getPage_1818472756407716154 getPage_18184727564077161542 = new getPage_1818472756407716154(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getPage_18184727564077161542.arguments = this.arguments;
            ((InvocationBase)getPage_18184727564077161542).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getPage_18184727564077161542).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getPage_18184727564077161542).instanceResolver = ((InvocationBase)this).instanceResolver;
            getPage_18184727564077161542.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getPage_18184727564077161542).targetObject = ((InvocationBase)this).targetObject;
            getPage_18184727564077161542.arg0 = this.arg0;
            getPage_18184727564077161542.arg1 = this.arg1;
            getPage_18184727564077161542.arg2 = this.arg2;
            return getPage_18184727564077161542;
        }
    }

    public static class write_N7611023959546435916
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public long arg1;
        public byte[] arg2;
        public int arg3;
        public int arg4;
        public PagedStore typedTargetObject;

        public write_N7611023959546435916(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public write_N7611023959546435916(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public write_N7611023959546435916(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public write_N7611023959546435916() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return new Integer(this.typedTargetObject.org$buni$meldware$mail$store$paged$PagedStore$write$aop(this.arg0, this.arg1, this.arg2, this.arg3, this.arg4));
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
            this.arg1 = (Long)objectArray[1];
            Object object2 = objectArray[2];
            this.arg2 = (byte[])object2;
            this.arg3 = (Integer)objectArray[3];
            this.arg4 = (Integer)objectArray[4];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[5];
            this.arguments[0] = this.arg0;
            new Long(this.arg1);
            this.arguments[2] = this.arg2;
            new Integer(this.arg3);
            new Integer(this.arg4);
            return this.arguments;
        }

        public Invocation copy() {
            write_N7611023959546435916 write_N76110239595464359162 = new write_N7611023959546435916(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            write_N76110239595464359162.arguments = this.arguments;
            ((InvocationBase)write_N76110239595464359162).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)write_N76110239595464359162).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)write_N76110239595464359162).instanceResolver = ((InvocationBase)this).instanceResolver;
            write_N76110239595464359162.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)write_N76110239595464359162).targetObject = ((InvocationBase)this).targetObject;
            write_N76110239595464359162.arg0 = this.arg0;
            write_N76110239595464359162.arg1 = this.arg1;
            write_N76110239595464359162.arg2 = this.arg2;
            write_N76110239595464359162.arg3 = this.arg3;
            write_N76110239595464359162.arg4 = this.arg4;
            return write_N76110239595464359162;
        }
    }

    public static class getBuffer_N8328802641894955898
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public long arg1;
        public int arg2;
        public PagedStore typedTargetObject;

        public getBuffer_N8328802641894955898(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getBuffer_N8328802641894955898(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getBuffer_N8328802641894955898(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getBuffer_N8328802641894955898() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$paged$PagedStore$getBuffer$aop(this.arg0, this.arg1, this.arg2);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
            this.arg1 = (Long)objectArray[1];
            this.arg2 = (Integer)objectArray[2];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            this.arguments[0] = this.arg0;
            new Long(this.arg1);
            new Integer(this.arg2);
            return this.arguments;
        }

        public Invocation copy() {
            getBuffer_N8328802641894955898 getBuffer_N83288026418949558982 = new getBuffer_N8328802641894955898(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getBuffer_N83288026418949558982.arguments = this.arguments;
            ((InvocationBase)getBuffer_N83288026418949558982).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getBuffer_N83288026418949558982).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getBuffer_N83288026418949558982).instanceResolver = ((InvocationBase)this).instanceResolver;
            getBuffer_N83288026418949558982.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getBuffer_N83288026418949558982).targetObject = ((InvocationBase)this).targetObject;
            getBuffer_N83288026418949558982.arg0 = this.arg0;
            getBuffer_N83288026418949558982.arg1 = this.arg1;
            getBuffer_N83288026418949558982.arg2 = this.arg2;
            return getBuffer_N83288026418949558982;
        }
    }

    public static class delete_N169551518371285982
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public PagedStore typedTargetObject;

        public delete_N169551518371285982(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public delete_N169551518371285982(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public delete_N169551518371285982(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public delete_N169551518371285982() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$buni$meldware$mail$store$paged$PagedStore$delete$aop(this.arg0);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            delete_N169551518371285982 delete_N1695515183712859822 = new delete_N169551518371285982(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            delete_N1695515183712859822.arguments = this.arguments;
            ((InvocationBase)delete_N1695515183712859822).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)delete_N1695515183712859822).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)delete_N1695515183712859822).instanceResolver = ((InvocationBase)this).instanceResolver;
            delete_N1695515183712859822.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)delete_N1695515183712859822).targetObject = ((InvocationBase)this).targetObject;
            delete_N1695515183712859822.arg0 = this.arg0;
            return delete_N1695515183712859822;
        }
    }

    public static class doCreate_3781003712992460599
    extends MethodInvocation
    implements Untransformable {
        public PagedStore typedTargetObject;

        public doCreate_3781003712992460599(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public doCreate_3781003712992460599(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public doCreate_3781003712992460599(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public doCreate_3781003712992460599() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$paged$PagedStore$doCreate$aop();
        }

        public Invocation copy() {
            doCreate_3781003712992460599 doCreate_37810037129924605992 = new doCreate_3781003712992460599(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            doCreate_37810037129924605992.arguments = this.arguments;
            ((InvocationBase)doCreate_37810037129924605992).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)doCreate_37810037129924605992).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)doCreate_37810037129924605992).instanceResolver = ((InvocationBase)this).instanceResolver;
            doCreate_37810037129924605992.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)doCreate_37810037129924605992).targetObject = ((InvocationBase)this).targetObject;
            return doCreate_37810037129924605992;
        }
    }

    public static class getInputStream_N2488121277901438923
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public StoreItemMetaData arg1;
        public PagedStore typedTargetObject;

        public getInputStream_N2488121277901438923(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getInputStream_N2488121277901438923(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getInputStream_N2488121277901438923(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getInputStream_N2488121277901438923() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$paged$PagedStore$getInputStream$aop(this.arg0, this.arg1);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
            Object object2 = objectArray[1];
            this.arg1 = (StoreItemMetaData)object2;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            return this.arguments;
        }

        public Invocation copy() {
            getInputStream_N2488121277901438923 getInputStream_N24881212779014389232 = new getInputStream_N2488121277901438923(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getInputStream_N24881212779014389232.arguments = this.arguments;
            ((InvocationBase)getInputStream_N24881212779014389232).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getInputStream_N24881212779014389232).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getInputStream_N24881212779014389232).instanceResolver = ((InvocationBase)this).instanceResolver;
            getInputStream_N24881212779014389232.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getInputStream_N24881212779014389232).targetObject = ((InvocationBase)this).targetObject;
            getInputStream_N24881212779014389232.arg0 = this.arg0;
            getInputStream_N24881212779014389232.arg1 = this.arg1;
            return getInputStream_N24881212779014389232;
        }
    }

    public static class getOutputStream_N3211327161428875046
    extends MethodInvocation
    implements Untransformable {
        public Long arg0;
        public StoreItemMetaData arg1;
        public PagedStore typedTargetObject;

        public getOutputStream_N3211327161428875046(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getOutputStream_N3211327161428875046(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getOutputStream_N3211327161428875046(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getOutputStream_N3211327161428875046() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$paged$PagedStore$getOutputStream$aop(this.arg0, this.arg1);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (Long)object;
            Object object2 = objectArray[1];
            this.arg1 = (StoreItemMetaData)object2;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[2];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            return this.arguments;
        }

        public Invocation copy() {
            getOutputStream_N3211327161428875046 getOutputStream_N32113271614288750462 = new getOutputStream_N3211327161428875046(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            getOutputStream_N32113271614288750462.arguments = this.arguments;
            ((InvocationBase)getOutputStream_N32113271614288750462).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)getOutputStream_N32113271614288750462).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)getOutputStream_N32113271614288750462).instanceResolver = ((InvocationBase)this).instanceResolver;
            getOutputStream_N32113271614288750462.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)getOutputStream_N32113271614288750462).targetObject = ((InvocationBase)this).targetObject;
            getOutputStream_N32113271614288750462.arg0 = this.arg0;
            getOutputStream_N32113271614288750462.arg1 = this.arg1;
            return getOutputStream_N32113271614288750462;
        }
    }

    public static class listBlobs_5933545041233380426
    extends MethodInvocation
    implements Untransformable {
        public PagedStore typedTargetObject;

        public listBlobs_5933545041233380426(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public listBlobs_5933545041233380426(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public listBlobs_5933545041233380426(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public listBlobs_5933545041233380426() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$buni$meldware$mail$store$paged$PagedStore$listBlobs$aop();
        }

        public Invocation copy() {
            listBlobs_5933545041233380426 listBlobs_59335450412333804262 = new listBlobs_5933545041233380426(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            listBlobs_59335450412333804262.arguments = this.arguments;
            ((InvocationBase)listBlobs_59335450412333804262).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)listBlobs_59335450412333804262).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)listBlobs_59335450412333804262).instanceResolver = ((InvocationBase)this).instanceResolver;
            listBlobs_59335450412333804262.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)listBlobs_59335450412333804262).targetObject = ((InvocationBase)this).targetObject;
            return listBlobs_59335450412333804262;
        }
    }

    public static class cleanUp_N192585779096417288
    extends MethodInvocation
    implements Untransformable {
        public List arg0;
        public PagedStore typedTargetObject;

        public cleanUp_N192585779096417288(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public cleanUp_N192585779096417288(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public cleanUp_N192585779096417288(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public cleanUp_N192585779096417288() {
        }

        public Object invokeNext() throws Throwable {
            if (((InvocationBase)this).currentInterceptor < ((InvocationBase)this).interceptors.length) {
                try {
                    Object object = ((InvocationBase)this).interceptors[((InvocationBase)this).currentInterceptor++].invoke((Invocation)this);
                    Object var3_2 = null;
                    --((InvocationBase)this).currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --((InvocationBase)this).currentInterceptor;
                    throw throwable;
                }
            }
            this.typedTargetObject.org$buni$meldware$mail$store$paged$PagedStore$cleanUp$aop(this.arg0);
            return null;
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (List)object;
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[1];
            this.arguments[0] = this.arg0;
            return this.arguments;
        }

        public Invocation copy() {
            cleanUp_N192585779096417288 cleanUp_N1925857790964172882 = new cleanUp_N192585779096417288(((InvocationBase)this).interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, ((InvocationBase)this).advisor);
            cleanUp_N1925857790964172882.arguments = this.arguments;
            ((InvocationBase)cleanUp_N1925857790964172882).metadata = ((InvocationBase)this).metadata;
            ((InvocationBase)cleanUp_N1925857790964172882).currentInterceptor = ((InvocationBase)this).currentInterceptor;
            ((InvocationBase)cleanUp_N1925857790964172882).instanceResolver = ((InvocationBase)this).instanceResolver;
            cleanUp_N1925857790964172882.typedTargetObject = this.typedTargetObject;
            ((InvocationBase)cleanUp_N1925857790964172882).targetObject = ((InvocationBase)this).targetObject;
            cleanUp_N1925857790964172882.arg0 = this.arg0;
            return cleanUp_N1925857790964172882;
        }
    }
}

