/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.smtp.sender;

import java.util.ArrayList;
import org.buni.meldware.mail.message.MailAddress;
import org.buni.meldware.mail.smtp.sender.SMTPResult;

public class SMTPResultImpl
implements SMTPResult {
    private MailAddress address;
    private int status;

    SMTPResultImpl(MailAddress address, int status) {
        this.address = address;
        this.status = status;
    }

    static ArrayList getResolveDomainErrorForAll(MailAddress[] address) {
        return SMTPResultImpl.getSameResultForAll(address, 2);
    }

    static ArrayList getOkForAll(MailAddress[] address) {
        return SMTPResultImpl.getSameResultForAll(address, 1);
    }

    static ArrayList getErrorForAll(MailAddress[] address) {
        return SMTPResultImpl.getSameResultForAll(address, 3);
    }

    private static ArrayList getSameResultForAll(MailAddress[] address, int status) {
        ArrayList<SMTPResultImpl> results = new ArrayList<SMTPResultImpl>(address.length);
        int i = 0;
        while (i < address.length) {
            results.add(new SMTPResultImpl(address[i], status));
            ++i;
        }
        return results;
    }

    public MailAddress getAddress() {
        return this.address;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isOk() {
        return this.status == 1;
    }

    public boolean redeliver() {
        return this.getStatus() != 1 && this.getStatus() != 4;
    }

    public String getStatusStr() {
        switch (this.getStatus()) {
            case 1: {
                return "OK";
            }
            case 2: {
                return "Domain Not Resolved";
            }
            case 3: {
                return "Error";
            }
            case 4: {
                return "Invalid Address";
            }
        }
        return "Unknown";
    }

    public String toString() {
        return "Status: " + this.getStatusStr() + ", Address: " + this.getAddress().toString();
    }
}

