/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.pop3.handlers;

import java.io.IOException;
import java.io.OutputStream;
import org.buni.meldware.mail.MailException;
import org.buni.meldware.mail.mailbox.MailboxService;
import org.buni.meldware.mail.mailbox.MessageData;
import org.buni.meldware.mail.pop3.POP3ProtocolInstance;
import org.buni.meldware.mail.pop3.POP3Request;
import org.buni.meldware.mail.pop3.POP3Response;
import org.buni.meldware.mail.pop3.handlers.AbstractCommand;
import org.buni.meldware.mail.pop3.handlers.POP3Handler;
import org.buni.meldware.mail.pop3.handlers.POP3UserMessages;
import org.buni.meldware.mail.util.io.Copier;
import org.buni.meldware.mail.util.io.DotStuffingLineLimitedCopier;
import org.jboss.logging.Logger;

public class CmdTOP
extends AbstractCommand
implements POP3Handler,
POP3UserMessages {
    public static final String COMMAND = "TOP";
    private static final Logger log = Logger.getLogger(CmdTOP.class);

    public POP3Response handleRequest(OutputStream out, POP3Request request, POP3ProtocolInstance protocol) throws IOException, MailException {
        log.debug((Object)"TOP command handler called");
        POP3Response response = new POP3Response(request, out, protocol);
        String[] arguments = request.getArguments();
        MailboxService mbs = protocol.getMailboxService();
        if (this.verifyState(protocol, out, 1) && this.verifyArgumentCount(arguments, out, 2)) {
            try {
                int id;
                int numLines = Integer.parseInt(arguments[1]);
                MessageData message = null;
                try {
                    id = Integer.parseInt(arguments[0]);
                }
                catch (Exception exception) {
                    id = -1;
                }
                if (id > 0) {
                    message = protocol.getMessageAt(new Integer(arguments[0]));
                }
                if (message == null || message.isDeleted()) {
                    out.write(MESSAGE_INVALID_MESSAGE_ID_BYTES);
                    out.write(ENDL);
                } else {
                    out.write(MESSAGE_OK_BYTES);
                    out.write(ENDL);
                    this.writeMessage(out, message, numLines, mbs);
                }
            }
            catch (NumberFormatException numberFormatException) {
                out.write(MESSAGE_ARGUMENT_INVALID_BYTES);
            }
        }
        out.flush();
        return response;
    }

    private void writeMessage(OutputStream out, MessageData message, int numLines, MailboxService mbs) throws IOException, MailException {
        mbs.mimePrintMessage(message.getId(), true, out, (Copier)new DotStuffingLineLimitedCopier(numLines));
        out.write(TERM);
    }
}

