/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.pop3.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.log4j.Logger;
import org.buni.meldware.mail.MailException;
import org.buni.meldware.mail.pop3.POP3ProtocolInstance;
import org.buni.meldware.mail.pop3.POP3Request;
import org.buni.meldware.mail.pop3.POP3Response;
import org.buni.meldware.mail.pop3.handlers.POP3Handler;
import org.buni.meldware.mail.pop3.handlers.POP3UserMessages;

public class CmdQUIT
implements POP3Handler,
POP3UserMessages {
    public static final String COMMAND = "QUIT";
    private static final Logger log = Logger.getLogger(CmdQUIT.class);

    public POP3Response handleRequest(OutputStream out, POP3Request request, POP3ProtocolInstance protocol) throws IOException {
        log.debug((Object)"QUIT command handler called");
        POP3Response response = new POP3Response(request, out, protocol, true);
        PrintWriter writer = response.getWriter();
        if (protocol.getState() == 1) {
            protocol.setState(2);
            try {
                protocol.deleteMarked();
                if (!protocol.commit()) {
                    writer.println("-ERR Mailbox update failed.");
                    writer.flush();
                    return response;
                }
            }
            catch (MailException me) {
                log.error((Object)"Failed commit messages", (Throwable)me);
                writer.println("-ERR Mailbox update failed.");
                writer.flush();
                return response;
            }
        }
        writer.println("+OK " + protocol.getProperty("Servername") + " Service closing transmission channel");
        writer.flush();
        return response;
    }
}

