/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.pop3.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.log4j.Logger;
import org.buni.meldware.mail.pop3.POP3Constants;
import org.buni.meldware.mail.pop3.POP3ProtocolInstance;
import org.buni.meldware.mail.pop3.POP3Request;
import org.buni.meldware.mail.pop3.POP3Response;
import org.buni.meldware.mail.pop3.handlers.AbstractCommand;
import org.buni.meldware.mail.pop3.handlers.POP3Handler;

public class CmdCAPA
extends AbstractCommand
implements POP3Handler,
POP3Constants {
    public static final String COMMAND = "CAPA";
    private static final Logger log = Logger.getLogger(CmdCAPA.class);

    public POP3Response handleRequest(OutputStream out, POP3Request request, POP3ProtocolInstance protocol) throws IOException {
        log.debug((Object)"CAPA command handler called");
        POP3ProtocolInstance popProtocol = protocol;
        POP3Response response = new POP3Response(request, out, protocol);
        PrintWriter writer = response.getWriter();
        int state = popProtocol.getState();
        if (state != 0 && state != 1) {
            writer.println("-ERR Command not allowed at this time");
        } else if (this.verifyArgumentCount(request.getArguments(), writer, 0)) {
            writer.println("+OK");
            if (state == 0) {
                log.debug((Object)"auth state");
                writer.println("USER");
                if (protocol.getPropertyBool("TlsEnabled")) {
                    writer.println("STLS");
                }
            } else if (state == 1) {
                log.debug((Object)"tx state");
                writer.println("TOP");
                writer.println("UIDL");
            }
            writer.println(".");
        }
        writer.flush();
        return response;
    }
}

