/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.pop3.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.log4j.Logger;
import org.buni.meldware.mail.mailbox.Folder;
import org.buni.meldware.mail.mailbox.Mailbox;
import org.buni.meldware.mail.pop3.POP3ProtocolInstance;
import org.buni.meldware.mail.pop3.POP3Request;
import org.buni.meldware.mail.pop3.POP3Response;
import org.buni.meldware.mail.pop3.handlers.AbstractCommand;
import org.buni.meldware.mail.pop3.handlers.POP3Handler;
import org.buni.meldware.mail.userrepository.UserRepository;

public class CmdAPOP
extends AbstractCommand
implements POP3Handler {
    public static final String COMMAND = "APOP";
    private static final Logger log = Logger.getLogger(CmdAPOP.class);

    public POP3Response handleRequest(OutputStream out, POP3Request request, POP3ProtocolInstance protocol) throws IOException {
        log.debug((Object)"APOP command handler called");
        POP3Response response = new POP3Response(request, out, protocol);
        PrintWriter writer = response.getWriter();
        String[] arguments = request.getArguments();
        String username = arguments[0];
        String password = arguments[1];
        if (this.verifyState(protocol, writer, 0)) {
            if (!((UserRepository)protocol.getProperty("APOPUserRepository")).test(username, password, protocol.getApopId())) {
                writer.println("-ERR Authentication failed");
                protocol.setState("USER", null);
            } else {
                try {
                    protocol.getMailboxService();
                    Mailbox mailbox = protocol.getMailboxForUser(username);
                    protocol.setState("USER", username);
                    if (mailbox == null) {
                        writer.println("-ERR Service Unavailable");
                    } else if (protocol.lock((Folder)mailbox)) {
                        protocol.setMailbox(mailbox);
                        protocol.setState(1);
                        writer.println("+OK");
                    } else {
                        writer.println("-ERR Mailbox locked.");
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error getting MailboxMBean: " + e), (Throwable)e);
                    writer.println("-ERR Service Unavailable");
                }
            }
        }
        writer.flush();
        return response;
    }
}

