/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4.commands.fetch;

import java.util.ArrayList;
import java.util.List;
import org.buni.meldware.mail.api.FolderMessage;
import org.buni.meldware.mail.imap4.commands.fetch.MsgFilter;
import org.buni.meldware.mail.imap4.commands.fetch.MsgRangeFilter;
import org.buni.meldware.mail.mailbox.MessageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsgSetFilter
extends MsgFilter {
    MsgRangeFilter[] filters;

    public MsgSetFilter(MsgRangeFilter filter, MsgRangeFilter[] extras) {
        if (extras == null) {
            this.filters = new MsgRangeFilter[1];
        } else {
            this.filters = new MsgRangeFilter[extras.length + 1];
            System.arraycopy(extras, 0, this.filters, 1, extras.length);
        }
        this.filters[0] = filter;
    }

    public MsgSetFilter(MsgRangeFilter[] filters) {
        this.filters = filters;
    }

    public MsgSetFilter(String set, boolean uid) {
        String[] ranges = set.split(",");
        this.filters = new MsgRangeFilter[ranges.length];
        int i = 0;
        while (i < ranges.length) {
            String range = ranges[i];
            this.filters[i] = new MsgRangeFilter(range, uid);
            ++i;
        }
    }

    @Override
    public boolean includes(FolderMessage msg) {
        int i = 0;
        while (i < this.filters.length) {
            MsgRangeFilter filter = this.filters[i];
            if (filter.includes(msg)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean includes(FolderMessage msg, int seqNum) {
        int i = 0;
        while (i < this.filters.length) {
            MsgRangeFilter filter = this.filters[i];
            if (filter.includes(msg, seqNum)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public List<MessageData> getMessagesFromList(List<MessageData> messageList) {
        ArrayList<MessageData> returnList = new ArrayList<MessageData>();
        MsgRangeFilter[] msgRangeFilterArray = this.filters;
        int n = 0;
        int n2 = msgRangeFilterArray.length;
        while (n < n2) {
            MsgRangeFilter filter = msgRangeFilterArray[n];
            List<MessageData> newList = filter.getMessagesFromList(messageList);
            for (MessageData msg : newList) {
                if (returnList.contains(msg)) continue;
                returnList.add(msg);
            }
            ++n;
        }
        return returnList;
    }

    public MsgRangeFilter[] getMessageRangeFilters() {
        return this.filters;
    }
}

