/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4.commands.fetch;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.buni.meldware.common.logging.Log;
import org.buni.meldware.common.util.ArrayUtil;
import org.buni.meldware.mail.MailException;
import org.buni.meldware.mail.StreamWriteException;
import org.buni.meldware.mail.api.FolderBody;
import org.buni.meldware.mail.api.FolderEntity;
import org.buni.meldware.mail.api.FolderMessage;
import org.buni.meldware.mail.imap4.IMAP4OutputStream;
import org.buni.meldware.mail.imap4.commands.fetch.BodyPartRequest;
import org.buni.meldware.mail.imap4.commands.fetch.RFC822PartRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BodyPart {
    public static final String ENDL = "\r\n";
    private static final Log log = Log.getLog(BodyPart.class);
    private static final String SIZE = "SIZE";
    private static final String HEADER = "HEADER";
    private static final String TEXT = "TEXT";
    private static final List<String> EMPTY = new ArrayList<String>(0);

    public boolean canHandle(Object req) {
        return req instanceof BodyPartRequest || req instanceof RFC822PartRequest;
    }

    public void fetch(FolderMessage msg, BodyPartRequest breq, IMAP4OutputStream out) {
        try {
            FolderMessage entity;
            out.write(breq.toString());
            out.write(" ");
            List<Integer> address = breq.getAddress();
            if (address.size() == 0) {
                entity = msg;
            } else {
                int[] addr = new int[address.size()];
                int i = 0;
                while (i < addr.length) {
                    addr[i] = address.get(i) - 1;
                    ++i;
                }
                entity = msg.getBodyPart(addr);
            }
            Partial p = null;
            if (breq.hasRange()) {
                p = new Partial(breq.getRangeStart(), breq.getRangeLength());
            }
            if (entity != null) {
                Type type = breq.getType();
                log.debug("Fetch type: %s, address: %s, partial: %s", new Object[]{type, ArrayUtil.join(address, (String)"[", (String)".", (String)"]"), p});
                switch (type) {
                    case HEADER: {
                        this.fetchHeader(entity.getHeaders(), out, EMPTY, false, p);
                        break;
                    }
                    case HEADER_FIELDS: {
                        this.fetchHeader(entity.getHeaders(), out, breq.getParts(), true, p);
                        break;
                    }
                    case HEADER_FIELDS_NOT: {
                        this.fetchHeader(entity.getHeaders(), out, breq.getParts(), false, p);
                        break;
                    }
                    case TEXT: {
                        if (entity.isMessage()) {
                            this.fetchText((FolderEntity)entity, out, p);
                            break;
                        }
                        log.warn((Object)"BODY type TEXT is only supported for messages");
                        this.writeNil(out);
                        break;
                    }
                    case ALL: {
                        this.fetchAll((FolderEntity)entity, out, p);
                        break;
                    }
                    case MIME: {
                        if (entity instanceof FolderBody) {
                            this.fetchMime((FolderBody)entity, out, p);
                            break;
                        }
                        log.warn((Object)"BODY type MIME is not supported for messages");
                        this.writeNil(out);
                        break;
                    }
                    default: {
                        log.warn("BODY type %s is not supported", new Object[]{type});
                        this.writeEmpty(out);
                        break;
                    }
                }
            } else {
                this.writeNil(out);
            }
        }
        catch (IOException e) {
            throw new StreamWriteException((Throwable)e);
        }
    }

    public void fetch(FolderMessage msg, RFC822PartRequest part, IMAP4OutputStream out) {
        block7: {
            try {
                out.write(part.toString());
                out.write(" ");
                if (SIZE.equals(part.getType())) {
                    out.write(this.fetchSize((FolderEntity)msg));
                    break block7;
                }
                if (HEADER.equals(part.getType())) {
                    throw new MailException("Implement RFC822.HEADER");
                }
                if (TEXT.equals(part.getType())) {
                    throw new MailException("Implement RFC822.TEXT");
                }
                log.warn("RFC822.%d is not supported", new Object[]{part.getType()});
                try {
                    out.write("\"\"");
                }
                catch (IOException e) {
                    throw new StreamWriteException((Throwable)e);
                }
            }
            catch (IOException e) {
                throw new StreamWriteException((Throwable)e);
            }
        }
    }

    protected String fetchSize(FolderEntity message) {
        return String.valueOf(message.getSize());
    }

    private final void writeNil(IMAP4OutputStream out) {
        try {
            out.write("NIL");
        }
        catch (IOException e) {
            throw new StreamWriteException((Throwable)e);
        }
    }

    private final void writeEmpty(IMAP4OutputStream out) {
        try {
            out.write("\"\"");
        }
        catch (IOException e) {
            throw new StreamWriteException((Throwable)e);
        }
    }

    protected void fetchText(FolderEntity part, IMAP4OutputStream out, Partial partial) {
        try {
            if (partial == null) {
                int off = partial.getOff();
                int len = partial.getLen();
                if ((long)off < part.getBodySize()) {
                    long partSize = Math.min((long)len, Math.max(0L, part.getBodySize() - (long)off));
                    out.write("{");
                    out.write(String.valueOf(partSize));
                    out.write("}");
                    out.write(ENDL);
                    try {
                        SizeLimitedOutputStream outNew = new SizeLimitedOutputStream((OutputStream)((Object)out), off, len);
                        part.printText((OutputStream)outNew);
                    }
                    catch (LimitReachedException limitReachedException) {}
                } else {
                    out.write("\"\"");
                }
            } else {
                out.write("{");
                out.write(String.valueOf(part.getBodySize()));
                out.write("}");
                out.write(ENDL);
                part.printText((OutputStream)((Object)out));
            }
        }
        catch (IOException e) {
            throw new StreamWriteException((Throwable)e);
        }
    }

    protected void fetchMime(FolderBody body, IMAP4OutputStream out, Partial partial) {
        String mime = body.getMimeheader();
        if (mime != null) {
            mime = mime.replaceAll("[\\u0080-\\uffff]", "?");
            if (partial != null) {
                mime = partial.subString(mime).toString();
            }
        }
        String result = this.format(mime);
        try {
            out.write(result);
        }
        catch (IOException e) {
            throw new StreamWriteException((Throwable)e);
        }
    }

    private boolean match(List<String> parts, String test) {
        for (String part : parts) {
            if (!test.startsWith(part.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    protected void fetchHeader(String[] headers, IMAP4OutputStream out, List<String> parts, boolean include, Partial partial) {
        String result;
        if (headers == null) {
            result = "NIL";
        } else if (headers.length == 0) {
            result = "\"\"";
        } else {
            StringBuilder resultB = new StringBuilder();
            String[] stringArray = headers;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String header = stringArray[n];
                if (include && this.match(parts, header.toUpperCase()) || !include && !this.match(parts, header.toUpperCase())) {
                    resultB.append(header);
                    resultB.append(ENDL);
                }
                ++n;
            }
            result = partial != null ? partial.subString(resultB).toString() : resultB.toString();
            result = this.format(result.replaceAll("[\\u0080-\\uffff]", "?"));
        }
        try {
            out.write(result);
        }
        catch (IOException e) {
            throw new StreamWriteException((Throwable)e);
        }
    }

    public void fetchAll(FolderEntity message, IMAP4OutputStream out, Partial partial) {
        try {
            if (partial != null) {
                int off = partial.getOff();
                int len = partial.getLen();
                if ((long)off < message.getBodySize()) {
                    long partSize = Math.min((long)len, Math.max(0L, message.getBodySize() - (long)off));
                    out.write("{");
                    out.write(String.valueOf(partSize));
                    out.write("}");
                    out.write(ENDL);
                    try {
                        SizeLimitedOutputStream outNew = new SizeLimitedOutputStream((OutputStream)((Object)out), off, len);
                        message.print((OutputStream)outNew);
                    }
                    catch (LimitReachedException limitReachedException) {}
                } else {
                    out.write("\"\"");
                }
            } else {
                out.write("{");
                out.write(String.valueOf(message.getSize()));
                out.write("}\r\n");
                message.print((OutputStream)((Object)out));
            }
        }
        catch (IOException e) {
            throw new StreamWriteException(e.getMessage(), (Throwable)e);
        }
    }

    private String format(String content) {
        if (content == null) {
            return "NIL";
        }
        if (content.equals("")) {
            return "\"\"";
        }
        return "{" + content.length() + "}\r\n" + content;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ALL,
        SIZE,
        HEADER,
        HEADER_FIELDS,
        HEADER_FIELDS_NOT,
        TEXT,
        MIME;

    }

    private static class Partial {
        private final int off;
        private final int len;

        public Partial(int off, int len) {
            this.off = off;
            this.len = len;
        }

        public int getOff() {
            return this.off;
        }

        public int getLen() {
            return this.len;
        }

        public CharSequence subString(CharSequence s) {
            if (s.length() < this.off) {
                return "";
            }
            if (this.off + this.len > s.length()) {
                return s.subSequence(this.off, s.length());
            }
            return s.subSequence(this.off, this.off + this.len);
        }

        public String toString() {
            return "<" + this.off + "." + this.len + ">";
        }
    }

    private static class SizeLimitedOutputStream
    extends OutputStream {
        private final int start;
        private final int end;
        private int pos = 0;
        private final OutputStream out;

        public SizeLimitedOutputStream(OutputStream out, int start, int size) {
            this.out = out;
            this.start = start;
            this.end = start + size;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.pos >= this.end) {
                this.out.flush();
                throw LimitReachedException.instance();
            }
            if (this.pos + len >= this.start) {
                int toSkip = Math.max(0, this.start - this.pos);
                int toTrunc = Math.max(0, this.pos + len - this.end);
                len -= toSkip + toTrunc;
                if ((off += toSkip) < b.length) {
                    this.out.write(b, off, len);
                }
                this.pos += len + toSkip;
            } else {
                this.pos += len;
            }
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(int b) throws IOException {
            if (this.pos >= this.end) {
                this.out.flush();
                throw LimitReachedException.instance();
            }
            if (this.pos >= this.start && this.pos < this.end) {
                this.out.write(b);
            }
            ++this.pos;
        }
    }

    private static class LimitReachedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private static final LimitReachedException e = new LimitReachedException();

        private LimitReachedException() {
        }

        public Throwable fillInStackTrace() {
            return null;
        }

        public static LimitReachedException instance() {
            return e;
        }
    }
}

