/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4.commands;

import java.util.ArrayList;
import java.util.List;
import org.buni.meldware.common.util.ArrayUtil;
import org.buni.meldware.mail.api.Folder;
import org.buni.meldware.mail.api.FolderMessage;
import org.buni.meldware.mail.imap4.IMAP4ProtocolInstance;
import org.buni.meldware.mail.imap4.IMAP4Response;
import org.buni.meldware.mail.imap4.commands.AbstractImapCommand;
import org.buni.meldware.mail.imap4.commands.fetch.AndSearchPart;
import org.buni.meldware.mail.imap4.commands.fetch.SearchPart;
import org.buni.meldware.mail.imap4.commands.fetch.StringArgSearchPart;

public class SearchCommand
extends AbstractImapCommand {
    SearchPart part;
    boolean isUID;

    public SearchCommand(boolean isUID) {
        super(isUID ? "UID SEARCH" : "SEARCH");
        this.isUID = isUID;
    }

    public boolean isValidForState() {
        return this.getProtocolInstance().getState() == 2;
    }

    public IMAP4Response execute() {
        IMAP4Response response = this.constructResponse();
        IMAP4ProtocolInstance pi = this.getProtocolInstance();
        Folder f = pi.getFolderProxy();
        List messages = f.getMessages();
        ArrayList<Integer> returnList = new ArrayList<Integer>();
        int i = 0;
        while (i < messages.size()) {
            if (this.includes((FolderMessage)messages.get(i))) {
                if (this.isUID) {
                    returnList.add(((FolderMessage)messages.get(i)).getUid());
                } else {
                    returnList.add(i + 1);
                }
            }
            ++i;
        }
        this.untaggedResponse("SEARCH " + ArrayUtil.join(returnList, (String)" "));
        System.err.println("TODO implement SEARCH");
        this.taggedSimpleSuccess();
        return response;
    }

    public void setPart(SearchPart part) {
        this.part = part;
    }

    public boolean includes(FolderMessage msg) {
        if (this.part instanceof StringArgSearchPart) {
            ((StringArgSearchPart)this.part).setProtocolInstance(this.getProtocolInstance());
        }
        if (this.part instanceof AndSearchPart) {
            ((AndSearchPart)this.part).setProtocolInstance(this.getProtocolInstance());
        }
        return this.part.includes(msg);
    }

    public boolean isUid() {
        return this.isUID;
    }
}

