/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4.commands;

import org.buni.meldware.mail.api.Folder;
import org.buni.meldware.mail.imap4.IMAP4ProtocolInstance;
import org.buni.meldware.mail.imap4.IMAP4Response;
import org.buni.meldware.mail.imap4.commands.AbstractImapCommand;

public class ExamineCommand
extends AbstractImapCommand {
    String _folder;

    public ExamineCommand() {
        super("EXAMINE");
    }

    public boolean isValidForState() {
        return this.getProtocolInstance().getState() == 1;
    }

    public ExamineCommand(String name) {
        super(name);
    }

    public IMAP4Response execute() {
        IMAP4Response response = this.constructResponse();
        IMAP4ProtocolInstance protocol = this.getProtocolInstance();
        protocol.clearFolder();
        protocol.setState(1);
        String[] path = this.getPath(this.getFolder());
        Folder f = protocol.selectFolder(path);
        if (f == null) {
            this.taggedResponse("NO " + this.getCmdName() + " failure, no such mailbox");
        } else {
            if (this.getClass() == ExamineCommand.class) {
                protocol.setFolderReadOnly(true);
            } else {
                protocol.setFolderReadOnly(false);
            }
            int messages = f.getMessageCount();
            int recent = f.getRecentCount();
            long uid = f.getLikelyUID();
            int unseen = f.getUnseenCount();
            protocol.setState(2);
            this.untaggedResponse(String.valueOf(messages) + " EXISTS");
            this.untaggedResponse(String.valueOf(recent) + " RECENT");
            if (unseen > 0) {
                this.untaggedSuccess("[UNSEEN %d]", f.getFirstUnseen());
            }
            this.untaggedSuccess("[UIDVALIDITY " + f.getId() + "] UIDs valid ");
            this.untaggedSuccess("[UIDNEXT " + uid + "] Predicted next UID ");
            this.untaggedResponse("FLAGS (\\Answered \\Flagged \\Deleted \\Seen \\Draft)");
            if (this.getClass() == ExamineCommand.class) {
                this.untaggedSuccess("[PERMANENTFLAGS ()] No permanent flags permitted");
                this.taggedSuccess("[READ-ONLY] " + this.getCmdName() + " completed");
            } else {
                this.untaggedSuccess("[PERMANENTFLAGS (\\* \\Answered \\Flagged \\Deleted \\Seen \\Draft)] Permanent flags");
                this.taggedSuccess("[READ-WRITE] " + this.getCmdName() + " completed");
            }
        }
        this.flush();
        return response;
    }

    protected boolean isWritable() {
        return false;
    }

    public String getFolder() {
        return this._folder;
    }

    public void setFolder(String mailbox) {
        this._folder = mailbox;
    }
}

