/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.imap4.commands;

import org.buni.meldware.mail.api.Folder;
import org.buni.meldware.mail.api.Range;
import org.buni.meldware.mail.imap4.IMAP4ProtocolInstance;
import org.buni.meldware.mail.imap4.IMAP4Response;
import org.buni.meldware.mail.imap4.commands.AbstractImapCommand;
import org.buni.meldware.mail.imap4.commands.fetch.MsgFilter;
import org.buni.meldware.mail.imap4.commands.fetch.MsgSetFilter;

public class CopyCommand
extends AbstractImapCommand {
    boolean isUID;
    MsgFilter range;
    String folder;

    public CopyCommand(boolean isUID) {
        super(isUID ? "UID COPY" : "COPY");
        this.isUID = isUID;
    }

    public boolean isValidForState() {
        return this.getProtocolInstance().getState() == 2;
    }

    public IMAP4Response execute() {
        IMAP4Response response = this.constructResponse();
        IMAP4ProtocolInstance pi = this.getProtocolInstance();
        MsgSetFilter filter = (MsgSetFilter)this.getRange();
        Folder f = pi.getFolderProxy();
        int maxValue = this.isUID ? f.getMaxUid() : f.getMessageCount();
        Range[] ranges = this.createRanges(filter, maxValue);
        String[] path = this.getFolder().split("/");
        Folder target = pi.getMailboxProxy().getFolder(path);
        if (target != null) {
            f.copy(target, this.isUID, ranges);
        } else {
            this.taggedFailure("Folder %s does not exist", this.getFolder());
        }
        this.taggedSimpleSuccess();
        return response;
    }

    public String getFolder() {
        return this.folder;
    }

    public MsgFilter getRange() {
        return this.range;
    }

    public void setFolder(String mailbox) {
        this.folder = mailbox;
    }

    public void setRange(MsgFilter range) {
        this.range = range;
    }

    public boolean isUid() {
        return this.isUID;
    }
}

