/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.buni.meldware.mail.Closable;
import org.buni.meldware.mail.TimeAndLife;

public class Reaper
implements Runnable {
    long pulse;
    private Map reapables;
    private boolean stop = false;
    private static final Logger logger = Logger.getLogger(Reaper.class);

    public Reaper(long pulse) {
        logger.debug((Object)("Pulse value is " + pulse));
        this.pulse = pulse;
        this.reapables = new ConcurrentHashMap(50);
    }

    public void stop() {
        this.stop = true;
        this.run();
    }

    public void start() {
        this.stop = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block11: {
            try {
                while (!this.stop) {
                    Thread.sleep(this.pulse);
                    long thetime = System.currentTimeMillis();
                    Map map = this.reapables;
                    synchronized (map) {
                        Iterator reapme = this.reapables.entrySet().iterator();
                        while (reapme.hasNext()) {
                            TimeAndLife tal = (TimeAndLife)reapme.next().getValue();
                            if (!tal.check(thetime)) continue;
                            reapme.remove();
                        }
                    }
                }
                if (!this.stop) break block11;
                Map thetime = this.reapables;
                synchronized (thetime) {
                    Iterator reapme = this.reapables.entrySet().iterator();
                    while (reapme.hasNext()) {
                        TimeAndLife tal = (TimeAndLife)reapme.next().getValue();
                        tal.kill();
                        reapme.remove();
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void register(Closable closable, Thread thread, long timeout, long life) {
        TimeAndLife tal = new TimeAndLife(closable, thread, timeout, life, this.reapables);
        tal.update(System.currentTimeMillis());
        this.reapables.put(thread, tal);
    }

    public void remove(Thread thread) {
        this.reapables.remove(thread);
    }

    public int getReapableSize() {
        return this.reapables.size();
    }

    public void lock(Thread thread) {
        TimeAndLife tal = (TimeAndLife)this.reapables.get(thread);
        tal.lock();
    }

    public void unlock(Thread thread) {
        try {
            TimeAndLife tal = (TimeAndLife)this.reapables.get(thread);
            tal.unlock();
        }
        catch (Exception exception) {}
    }

    public void update(Thread thread) {
        TimeAndLife tal = (TimeAndLife)this.reapables.get(thread);
        tal.update(System.currentTimeMillis());
    }
}

