/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail;

import java.util.ArrayList;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.buni.meldware.mail.MailException;
import org.buni.meldware.mail.MailListener;
import org.buni.meldware.mail.MailListenerChainServiceMBean;
import org.buni.meldware.mail.PositionedListener;
import org.buni.meldware.mail.message.Message;
import org.buni.meldware.mail.util.MMJMXUtil;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MailListenerChainService
extends ServiceMBeanSupport
implements MailListenerChainServiceMBean {
    private static final Logger log = Logger.getLogger(MailListenerChainService.class);
    private List listeners = new ArrayList();

    public void addListener(ObjectName listenerName) {
        this.addListener(listenerName, this.listeners.size());
    }

    public void addListener(ObjectName listenerName, int position) {
        MailListener listener = this.findListener(listenerName);
        PositionedListener plistener = new PositionedListener(listener, listenerName.toString());
        this.listeners.add(position, plistener);
    }

    private MailListener findListener(ObjectName listenerName) {
        MailListener listener;
        try {
            listener = MMJMXUtil.getMBean(listenerName, MailListener.class);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
        return listener;
    }

    public void removeListener(ObjectName listener) {
        int k = 0;
        while (k < this.listeners.size()) {
            PositionedListener pl = (PositionedListener)this.listeners.get(k);
            if (pl.name.equals(listener.toString())) {
                this.listeners.remove(k);
                break;
            }
            ++k;
        }
    }

    public void removeListener(int position) {
        this.listeners.remove(position);
    }

    public int getNumberListeners() {
        return this.listeners.size();
    }

    public String[] listListeners() {
        String[] retval = new String[this.listeners.size()];
        int k = 0;
        while (k < retval.length) {
            retval[k] = ((PositionedListener)this.listeners.get((int)k)).name;
            ++k;
        }
        return retval;
    }

    public Element getListeners() {
        String[] listenersList = this.listListeners();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        DOMImplementation impl = builder.getDOMImplementation();
        DocumentType DOCTYPE = impl.createDocumentType("non", "non", "non");
        Document doc = impl.createDocument("non", "non", DOCTYPE);
        Element listeners = doc.createElement("listeners");
        int k = 0;
        while (k < listenersList.length) {
            Element listener = doc.createElement("listener");
            listener.appendChild(doc.createTextNode(listenersList[k]));
            listeners.appendChild(listener);
            ++k;
        }
        return listeners;
    }

    public void setListeners(Element listeners) {
        this.listeners = new ArrayList();
        NodeList list = listeners.getElementsByTagName("listener");
        int num = list.getLength();
        int k = 0;
        while (k < num) {
            String listener = list.item(k).getFirstChild().getNodeValue();
            try {
                this.addListener(new ObjectName(listener));
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException(e);
            }
            ++k;
        }
    }

    public Message processMail(Message mail) throws MailException {
        Message msg = mail;
        int i = 0;
        while (i < this.listeners.size()) {
            if (msg == null) break;
            MailListener listener = ((PositionedListener)this.listeners.get((int)i)).listener;
            msg = listener.send(msg);
            ++i;
        }
        return msg;
    }

    public void start() {
    }

    public void stop() {
    }
}

