/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.tls.CertificateStatusRequest;
import org.bouncycastle.tls.CertificateStatusRequestItemV2;
import org.bouncycastle.tls.HeartbeatExtension;
import org.bouncycastle.tls.KeyShareEntry;
import org.bouncycastle.tls.OfferedPsks;
import org.bouncycastle.tls.ProtocolName;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.ServerNameList;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.TrustedAuthority;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TlsExtensionsUtils {
    public static final Integer EXT_application_layer_protocol_negotiation = Integers.valueOf((int)16);
    public static final Integer EXT_certificate_authorities = Integers.valueOf((int)47);
    public static final Integer EXT_client_certificate_type = Integers.valueOf((int)19);
    public static final Integer EXT_client_certificate_url = Integers.valueOf((int)2);
    public static final Integer EXT_cookie = Integers.valueOf((int)44);
    public static final Integer EXT_early_data = Integers.valueOf((int)42);
    public static final Integer EXT_ec_point_formats = Integers.valueOf((int)11);
    public static final Integer EXT_encrypt_then_mac = Integers.valueOf((int)22);
    public static final Integer EXT_extended_master_secret = Integers.valueOf((int)23);
    public static final Integer EXT_heartbeat = Integers.valueOf((int)15);
    public static final Integer EXT_key_share = Integers.valueOf((int)51);
    public static final Integer EXT_max_fragment_length = Integers.valueOf((int)1);
    public static final Integer EXT_oid_filters = Integers.valueOf((int)48);
    public static final Integer EXT_padding = Integers.valueOf((int)21);
    public static final Integer EXT_post_handshake_auth = Integers.valueOf((int)49);
    public static final Integer EXT_pre_shared_key = Integers.valueOf((int)41);
    public static final Integer EXT_psk_key_exchange_modes = Integers.valueOf((int)45);
    public static final Integer EXT_record_size_limit = Integers.valueOf((int)28);
    public static final Integer EXT_server_certificate_type = Integers.valueOf((int)20);
    public static final Integer EXT_server_name = Integers.valueOf((int)0);
    public static final Integer EXT_signature_algorithms = Integers.valueOf((int)13);
    public static final Integer EXT_signature_algorithms_cert = Integers.valueOf((int)50);
    public static final Integer EXT_status_request = Integers.valueOf((int)5);
    public static final Integer EXT_status_request_v2 = Integers.valueOf((int)17);
    public static final Integer EXT_supported_groups = Integers.valueOf((int)10);
    public static final Integer EXT_supported_versions = Integers.valueOf((int)43);
    public static final Integer EXT_truncated_hmac = Integers.valueOf((int)4);
    public static final Integer EXT_trusted_ca_keys = Integers.valueOf((int)3);

    public static Hashtable ensureExtensionsInitialised(Hashtable hashtable) {
        return hashtable == null ? new Hashtable() : hashtable;
    }

    public static void addALPNExtensionClient(Hashtable hashtable, Vector vector) throws IOException {
        hashtable.put(EXT_application_layer_protocol_negotiation, TlsExtensionsUtils.createALPNExtensionClient(vector));
    }

    public static void addALPNExtensionServer(Hashtable hashtable, ProtocolName protocolName) throws IOException {
        hashtable.put(EXT_application_layer_protocol_negotiation, TlsExtensionsUtils.createALPNExtensionServer(protocolName));
    }

    public static void addCertificateAuthoritiesExtension(Hashtable hashtable, Vector vector) throws IOException {
        hashtable.put(EXT_certificate_authorities, TlsExtensionsUtils.createCertificateAuthoritiesExtension(vector));
    }

    public static void addClientCertificateTypeExtensionClient(Hashtable hashtable, short[] sArray) throws IOException {
        hashtable.put(EXT_client_certificate_type, TlsExtensionsUtils.createCertificateTypeExtensionClient(sArray));
    }

    public static void addClientCertificateTypeExtensionServer(Hashtable hashtable, short s) throws IOException {
        hashtable.put(EXT_client_certificate_type, TlsExtensionsUtils.createCertificateTypeExtensionServer(s));
    }

    public static void addClientCertificateURLExtension(Hashtable hashtable) {
        hashtable.put(EXT_client_certificate_url, TlsExtensionsUtils.createClientCertificateURLExtension());
    }

    public static void addCookieExtension(Hashtable hashtable, byte[] byArray) throws IOException {
        hashtable.put(EXT_cookie, TlsExtensionsUtils.createCookieExtension(byArray));
    }

    public static void addEarlyDataIndication(Hashtable hashtable) {
        hashtable.put(EXT_early_data, TlsExtensionsUtils.createEarlyDataIndication());
    }

    public static void addEarlyDataMaxSize(Hashtable hashtable, long l) throws IOException {
        hashtable.put(EXT_early_data, TlsExtensionsUtils.createEarlyDataMaxSize(l));
    }

    public static void addEmptyExtensionData(Hashtable hashtable, Integer n) {
        hashtable.put(n, TlsExtensionsUtils.createEmptyExtensionData());
    }

    public static void addEncryptThenMACExtension(Hashtable hashtable) {
        hashtable.put(EXT_encrypt_then_mac, TlsExtensionsUtils.createEncryptThenMACExtension());
    }

    public static void addExtendedMasterSecretExtension(Hashtable hashtable) {
        hashtable.put(EXT_extended_master_secret, TlsExtensionsUtils.createExtendedMasterSecretExtension());
    }

    public static void addHeartbeatExtension(Hashtable hashtable, HeartbeatExtension heartbeatExtension) throws IOException {
        hashtable.put(EXT_heartbeat, TlsExtensionsUtils.createHeartbeatExtension(heartbeatExtension));
    }

    public static void addKeyShareClientHello(Hashtable hashtable, Vector vector) throws IOException {
        hashtable.put(EXT_key_share, TlsExtensionsUtils.createKeyShareClientHello(vector));
    }

    public static void addKeyShareHelloRetryRequest(Hashtable hashtable, int n) throws IOException {
        hashtable.put(EXT_key_share, TlsExtensionsUtils.createKeyShareHelloRetryRequest(n));
    }

    public static void addKeyShareServerHello(Hashtable hashtable, KeyShareEntry keyShareEntry) throws IOException {
        hashtable.put(EXT_key_share, TlsExtensionsUtils.createKeyShareServerHello(keyShareEntry));
    }

    public static void addMaxFragmentLengthExtension(Hashtable hashtable, short s) throws IOException {
        hashtable.put(EXT_max_fragment_length, TlsExtensionsUtils.createMaxFragmentLengthExtension(s));
    }

    public static void addOIDFiltersExtension(Hashtable hashtable, Hashtable hashtable2) throws IOException {
        hashtable.put(EXT_oid_filters, TlsExtensionsUtils.createOIDFiltersExtension(hashtable2));
    }

    public static void addPaddingExtension(Hashtable hashtable, int n) throws IOException {
        hashtable.put(EXT_padding, TlsExtensionsUtils.createPaddingExtension(n));
    }

    public static void addPostHandshakeAuthExtension(Hashtable hashtable) {
        hashtable.put(EXT_post_handshake_auth, TlsExtensionsUtils.createPostHandshakeAuthExtension());
    }

    public static void addPreSharedKeyClientHello(Hashtable hashtable, OfferedPsks offeredPsks) throws IOException {
        hashtable.put(EXT_pre_shared_key, TlsExtensionsUtils.createPreSharedKeyClientHello(offeredPsks));
    }

    public static void addPreSharedKeyServerHello(Hashtable hashtable, int n) throws IOException {
        hashtable.put(EXT_pre_shared_key, TlsExtensionsUtils.createPreSharedKeyServerHello(n));
    }

    public static void addPSKKeyExchangeModesExtension(Hashtable hashtable, short[] sArray) throws IOException {
        hashtable.put(EXT_psk_key_exchange_modes, TlsExtensionsUtils.createPSKKeyExchangeModesExtension(sArray));
    }

    public static void addRecordSizeLimitExtension(Hashtable hashtable, int n) throws IOException {
        hashtable.put(EXT_record_size_limit, TlsExtensionsUtils.createRecordSizeLimitExtension(n));
    }

    public static void addServerCertificateTypeExtensionClient(Hashtable hashtable, short[] sArray) throws IOException {
        hashtable.put(EXT_server_certificate_type, TlsExtensionsUtils.createCertificateTypeExtensionClient(sArray));
    }

    public static void addServerCertificateTypeExtensionServer(Hashtable hashtable, short s) throws IOException {
        hashtable.put(EXT_server_certificate_type, TlsExtensionsUtils.createCertificateTypeExtensionServer(s));
    }

    public static void addServerNameExtensionClient(Hashtable hashtable, Vector vector) throws IOException {
        hashtable.put(EXT_server_name, TlsExtensionsUtils.createServerNameExtensionClient(vector));
    }

    public static void addServerNameExtensionServer(Hashtable hashtable) throws IOException {
        hashtable.put(EXT_server_name, TlsExtensionsUtils.createServerNameExtensionServer());
    }

    public static void addSignatureAlgorithmsExtension(Hashtable hashtable, Vector vector) throws IOException {
        hashtable.put(EXT_signature_algorithms, TlsExtensionsUtils.createSignatureAlgorithmsExtension(vector));
    }

    public static void addSignatureAlgorithmsCertExtension(Hashtable hashtable, Vector vector) throws IOException {
        hashtable.put(EXT_signature_algorithms_cert, TlsExtensionsUtils.createSignatureAlgorithmsCertExtension(vector));
    }

    public static void addStatusRequestExtension(Hashtable hashtable, CertificateStatusRequest certificateStatusRequest) throws IOException {
        hashtable.put(EXT_status_request, TlsExtensionsUtils.createStatusRequestExtension(certificateStatusRequest));
    }

    public static void addStatusRequestV2Extension(Hashtable hashtable, Vector vector) throws IOException {
        hashtable.put(EXT_status_request_v2, TlsExtensionsUtils.createStatusRequestV2Extension(vector));
    }

    public static void addSupportedGroupsExtension(Hashtable hashtable, Vector vector) throws IOException {
        hashtable.put(EXT_supported_groups, TlsExtensionsUtils.createSupportedGroupsExtension(vector));
    }

    public static void addSupportedPointFormatsExtension(Hashtable hashtable, short[] sArray) throws IOException {
        hashtable.put(EXT_ec_point_formats, TlsExtensionsUtils.createSupportedPointFormatsExtension(sArray));
    }

    public static void addSupportedVersionsExtensionClient(Hashtable hashtable, ProtocolVersion[] protocolVersionArray) throws IOException {
        hashtable.put(EXT_supported_versions, TlsExtensionsUtils.createSupportedVersionsExtensionClient(protocolVersionArray));
    }

    public static void addSupportedVersionsExtensionServer(Hashtable hashtable, ProtocolVersion protocolVersion) throws IOException {
        hashtable.put(EXT_supported_versions, TlsExtensionsUtils.createSupportedVersionsExtensionServer(protocolVersion));
    }

    public static void addTruncatedHMacExtension(Hashtable hashtable) {
        hashtable.put(EXT_truncated_hmac, TlsExtensionsUtils.createTruncatedHMacExtension());
    }

    public static void addTrustedCAKeysExtensionClient(Hashtable hashtable, Vector vector) throws IOException {
        hashtable.put(EXT_trusted_ca_keys, TlsExtensionsUtils.createTrustedCAKeysExtensionClient(vector));
    }

    public static void addTrustedCAKeysExtensionServer(Hashtable hashtable) {
        hashtable.put(EXT_trusted_ca_keys, TlsExtensionsUtils.createTrustedCAKeysExtensionServer());
    }

    public static Vector getALPNExtensionClient(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_application_layer_protocol_negotiation);
        return byArray == null ? null : TlsExtensionsUtils.readALPNExtensionClient(byArray);
    }

    public static ProtocolName getALPNExtensionServer(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_application_layer_protocol_negotiation);
        return byArray == null ? null : TlsExtensionsUtils.readALPNExtensionServer(byArray);
    }

    public static Vector getCertificateAuthoritiesExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_certificate_authorities);
        return byArray == null ? null : TlsExtensionsUtils.readCertificateAuthoritiesExtension(byArray);
    }

    public static short[] getClientCertificateTypeExtensionClient(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_client_certificate_type);
        return byArray == null ? null : TlsExtensionsUtils.readCertificateTypeExtensionClient(byArray);
    }

    public static short getClientCertificateTypeExtensionServer(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_client_certificate_type);
        return byArray == null ? (short)-1 : (short)TlsExtensionsUtils.readCertificateTypeExtensionServer(byArray);
    }

    public static byte[] getCookieExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_cookie);
        return byArray == null ? null : TlsExtensionsUtils.readCookieExtension(byArray);
    }

    public static long getEarlyDataMaxSize(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_early_data);
        return byArray == null ? -1L : TlsExtensionsUtils.readEarlyDataMaxSize(byArray);
    }

    public static HeartbeatExtension getHeartbeatExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_heartbeat);
        return byArray == null ? null : TlsExtensionsUtils.readHeartbeatExtension(byArray);
    }

    public static Vector getKeyShareClientHello(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_key_share);
        return byArray == null ? null : TlsExtensionsUtils.readKeyShareClientHello(byArray);
    }

    public static int getKeyShareHelloRetryRequest(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_key_share);
        return byArray == null ? -1 : TlsExtensionsUtils.readKeyShareHelloRetryRequest(byArray);
    }

    public static KeyShareEntry getKeyShareServerHello(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_key_share);
        return byArray == null ? null : TlsExtensionsUtils.readKeyShareServerHello(byArray);
    }

    public static short getMaxFragmentLengthExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_max_fragment_length);
        return byArray == null ? (short)-1 : (short)TlsExtensionsUtils.readMaxFragmentLengthExtension(byArray);
    }

    public static Hashtable getOIDFiltersExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_oid_filters);
        return byArray == null ? null : TlsExtensionsUtils.readOIDFiltersExtension(byArray);
    }

    public static int getPaddingExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_padding);
        return byArray == null ? -1 : TlsExtensionsUtils.readPaddingExtension(byArray);
    }

    public static OfferedPsks getPreSharedKeyClientHello(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_pre_shared_key);
        return byArray == null ? null : TlsExtensionsUtils.readPreSharedKeyClientHello(byArray);
    }

    public static int getPreSharedKeyServerHello(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_pre_shared_key);
        return byArray == null ? -1 : TlsExtensionsUtils.readPreSharedKeyServerHello(byArray);
    }

    public static short[] getPSKKeyExchangeModesExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_psk_key_exchange_modes);
        return byArray == null ? null : TlsExtensionsUtils.readPSKKeyExchangeModesExtension(byArray);
    }

    public static int getRecordSizeLimitExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_record_size_limit);
        return byArray == null ? -1 : TlsExtensionsUtils.readRecordSizeLimitExtension(byArray);
    }

    public static short[] getServerCertificateTypeExtensionClient(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_server_certificate_type);
        return byArray == null ? null : TlsExtensionsUtils.readCertificateTypeExtensionClient(byArray);
    }

    public static short getServerCertificateTypeExtensionServer(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_server_certificate_type);
        return byArray == null ? (short)-1 : (short)TlsExtensionsUtils.readCertificateTypeExtensionServer(byArray);
    }

    public static Vector getServerNameExtensionClient(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_server_name);
        return byArray == null ? null : TlsExtensionsUtils.readServerNameExtensionClient(byArray);
    }

    public static Vector getSignatureAlgorithmsExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_signature_algorithms);
        return byArray == null ? null : TlsExtensionsUtils.readSignatureAlgorithmsExtension(byArray);
    }

    public static Vector getSignatureAlgorithmsCertExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_signature_algorithms_cert);
        return byArray == null ? null : TlsExtensionsUtils.readSignatureAlgorithmsCertExtension(byArray);
    }

    public static CertificateStatusRequest getStatusRequestExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_status_request);
        return byArray == null ? null : TlsExtensionsUtils.readStatusRequestExtension(byArray);
    }

    public static Vector getStatusRequestV2Extension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_status_request_v2);
        return byArray == null ? null : TlsExtensionsUtils.readStatusRequestV2Extension(byArray);
    }

    public static int[] getSupportedGroupsExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_supported_groups);
        return byArray == null ? null : TlsExtensionsUtils.readSupportedGroupsExtension(byArray);
    }

    public static short[] getSupportedPointFormatsExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_ec_point_formats);
        return byArray == null ? null : TlsExtensionsUtils.readSupportedPointFormatsExtension(byArray);
    }

    public static ProtocolVersion[] getSupportedVersionsExtensionClient(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_supported_versions);
        return byArray == null ? null : TlsExtensionsUtils.readSupportedVersionsExtensionClient(byArray);
    }

    public static ProtocolVersion getSupportedVersionsExtensionServer(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_supported_versions);
        return byArray == null ? null : TlsExtensionsUtils.readSupportedVersionsExtensionServer(byArray);
    }

    public static Vector getTrustedCAKeysExtensionClient(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_trusted_ca_keys);
        return byArray == null ? null : TlsExtensionsUtils.readTrustedCAKeysExtensionClient(byArray);
    }

    public static boolean hasClientCertificateURLExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_client_certificate_url);
        return byArray == null ? false : TlsExtensionsUtils.readClientCertificateURLExtension(byArray);
    }

    public static boolean hasEarlyDataIndication(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_early_data);
        return byArray == null ? false : TlsExtensionsUtils.readEarlyDataIndication(byArray);
    }

    public static boolean hasEncryptThenMACExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_encrypt_then_mac);
        return byArray == null ? false : TlsExtensionsUtils.readEncryptThenMACExtension(byArray);
    }

    public static boolean hasExtendedMasterSecretExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_extended_master_secret);
        return byArray == null ? false : TlsExtensionsUtils.readExtendedMasterSecretExtension(byArray);
    }

    public static boolean hasServerNameExtensionServer(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_server_name);
        return byArray == null ? false : TlsExtensionsUtils.readServerNameExtensionServer(byArray);
    }

    public static boolean hasPostHandshakeAuthExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_post_handshake_auth);
        return byArray == null ? false : TlsExtensionsUtils.readPostHandshakeAuthExtension(byArray);
    }

    public static boolean hasTruncatedHMacExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_truncated_hmac);
        return byArray == null ? false : TlsExtensionsUtils.readTruncatedHMacExtension(byArray);
    }

    public static boolean hasTrustedCAKeysExtensionServer(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, EXT_trusted_ca_keys);
        return byArray == null ? false : TlsExtensionsUtils.readTrustedCAKeysExtensionServer(byArray);
    }

    public static byte[] createALPNExtensionClient(Vector vector) throws IOException {
        if (vector == null || vector.size() < 1) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint16(0, byteArrayOutputStream);
        for (int i = 0; i < vector.size(); ++i) {
            ProtocolName protocolName = (ProtocolName)vector.elementAt(i);
            protocolName.encode(byteArrayOutputStream);
        }
        return TlsExtensionsUtils.patchOpaque16(byteArrayOutputStream);
    }

    public static byte[] createALPNExtensionServer(ProtocolName protocolName) throws IOException {
        Vector<ProtocolName> vector = new Vector<ProtocolName>();
        vector.addElement(protocolName);
        return TlsExtensionsUtils.createALPNExtensionClient(vector);
    }

    public static byte[] createCertificateAuthoritiesExtension(Vector vector) throws IOException {
        if (null == vector || vector.isEmpty()) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint16(0, byteArrayOutputStream);
        for (int i = 0; i < vector.size(); ++i) {
            X500Name x500Name = (X500Name)vector.elementAt(i);
            byte[] byArray = x500Name.getEncoded("DER");
            TlsUtils.writeOpaque16(byArray, byteArrayOutputStream);
        }
        return TlsExtensionsUtils.patchOpaque16(byteArrayOutputStream);
    }

    public static byte[] createCertificateTypeExtensionClient(short[] sArray) throws IOException {
        if (TlsUtils.isNullOrEmpty(sArray) || sArray.length > 255) {
            throw new TlsFatalAlert(80);
        }
        return TlsUtils.encodeUint8ArrayWithUint8Length(sArray);
    }

    public static byte[] createCertificateTypeExtensionServer(short s) throws IOException {
        return TlsUtils.encodeUint8(s);
    }

    public static byte[] createClientCertificateURLExtension() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createCookieExtension(byte[] byArray) throws IOException {
        if (TlsUtils.isNullOrEmpty(byArray) || byArray.length >= 65536) {
            throw new TlsFatalAlert(80);
        }
        return TlsUtils.encodeOpaque16(byArray);
    }

    public static byte[] createEarlyDataIndication() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createEarlyDataMaxSize(long l) throws IOException {
        return TlsUtils.encodeUint32(l);
    }

    public static byte[] createEmptyExtensionData() {
        return TlsUtils.EMPTY_BYTES;
    }

    public static byte[] createEncryptThenMACExtension() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createExtendedMasterSecretExtension() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createHeartbeatExtension(HeartbeatExtension heartbeatExtension) throws IOException {
        if (heartbeatExtension == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        heartbeatExtension.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] createKeyShareClientHello(Vector vector) throws IOException {
        if (vector == null || vector.isEmpty()) {
            return TlsUtils.encodeUint16(0);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint16(0, byteArrayOutputStream);
        for (int i = 0; i < vector.size(); ++i) {
            KeyShareEntry keyShareEntry = (KeyShareEntry)vector.elementAt(i);
            keyShareEntry.encode(byteArrayOutputStream);
        }
        return TlsExtensionsUtils.patchOpaque16(byteArrayOutputStream);
    }

    public static byte[] createKeyShareHelloRetryRequest(int n) throws IOException {
        return TlsUtils.encodeUint16(n);
    }

    public static byte[] createKeyShareServerHello(KeyShareEntry keyShareEntry) throws IOException {
        if (keyShareEntry == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        keyShareEntry.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] createMaxFragmentLengthExtension(short s) throws IOException {
        return TlsUtils.encodeUint8(s);
    }

    public static byte[] createOIDFiltersExtension(Hashtable hashtable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint16(0, byteArrayOutputStream);
        if (null != hashtable) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
                byte[] byArray = (byte[])hashtable.get(aSN1ObjectIdentifier);
                if (null == aSN1ObjectIdentifier || null == byArray) {
                    throw new TlsFatalAlert(80);
                }
                byte[] byArray2 = aSN1ObjectIdentifier.getEncoded("DER");
                TlsUtils.writeOpaque8(byArray2, byteArrayOutputStream);
                TlsUtils.writeOpaque16(byArray, byteArrayOutputStream);
            }
        }
        return TlsExtensionsUtils.patchOpaque16(byteArrayOutputStream);
    }

    public static byte[] createPaddingExtension(int n) throws IOException {
        TlsUtils.checkUint16(n);
        return new byte[n];
    }

    public static byte[] createPostHandshakeAuthExtension() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createPreSharedKeyClientHello(OfferedPsks offeredPsks) throws IOException {
        if (offeredPsks == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        offeredPsks.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] createPreSharedKeyServerHello(int n) throws IOException {
        return TlsUtils.encodeUint16(n);
    }

    public static byte[] createPSKKeyExchangeModesExtension(short[] sArray) throws IOException {
        if (TlsUtils.isNullOrEmpty(sArray) || sArray.length > 255) {
            throw new TlsFatalAlert(80);
        }
        return TlsUtils.encodeUint8ArrayWithUint8Length(sArray);
    }

    public static byte[] createRecordSizeLimitExtension(int n) throws IOException {
        if (n < 64) {
            throw new TlsFatalAlert(80);
        }
        return TlsUtils.encodeUint16(n);
    }

    public static byte[] createServerNameExtensionClient(Vector vector) throws IOException {
        if (vector == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        new ServerNameList(vector).encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] createServerNameExtensionServer() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createSignatureAlgorithmsExtension(Vector vector) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.encodeSupportedSignatureAlgorithms(vector, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] createSignatureAlgorithmsCertExtension(Vector vector) throws IOException {
        return TlsExtensionsUtils.createSignatureAlgorithmsExtension(vector);
    }

    public static byte[] createStatusRequestExtension(CertificateStatusRequest certificateStatusRequest) throws IOException {
        if (certificateStatusRequest == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateStatusRequest.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] createStatusRequestV2Extension(Vector vector) throws IOException {
        if (vector == null || vector.isEmpty()) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint16(0, byteArrayOutputStream);
        for (int i = 0; i < vector.size(); ++i) {
            CertificateStatusRequestItemV2 certificateStatusRequestItemV2 = (CertificateStatusRequestItemV2)vector.elementAt(i);
            certificateStatusRequestItemV2.encode(byteArrayOutputStream);
        }
        return TlsExtensionsUtils.patchOpaque16(byteArrayOutputStream);
    }

    public static byte[] createSupportedGroupsExtension(Vector vector) throws IOException {
        if (vector == null || vector.isEmpty()) {
            throw new TlsFatalAlert(80);
        }
        int n = vector.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (Integer)vector.elementAt(i);
        }
        return TlsUtils.encodeUint16ArrayWithUint16Length(nArray);
    }

    public static byte[] createSupportedPointFormatsExtension(short[] sArray) throws IOException {
        if (sArray == null || !Arrays.contains((short[])sArray, (short)0)) {
            sArray = Arrays.prepend((short[])sArray, (short)0);
        }
        return TlsUtils.encodeUint8ArrayWithUint8Length(sArray);
    }

    public static byte[] createSupportedVersionsExtensionClient(ProtocolVersion[] protocolVersionArray) throws IOException {
        if (TlsUtils.isNullOrEmpty(protocolVersionArray) || protocolVersionArray.length > 127) {
            throw new TlsFatalAlert(80);
        }
        int n = protocolVersionArray.length;
        byte[] byArray = new byte[1 + n * 2];
        TlsUtils.writeUint8(n * 2, byArray, 0);
        for (int i = 0; i < n; ++i) {
            TlsUtils.writeVersion(protocolVersionArray[i], byArray, 1 + i * 2);
        }
        return byArray;
    }

    public static byte[] createSupportedVersionsExtensionServer(ProtocolVersion protocolVersion) throws IOException {
        return TlsUtils.encodeVersion(protocolVersion);
    }

    public static byte[] createTruncatedHMacExtension() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createTrustedCAKeysExtensionClient(Vector vector) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint16(0, byteArrayOutputStream);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                TrustedAuthority trustedAuthority = (TrustedAuthority)vector.elementAt(i);
                trustedAuthority.encode(byteArrayOutputStream);
            }
        }
        return TlsExtensionsUtils.patchOpaque16(byteArrayOutputStream);
    }

    public static byte[] createTrustedCAKeysExtensionServer() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    private static boolean readEmptyExtensionData(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        if (byArray.length != 0) {
            throw new TlsFatalAlert(47);
        }
        return true;
    }

    public static Vector readALPNExtensionClient(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n = TlsUtils.readUint16(byteArrayInputStream);
        if (n != byArray.length - 2) {
            throw new TlsFatalAlert(50);
        }
        Vector<ProtocolName> vector = new Vector<ProtocolName>();
        while (byteArrayInputStream.available() > 0) {
            ProtocolName protocolName = ProtocolName.parse(byteArrayInputStream);
            vector.addElement(protocolName);
        }
        return vector;
    }

    public static ProtocolName readALPNExtensionServer(byte[] byArray) throws IOException {
        Vector vector = TlsExtensionsUtils.readALPNExtensionClient(byArray);
        if (vector.size() != 1) {
            throw new TlsFatalAlert(50);
        }
        return (ProtocolName)vector.elementAt(0);
    }

    public static Vector readCertificateAuthoritiesExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        if (byArray.length < 5) {
            throw new TlsFatalAlert(50);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n = TlsUtils.readUint16(byteArrayInputStream);
        if (n != byArray.length - 2) {
            throw new TlsFatalAlert(50);
        }
        Vector<X500Name> vector = new Vector<X500Name>();
        while (byteArrayInputStream.available() > 0) {
            byte[] byArray2 = TlsUtils.readOpaque16(byteArrayInputStream, 1);
            ASN1Primitive aSN1Primitive = TlsUtils.readASN1Object(byArray2);
            X500Name x500Name = X500Name.getInstance((Object)aSN1Primitive);
            TlsUtils.requireDEREncoding((ASN1Object)x500Name, byArray2);
            vector.addElement(x500Name);
        }
        return vector;
    }

    public static short[] readCertificateTypeExtensionClient(byte[] byArray) throws IOException {
        short[] sArray = TlsUtils.decodeUint8ArrayWithUint8Length(byArray);
        if (sArray.length < 1) {
            throw new TlsFatalAlert(50);
        }
        return sArray;
    }

    public static short readCertificateTypeExtensionServer(byte[] byArray) throws IOException {
        return TlsUtils.decodeUint8(byArray);
    }

    public static boolean readClientCertificateURLExtension(byte[] byArray) throws IOException {
        return TlsExtensionsUtils.readEmptyExtensionData(byArray);
    }

    public static byte[] readCookieExtension(byte[] byArray) throws IOException {
        return TlsUtils.decodeOpaque16(byArray, 1);
    }

    public static boolean readEarlyDataIndication(byte[] byArray) throws IOException {
        return TlsExtensionsUtils.readEmptyExtensionData(byArray);
    }

    public static long readEarlyDataMaxSize(byte[] byArray) throws IOException {
        return TlsUtils.decodeUint32(byArray);
    }

    public static boolean readEncryptThenMACExtension(byte[] byArray) throws IOException {
        return TlsExtensionsUtils.readEmptyExtensionData(byArray);
    }

    public static boolean readExtendedMasterSecretExtension(byte[] byArray) throws IOException {
        return TlsExtensionsUtils.readEmptyExtensionData(byArray);
    }

    public static HeartbeatExtension readHeartbeatExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        HeartbeatExtension heartbeatExtension = HeartbeatExtension.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return heartbeatExtension;
    }

    public static Vector readKeyShareClientHello(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n = TlsUtils.readUint16(byteArrayInputStream);
        if (n != byArray.length - 2) {
            throw new TlsFatalAlert(50);
        }
        Vector<KeyShareEntry> vector = new Vector<KeyShareEntry>();
        while (byteArrayInputStream.available() > 0) {
            KeyShareEntry keyShareEntry = KeyShareEntry.parse(byteArrayInputStream);
            vector.addElement(keyShareEntry);
        }
        return vector;
    }

    public static int readKeyShareHelloRetryRequest(byte[] byArray) throws IOException {
        return TlsUtils.decodeUint16(byArray);
    }

    public static KeyShareEntry readKeyShareServerHello(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        KeyShareEntry keyShareEntry = KeyShareEntry.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return keyShareEntry;
    }

    public static short readMaxFragmentLengthExtension(byte[] byArray) throws IOException {
        return TlsUtils.decodeUint8(byArray);
    }

    public static Hashtable readOIDFiltersExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        if (byArray.length < 2) {
            throw new TlsFatalAlert(50);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n = TlsUtils.readUint16(byteArrayInputStream);
        if (n != byArray.length - 2) {
            throw new TlsFatalAlert(50);
        }
        Hashtable<ASN1ObjectIdentifier, byte[]> hashtable = new Hashtable<ASN1ObjectIdentifier, byte[]>();
        while (byteArrayInputStream.available() > 0) {
            byte[] byArray2 = TlsUtils.readOpaque8(byteArrayInputStream, 1);
            ASN1Primitive aSN1Primitive = TlsUtils.readASN1Object(byArray2);
            ASN1ObjectIdentifier aSN1ObjectIdentifier = ASN1ObjectIdentifier.getInstance((Object)aSN1Primitive);
            TlsUtils.requireDEREncoding((ASN1Object)aSN1ObjectIdentifier, byArray2);
            if (hashtable.containsKey(aSN1ObjectIdentifier)) {
                throw new TlsFatalAlert(47);
            }
            byte[] byArray3 = TlsUtils.readOpaque16(byteArrayInputStream);
            hashtable.put(aSN1ObjectIdentifier, byArray3);
        }
        return hashtable;
    }

    public static int readPaddingExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n |= byArray[i];
        }
        if (n != 0) {
            throw new TlsFatalAlert(47);
        }
        return byArray.length;
    }

    public static boolean readPostHandshakeAuthExtension(byte[] byArray) throws IOException {
        return TlsExtensionsUtils.readEmptyExtensionData(byArray);
    }

    public static OfferedPsks readPreSharedKeyClientHello(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        OfferedPsks offeredPsks = OfferedPsks.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return offeredPsks;
    }

    public static int readPreSharedKeyServerHello(byte[] byArray) throws IOException {
        return TlsUtils.decodeUint16(byArray);
    }

    public static short[] readPSKKeyExchangeModesExtension(byte[] byArray) throws IOException {
        short[] sArray = TlsUtils.decodeUint8ArrayWithUint8Length(byArray);
        if (sArray.length < 1) {
            throw new TlsFatalAlert(50);
        }
        return sArray;
    }

    public static int readRecordSizeLimitExtension(byte[] byArray) throws IOException {
        int n = TlsUtils.decodeUint16(byArray);
        if (n < 64) {
            throw new TlsFatalAlert(47);
        }
        return n;
    }

    public static Vector readServerNameExtensionClient(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ServerNameList serverNameList = ServerNameList.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return serverNameList.getServerNameList();
    }

    public static boolean readServerNameExtensionServer(byte[] byArray) throws IOException {
        return TlsExtensionsUtils.readEmptyExtensionData(byArray);
    }

    public static Vector readSignatureAlgorithmsExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector vector = TlsUtils.parseSupportedSignatureAlgorithms(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return vector;
    }

    public static Vector readSignatureAlgorithmsCertExtension(byte[] byArray) throws IOException {
        return TlsExtensionsUtils.readSignatureAlgorithmsExtension(byArray);
    }

    public static CertificateStatusRequest readStatusRequestExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        CertificateStatusRequest certificateStatusRequest = CertificateStatusRequest.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return certificateStatusRequest;
    }

    public static Vector readStatusRequestV2Extension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        if (byArray.length < 3) {
            throw new TlsFatalAlert(50);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n = TlsUtils.readUint16(byteArrayInputStream);
        if (n != byArray.length - 2) {
            throw new TlsFatalAlert(50);
        }
        Vector<CertificateStatusRequestItemV2> vector = new Vector<CertificateStatusRequestItemV2>();
        while (byteArrayInputStream.available() > 0) {
            CertificateStatusRequestItemV2 certificateStatusRequestItemV2 = CertificateStatusRequestItemV2.parse(byteArrayInputStream);
            vector.add(certificateStatusRequestItemV2);
        }
        return vector;
    }

    public static int[] readSupportedGroupsExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n = TlsUtils.readUint16(byteArrayInputStream);
        if (n < 2 || (n & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        int[] nArray = TlsUtils.readUint16Array(n / 2, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return nArray;
    }

    public static short[] readSupportedPointFormatsExtension(byte[] byArray) throws IOException {
        short[] sArray = TlsUtils.decodeUint8ArrayWithUint8Length(byArray);
        if (!Arrays.contains((short[])sArray, (short)0)) {
            throw new TlsFatalAlert(47);
        }
        return sArray;
    }

    public static ProtocolVersion[] readSupportedVersionsExtensionClient(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        if (byArray.length < 3 || byArray.length > 255 || (byArray.length & 1) == 0) {
            throw new TlsFatalAlert(50);
        }
        short s = TlsUtils.readUint8(byArray, 0);
        if (s != byArray.length - 1) {
            throw new TlsFatalAlert(50);
        }
        int n = s / 2;
        ProtocolVersion[] protocolVersionArray = new ProtocolVersion[n];
        for (int i = 0; i < n; ++i) {
            protocolVersionArray[i] = TlsUtils.readVersion(byArray, 1 + i * 2);
        }
        return protocolVersionArray;
    }

    public static ProtocolVersion readSupportedVersionsExtensionServer(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        if (byArray.length != 2) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readVersion(byArray, 0);
    }

    public static boolean readTruncatedHMacExtension(byte[] byArray) throws IOException {
        return TlsExtensionsUtils.readEmptyExtensionData(byArray);
    }

    public static Vector readTrustedCAKeysExtensionClient(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        if (byArray.length < 2) {
            throw new TlsFatalAlert(50);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n = TlsUtils.readUint16(byteArrayInputStream);
        if (n != byArray.length - 2) {
            throw new TlsFatalAlert(50);
        }
        Vector<TrustedAuthority> vector = new Vector<TrustedAuthority>();
        while (byteArrayInputStream.available() > 0) {
            TrustedAuthority trustedAuthority = TrustedAuthority.parse(byteArrayInputStream);
            vector.addElement(trustedAuthority);
        }
        return vector;
    }

    public static boolean readTrustedCAKeysExtensionServer(byte[] byArray) throws IOException {
        return TlsExtensionsUtils.readEmptyExtensionData(byArray);
    }

    private static byte[] patchOpaque16(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        int n = byteArrayOutputStream.size() - 2;
        TlsUtils.checkUint16(n);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        TlsUtils.writeUint16(n, byArray, 0);
        return byArray;
    }
}

