/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.bouncycastle.util.Pack;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JceChaCha20Poly1305
implements TlsAEADCipherImpl {
    private static final int BUF_SIZE = 32768;
    private static final byte[] ZEROES = new byte[15];
    protected final Cipher cipher;
    protected final Mac mac;
    protected final int cipherMode;
    protected SecretKey cipherKey;
    protected byte[] additionalData;

    public JceChaCha20Poly1305(JcaJceHelper jcaJceHelper, boolean bl) throws GeneralSecurityException {
        this.cipher = jcaJceHelper.createCipher("ChaCha7539");
        this.mac = jcaJceHelper.createMac("Poly1305");
        this.cipherMode = bl ? 1 : 2;
    }

    @Override
    public int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, byte[] byArray3, int n3) throws IOException {
        try {
            boolean bl;
            int n4 = byArray2.length;
            if (this.cipherMode == 1) {
                int n5 = n2 + n4;
                byte[] byArray4 = new byte[64 + n5];
                System.arraycopy(byArray, n, byArray4, 64, n2);
                System.arraycopy(byArray2, 0, byArray4, 64 + n2, n4);
                this.runCipher(byArray4);
                System.arraycopy(byArray4, 64, byArray3, n3, n5);
                this.initMAC(byArray4);
                this.updateMAC(this.additionalData, 0, this.additionalData.length);
                this.updateMAC(byArray4, 64, n5);
                byte[] byArray5 = new byte[16];
                Pack.longToLittleEndian((long)((long)this.additionalData.length & 0xFFFFFFFFL), (byte[])byArray5, (int)0);
                Pack.longToLittleEndian((long)((long)n5 & 0xFFFFFFFFL), (byte[])byArray5, (int)8);
                this.mac.update(byArray5, 0, 16);
                this.mac.doFinal(byArray3, n3 + n5);
                return n5 + 16;
            }
            if (n4 > 0) {
                throw new TlsFatalAlert(80);
            }
            int n6 = n2 - 16;
            byte[] byArray6 = new byte[64 + n6];
            System.arraycopy(byArray, n, byArray6, 64, n6);
            this.runCipher(byArray6);
            this.initMAC(byArray6);
            this.updateMAC(this.additionalData, 0, this.additionalData.length);
            this.updateMAC(byArray, n, n6);
            byte[] byArray7 = new byte[16];
            Pack.longToLittleEndian((long)((long)this.additionalData.length & 0xFFFFFFFFL), (byte[])byArray7, (int)0);
            Pack.longToLittleEndian((long)((long)n6 & 0xFFFFFFFFL), (byte[])byArray7, (int)8);
            this.mac.update(byArray7, 0, 16);
            this.mac.doFinal(byArray7, 0);
            boolean bl2 = bl = !TlsUtils.constantTimeAreEqual(16, byArray7, 0, byArray, n + n6);
            if (bl) {
                throw new TlsFatalAlert(20);
            }
            System.arraycopy(byArray6, 64, byArray3, n3, n6);
            return n6;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException(generalSecurityException);
        }
    }

    @Override
    public int getOutputSize(int n) {
        return this.cipherMode == 1 ? n + 16 : n - 16;
    }

    @Override
    public void init(byte[] byArray, int n, byte[] byArray2) throws IOException {
        if (byArray == null || byArray.length != 12 || n != 16) {
            throw new TlsFatalAlert(80);
        }
        try {
            this.cipher.init(this.cipherMode, (Key)this.cipherKey, new IvParameterSpec(byArray), null);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException(generalSecurityException);
        }
        this.additionalData = byArray2;
    }

    @Override
    public void setKey(byte[] byArray, int n, int n2) throws IOException {
        this.cipherKey = new SecretKeySpec(byArray, n, n2, "ChaCha7539");
    }

    protected void initMAC(byte[] byArray) throws InvalidKeyException {
        this.mac.init(new SecretKeySpec(byArray, 0, 32, "Poly1305"));
        for (int i = 0; i < 64; ++i) {
            byArray[i] = 0;
        }
    }

    protected void runCipher(byte[] byArray) throws GeneralSecurityException {
        int n;
        int n2 = 0;
        for (int i = 0; i < byArray.length; i += n) {
            n = Math.min(32768, byArray.length - i);
            n2 += this.cipher.update(byArray, i, n, byArray, n2);
        }
        if (byArray.length != (n2 += this.cipher.doFinal(byArray, n2))) {
            throw new IllegalStateException();
        }
    }

    protected void updateMAC(byte[] byArray, int n, int n2) {
        this.mac.update(byArray, n, n2);
        int n3 = n2 % 16;
        if (n3 != 0) {
            this.mac.update(ZEROES, 0, 16 - n3);
        }
    }
}

