/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.tls.TlsClientProtocol;
import org.bouncycastle.tls.TlsHandshakeHash;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class HandshakeMessageOutput
extends ByteArrayOutputStream {
    static int getLength(int bodyLength) {
        return 4 + bodyLength;
    }

    static void send(TlsProtocol protocol, short handshakeType, byte[] body) throws IOException {
        HandshakeMessageOutput message = new HandshakeMessageOutput(handshakeType, body.length);
        message.write(body);
        message.send(protocol);
    }

    HandshakeMessageOutput(short handshakeType) throws IOException {
        this(handshakeType, 60);
    }

    HandshakeMessageOutput(short handshakeType, int bodyLength) throws IOException {
        super(HandshakeMessageOutput.getLength(bodyLength));
        TlsUtils.checkUint8(handshakeType);
        TlsUtils.writeUint8(handshakeType, (OutputStream)this);
        this.count += 3;
    }

    void send(TlsProtocol protocol) throws IOException {
        int bodyLength = this.count - 4;
        TlsUtils.checkUint24(bodyLength);
        TlsUtils.writeUint24(bodyLength, this.buf, 1);
        protocol.writeHandshakeMessage(this.buf, 0, this.count);
        this.buf = null;
    }

    void prepareClientHello(TlsHandshakeHash handshakeHash, int bindersSize) throws IOException {
        int bodyLength = this.count - 4 + bindersSize;
        TlsUtils.checkUint24(bodyLength);
        TlsUtils.writeUint24(bodyLength, this.buf, 1);
        handshakeHash.update(this.buf, 0, this.count);
    }

    void sendClientHello(TlsClientProtocol clientProtocol, TlsHandshakeHash handshakeHash, int bindersSize) throws IOException {
        if (bindersSize > 0) {
            handshakeHash.update(this.buf, this.count - bindersSize, bindersSize);
        }
        clientProtocol.writeHandshakeMessage(this.buf, 0, this.count);
        this.buf = null;
    }
}

