/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto;

import java.io.IOException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class Hex {
    protected final byte[] encodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    protected final byte[] decodingTable = new byte[128];
    private static final Hex encoder = new Hex();

    protected Hex() {
        int n;
        for (n = 0; n < this.decodingTable.length; ++n) {
            this.decodingTable[n] = -1;
        }
        for (n = 0; n < this.encodingTable.length; ++n) {
            this.decodingTable[this.encodingTable[n]] = (byte)n;
        }
        this.decodingTable[65] = this.decodingTable[97];
        this.decodingTable[66] = this.decodingTable[98];
        this.decodingTable[67] = this.decodingTable[99];
        this.decodingTable[68] = this.decodingTable[100];
        this.decodingTable[69] = this.decodingTable[101];
        this.decodingTable[70] = this.decodingTable[102];
    }

    public static byte[] decodeStrict(String string) {
        try {
            return encoder.decodeStrict(string, 0, string.length());
        }
        catch (Exception exception) {
            throw new IllegalStateException("exception decoding Hex string: " + exception.getMessage(), exception);
        }
    }

    byte[] decodeStrict(String string, int n, int n2) throws IOException {
        if (null == string) {
            throw new NullPointerException("'str' cannot be null");
        }
        if (n < 0 || n2 < 0 || n > string.length() - n2) {
            throw new IndexOutOfBoundsException("invalid offset and/or length specified");
        }
        if (0 != (n2 & 1)) {
            throw new IOException("a hexadecimal encoding must have an even number of characters");
        }
        int n3 = n2 >>> 1;
        byte[] byArray = new byte[n3];
        int n4 = n;
        for (int i = 0; i < n3; ++i) {
            byte by;
            byte by2;
            int n5;
            if ((n5 = (by2 = this.decodingTable[string.charAt(n4++)]) << 4 | (by = this.decodingTable[string.charAt(n4++)])) < 0) {
                throw new IOException("invalid characters encountered in Hex string");
            }
            byArray[i] = (byte)n5;
        }
        return byArray;
    }
}

