/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.rainbow;

import org.bouncycastle.pqc.crypto.rainbow.GF2Field;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ComputeInField {
    public short[] solveEquation(short[][] B, short[] b) {
        if (B.length != b.length) {
            return null;
        }
        try {
            int i;
            short[][] A = new short[B.length][B.length + 1];
            short[] x = new short[B.length];
            for (i = 0; i < B.length; ++i) {
                System.arraycopy(B[i], 0, A[i], 0, B[0].length);
                A[i][b.length] = GF2Field.addElem(b[i], A[i][b.length]);
            }
            this.gaussElim(A);
            for (i = 0; i < A.length; ++i) {
                x[i] = A[i][b.length];
            }
            return x;
        }
        catch (RuntimeException rte) {
            return null;
        }
    }

    public short[][] inverse(short[][] coef) {
        if (coef.length != coef[0].length) {
            throw new RuntimeException("The matrix is not invertible. Please choose another one!");
        }
        try {
            int j;
            int i;
            short[][] A = new short[coef.length][2 * coef.length];
            for (i = 0; i < coef.length; ++i) {
                System.arraycopy(coef[i], 0, A[i], 0, coef.length);
                for (j = coef.length; j < 2 * coef.length; ++j) {
                    A[i][j] = 0;
                }
                A[i][i + A.length] = 1;
            }
            this.gaussElim(A);
            short[][] inverse = new short[A.length][A.length];
            for (i = 0; i < A.length; ++i) {
                for (j = A.length; j < 2 * A.length; ++j) {
                    inverse[i][j - A.length] = A[i][j];
                }
            }
            return inverse;
        }
        catch (RuntimeException rte) {
            return null;
        }
    }

    private void gaussElim(short[][] A) {
        for (int i = 0; i < A.length; ++i) {
            int k;
            int j;
            for (j = i + 1; j < A.length; ++j) {
                if (A[i][i] != 0) continue;
                for (k = i; k < A[0].length; ++k) {
                    A[i][k] = GF2Field.addElem(A[i][k], A[j][k]);
                }
            }
            short factor = GF2Field.invElem(A[i][i]);
            if (factor == 0) {
                throw new RuntimeException("The matrix is not invertible");
            }
            A[i] = this.multVect(factor, A[i]);
            for (j = 0; j < A.length; ++j) {
                if (i == j) continue;
                short factor2 = A[j][i];
                for (k = i; k < A[0].length; ++k) {
                    short tmp = GF2Field.multElem(A[i][k], factor2);
                    A[j][k] = GF2Field.addElem(A[j][k], tmp);
                }
            }
        }
    }

    public short[][] multiplyMatrix(short[][] M1, short[][] M2) throws RuntimeException {
        if (M1[0].length != M2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short tmp = 0;
        short[][] A = new short[M1.length][M2[0].length];
        for (int i = 0; i < M1.length; ++i) {
            for (int j = 0; j < M2.length; ++j) {
                for (int k = 0; k < M2[0].length; ++k) {
                    tmp = GF2Field.multElem(M1[i][j], M2[j][k]);
                    A[i][k] = GF2Field.addElem(A[i][k], tmp);
                }
            }
        }
        return A;
    }

    public short[] multiplyMatrix(short[][] M1, short[] m) throws RuntimeException {
        if (M1[0].length != m.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short tmp = 0;
        short[] B = new short[M1.length];
        for (int i = 0; i < M1.length; ++i) {
            for (int j = 0; j < m.length; ++j) {
                tmp = GF2Field.multElem(M1[i][j], m[j]);
                B[i] = GF2Field.addElem(B[i], tmp);
            }
        }
        return B;
    }

    public short multiplyMatrix_quad(short[][] M1, short[] m) throws RuntimeException {
        if (M1.length != M1[0].length || M1[0].length != m.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short tmp = 0;
        short[] B = new short[M1.length];
        short ret = 0;
        for (int i = 0; i < M1.length; ++i) {
            for (int j = 0; j < m.length; ++j) {
                tmp = GF2Field.multElem(M1[i][j], m[j]);
                B[i] = GF2Field.addElem(B[i], tmp);
            }
            tmp = GF2Field.multElem(B[i], m[i]);
            ret = GF2Field.addElem(ret, tmp);
        }
        return ret;
    }

    public short[] addVect(short[] vector1, short[] vector2) {
        if (vector1.length != vector2.length) {
            throw new RuntimeException("Addition is not possible! vector1.length: " + vector1.length + " vector2.length: " + vector2.length);
        }
        short[] rslt = new short[vector1.length];
        for (int n = 0; n < rslt.length; ++n) {
            rslt[n] = GF2Field.addElem(vector1[n], vector2[n]);
        }
        return rslt;
    }

    public short[][] multVects(short[] vector1, short[] vector2) {
        if (vector1.length != vector2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short[][] rslt = new short[vector1.length][vector2.length];
        for (int i = 0; i < vector1.length; ++i) {
            for (int j = 0; j < vector2.length; ++j) {
                rslt[i][j] = GF2Field.multElem(vector1[i], vector2[j]);
            }
        }
        return rslt;
    }

    public short[] multVect(short scalar, short[] vector) {
        short[] rslt = new short[vector.length];
        for (int n = 0; n < rslt.length; ++n) {
            rslt[n] = GF2Field.multElem(scalar, vector[n]);
        }
        return rslt;
    }

    public short[][] multMatrix(short scalar, short[][] matrix) {
        short[][] rslt = new short[matrix.length][matrix[0].length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                rslt[i][j] = GF2Field.multElem(scalar, matrix[i][j]);
            }
        }
        return rslt;
    }

    public short[][] addMatrix(short[][] matrix1, short[][] matrix2) {
        if (matrix1.length != matrix2.length || matrix1[0].length != matrix2[0].length) {
            throw new RuntimeException("Addition is not possible!");
        }
        short[][] rslt = new short[matrix1.length][matrix1[0].length];
        for (int i = 0; i < matrix1.length; ++i) {
            for (int j = 0; j < matrix1[0].length; ++j) {
                rslt[i][j] = GF2Field.addElem(matrix1[i][j], matrix2[i][j]);
            }
        }
        return rslt;
    }

    public short[][] addMatrixTranspose(short[][] matrix) {
        if (matrix.length != matrix[0].length) {
            throw new RuntimeException("Addition is not possible!");
        }
        return this.addMatrix(matrix, this.transpose(matrix));
    }

    public short[][] transpose(short[][] matrix) {
        short[][] rslt = new short[matrix[0].length][matrix.length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[0].length; ++j) {
                rslt[j][i] = matrix[i][j];
            }
        }
        return rslt;
    }

    public short[][] to_UT(short[][] matrix) {
        if (matrix.length != matrix[0].length) {
            throw new RuntimeException("Computation to upper triangular matrix is not possible!");
        }
        short[][] rslt = new short[matrix.length][matrix.length];
        for (int i = 0; i < matrix.length; ++i) {
            rslt[i][i] = matrix[i][i];
            for (int j = i + 1; j < matrix[0].length; ++j) {
                rslt[i][j] = GF2Field.addElem(matrix[i][j], matrix[j][i]);
            }
        }
        return rslt;
    }

    public short[][][] obfuscate_l1_polys(short[][] a, short[][][] b, short[][][] c) {
        if (b[0].length != c[0].length || b[0][0].length != c[0][0].length || b.length != a[0].length || c.length != a.length) {
            throw new RuntimeException("Multiplication not possible!");
        }
        short[][][] ret = new short[c.length][c[0].length][c[0][0].length];
        for (int i = 0; i < b[0].length; ++i) {
            for (int j = 0; j < b[0][0].length; ++j) {
                for (int l = 0; l < a.length; ++l) {
                    for (int k = 0; k < a[0].length; ++k) {
                        short temp = GF2Field.multElem(a[l][k], b[k][i][j]);
                        ret[l][i][j] = GF2Field.addElem(ret[l][i][j], temp);
                    }
                    ret[l][i][j] = GF2Field.addElem(c[l][i][j], ret[l][i][j]);
                }
            }
        }
        return ret;
    }
}

