/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.ntru;

import org.bouncycastle.crypto.EncapsulatedSecretExtractor;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.pqc.crypto.ntru.NTRUOWCPA;
import org.bouncycastle.pqc.crypto.ntru.NTRUParameters;
import org.bouncycastle.pqc.crypto.ntru.NTRUPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.ntru.OWCPADecryptResult;
import org.bouncycastle.pqc.math.ntru.parameters.NTRUParameterSet;
import org.bouncycastle.util.Arrays;

public class NTRUKEMExtractor
implements EncapsulatedSecretExtractor {
    private final NTRUParameters params;
    private final NTRUPrivateKeyParameters ntruPrivateKey;

    public NTRUKEMExtractor(NTRUPrivateKeyParameters ntruPrivateKey) {
        this.params = ntruPrivateKey.getParameters();
        this.ntruPrivateKey = ntruPrivateKey;
    }

    @Override
    public byte[] extractSecret(byte[] encapsulation) {
        int i;
        NTRUParameterSet parameterSet = this.params.parameterSet;
        byte[] sk = this.ntruPrivateKey.privateKey;
        byte[] buf = new byte[parameterSet.prfKeyBytes() + parameterSet.ntruCiphertextBytes()];
        NTRUOWCPA owcpa = new NTRUOWCPA(parameterSet);
        OWCPADecryptResult owcpaResult = owcpa.decrypt(encapsulation, this.ntruPrivateKey.privateKey);
        byte[] rm = owcpaResult.rm;
        int fail = owcpaResult.fail;
        SHA3Digest sha3256 = new SHA3Digest(256);
        byte[] k = new byte[sha3256.getDigestSize()];
        sha3256.update(rm, 0, rm.length);
        sha3256.doFinal(k, 0);
        for (i = 0; i < parameterSet.prfKeyBytes(); ++i) {
            buf[i] = sk[i + parameterSet.owcpaSecretKeyBytes()];
        }
        for (i = 0; i < parameterSet.ntruCiphertextBytes(); ++i) {
            buf[parameterSet.prfKeyBytes() + i] = encapsulation[i];
        }
        sha3256.reset();
        sha3256.update(buf, 0, buf.length);
        sha3256.doFinal(rm, 0);
        this.cmov(k, rm, (byte)fail);
        byte[] sharedKey = Arrays.copyOfRange(k, 0, parameterSet.sharedKeyBytes());
        Arrays.clear(k);
        return sharedKey;
    }

    private void cmov(byte[] r, byte[] x, byte b) {
        b = (byte)(~b + 1);
        for (int i = 0; i < r.length; ++i) {
            int n = i;
            r[n] = (byte)(r[n] ^ b & (x[i] ^ r[i]));
        }
    }

    @Override
    public int getEncapsulationLength() {
        return this.params.parameterSet.ntruCiphertextBytes();
    }
}

