/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.compositesignatures;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.util.DigestFactory;
import org.bouncycastle.jcajce.CompositePrivateKey;
import org.bouncycastle.jcajce.CompositePublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.CompositeSignaturesConstants;
import org.bouncycastle.jcajce.spec.CompositeAlgorithmSpec;
import org.bouncycastle.util.Exceptions;

public class SignatureSpi
extends java.security.SignatureSpi {
    private static final Map<String, String> canonicalNames = new HashMap<String, String>();
    private static final String ML_DSA_44 = "ML-DSA-44";
    private static final String ML_DSA_65 = "ML-DSA-65";
    private static final String ML_DSA_87 = "ML-DSA-87";
    private final CompositeSignaturesConstants.CompositeName algorithmIdentifier;
    private final ASN1ObjectIdentifier algorithmIdentifierASN1;
    private final List<Signature> componentSignatures;
    private final Digest digest;
    private byte[] OIDBytes;

    SignatureSpi(CompositeSignaturesConstants.CompositeName algorithmIdentifier) {
        this.algorithmIdentifier = algorithmIdentifier;
        this.algorithmIdentifierASN1 = CompositeSignaturesConstants.compositeNameASN1IdentifierMap.get((Object)this.algorithmIdentifier);
        ArrayList<Signature> componentSignatures = new ArrayList<Signature>();
        try {
            switch (this.algorithmIdentifier) {
                case MLDSA44_Ed25519_SHA512: {
                    componentSignatures.add(Signature.getInstance(ML_DSA_44, "BC"));
                    componentSignatures.add(Signature.getInstance("Ed25519", "BC"));
                    this.digest = DigestFactory.createSHA512();
                    break;
                }
                case MLDSA65_Ed25519_SHA512: {
                    componentSignatures.add(Signature.getInstance(ML_DSA_65, "BC"));
                    componentSignatures.add(Signature.getInstance("Ed25519", "BC"));
                    this.digest = DigestFactory.createSHA512();
                    break;
                }
                case MLDSA87_Ed448_SHA512: {
                    componentSignatures.add(Signature.getInstance(ML_DSA_87, "BC"));
                    componentSignatures.add(Signature.getInstance("Ed448", "BC"));
                    this.digest = DigestFactory.createSHA512();
                    break;
                }
                case MLDSA44_RSA2048_PSS_SHA256: {
                    componentSignatures.add(Signature.getInstance(ML_DSA_44, "BC"));
                    componentSignatures.add(Signature.getInstance("SHA256withRSA/PSS", "BC"));
                    this.digest = DigestFactory.createSHA256();
                    break;
                }
                case MLDSA65_RSA3072_PSS_SHA512: {
                    componentSignatures.add(Signature.getInstance(ML_DSA_65, "BC"));
                    componentSignatures.add(Signature.getInstance("SHA512withRSA/PSS", "BC"));
                    this.digest = DigestFactory.createSHA512();
                    break;
                }
                case MLDSA44_RSA2048_PKCS15_SHA256: {
                    componentSignatures.add(Signature.getInstance(ML_DSA_44, "BC"));
                    componentSignatures.add(Signature.getInstance("SHA256withRSA", "BC"));
                    this.digest = DigestFactory.createSHA256();
                    break;
                }
                case MLDSA65_RSA3072_PKCS15_SHA512: {
                    componentSignatures.add(Signature.getInstance(ML_DSA_65, "BC"));
                    componentSignatures.add(Signature.getInstance("SHA512withRSA", "BC"));
                    this.digest = DigestFactory.createSHA512();
                    break;
                }
                case MLDSA44_ECDSA_P256_SHA256: 
                case MLDSA44_ECDSA_brainpoolP256r1_SHA256: {
                    componentSignatures.add(Signature.getInstance(ML_DSA_44, "BC"));
                    componentSignatures.add(Signature.getInstance("SHA256withECDSA", "BC"));
                    this.digest = DigestFactory.createSHA256();
                    break;
                }
                case MLDSA65_ECDSA_P256_SHA512: 
                case MLDSA65_ECDSA_brainpoolP256r1_SHA512: {
                    componentSignatures.add(Signature.getInstance(ML_DSA_65, "BC"));
                    componentSignatures.add(Signature.getInstance("SHA512withECDSA", "BC"));
                    this.digest = DigestFactory.createSHA512();
                    break;
                }
                case MLDSA87_ECDSA_P384_SHA512: 
                case MLDSA87_ECDSA_brainpoolP384r1_SHA512: {
                    componentSignatures.add(Signature.getInstance(ML_DSA_87, "BC"));
                    componentSignatures.add(Signature.getInstance("SHA512withECDSA", "BC"));
                    this.digest = DigestFactory.createSHA512();
                    break;
                }
                case Falcon512_ECDSA_P256_SHA256: 
                case Falcon512_ECDSA_brainpoolP256r1_SHA256: {
                    componentSignatures.add(Signature.getInstance("Falcon", "BC"));
                    componentSignatures.add(Signature.getInstance("SHA256withECDSA", "BC"));
                    this.digest = DigestFactory.createSHA256();
                    break;
                }
                case Falcon512_Ed25519_SHA512: {
                    componentSignatures.add(Signature.getInstance("Falcon", "BC"));
                    componentSignatures.add(Signature.getInstance("Ed25519", "BC"));
                    this.digest = DigestFactory.createSHA512();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown composite algorithm");
                }
            }
            this.OIDBytes = this.algorithmIdentifierASN1.getEncoded("DER");
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.illegalStateException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw Exceptions.illegalStateException(e.getMessage(), e);
        }
        this.componentSignatures = Collections.unmodifiableList(componentSignatures);
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof CompositePublicKey)) {
            throw new InvalidKeyException("Public key is not composite.");
        }
        CompositePublicKey compositePublicKey = (CompositePublicKey)publicKey;
        if (!compositePublicKey.getAlgorithmIdentifier().equals(this.algorithmIdentifierASN1)) {
            throw new InvalidKeyException("Provided composite public key cannot be used with the composite signature algorithm.");
        }
        for (int i = 0; i < this.componentSignatures.size(); ++i) {
            this.componentSignatures.get(i).initVerify(compositePublicKey.getPublicKeys().get(i));
        }
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof CompositePrivateKey)) {
            throw new InvalidKeyException("Private key is not composite.");
        }
        CompositePrivateKey compositePrivateKey = (CompositePrivateKey)privateKey;
        if (!compositePrivateKey.getAlgorithmIdentifier().equals(this.algorithmIdentifierASN1)) {
            throw new InvalidKeyException("Provided composite private key cannot be used with the composite signature algorithm.");
        }
        for (int i = 0; i < this.componentSignatures.size(); ++i) {
            this.componentSignatures.get(i).initSign(compositePrivateKey.getPrivateKeys().get(i));
        }
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.digest.update(b);
    }

    @Override
    protected void engineUpdate(byte[] bytes, int off, int len) throws SignatureException {
        this.digest.update(bytes, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        ASN1EncodableVector signatureSequence = new ASN1EncodableVector();
        try {
            byte[] digestResult = new byte[this.digest.getDigestSize()];
            this.digest.doFinal(digestResult, 0);
            for (int i = 0; i < this.componentSignatures.size(); ++i) {
                this.componentSignatures.get(i).update(this.OIDBytes);
                this.componentSignatures.get(i).update(digestResult);
                byte[] signatureValue = this.componentSignatures.get(i).sign();
                signatureSequence.add(new DERBitString(signatureValue));
            }
            return new DERSequence(signatureSequence).getEncoded("DER");
        }
        catch (IOException e) {
            throw new SignatureException(e.getMessage());
        }
    }

    @Override
    protected boolean engineVerify(byte[] signature) throws SignatureException {
        ASN1Sequence signatureSequence = DERSequence.getInstance(signature);
        if (signatureSequence.size() != this.componentSignatures.size()) {
            return false;
        }
        byte[] digestResult = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(digestResult, 0);
        boolean fail = false;
        for (int i = 0; i < this.componentSignatures.size(); ++i) {
            this.componentSignatures.get(i).update(this.OIDBytes);
            this.componentSignatures.get(i).update(digestResult);
            if (this.componentSignatures.get(i).verify(ASN1BitString.getInstance(signatureSequence.getObjectAt(i)).getOctets())) continue;
            fail = true;
        }
        return !fail;
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof CompositeAlgorithmSpec) {
            CompositeAlgorithmSpec compAlgSpec = (CompositeAlgorithmSpec)algorithmParameterSpec;
            List<AlgorithmParameterSpec> specs = compAlgSpec.getParameterSpecs();
            List<String> names = compAlgSpec.getAlgorithmNames();
            switch (this.algorithmIdentifier) {
                case MLDSA44_Ed25519_SHA512: {
                    this.setSigParameter(this.componentSignatures.get(0), ML_DSA_44, names, specs);
                    break;
                }
                case MLDSA65_Ed25519_SHA512: {
                    this.setSigParameter(this.componentSignatures.get(0), ML_DSA_65, names, specs);
                    break;
                }
                case MLDSA87_Ed448_SHA512: {
                    this.setSigParameter(this.componentSignatures.get(0), ML_DSA_87, names, specs);
                    break;
                }
                case MLDSA44_RSA2048_PSS_SHA256: {
                    this.setSigParameter(this.componentSignatures.get(0), ML_DSA_44, names, specs);
                    break;
                }
                case MLDSA65_RSA3072_PSS_SHA512: {
                    this.setSigParameter(this.componentSignatures.get(0), ML_DSA_65, names, specs);
                    break;
                }
                case MLDSA44_RSA2048_PKCS15_SHA256: {
                    this.setSigParameter(this.componentSignatures.get(0), ML_DSA_44, names, specs);
                    break;
                }
                case MLDSA65_RSA3072_PKCS15_SHA512: {
                    this.setSigParameter(this.componentSignatures.get(0), ML_DSA_65, names, specs);
                    break;
                }
                case MLDSA44_ECDSA_P256_SHA256: 
                case MLDSA44_ECDSA_brainpoolP256r1_SHA256: {
                    this.setSigParameter(this.componentSignatures.get(0), ML_DSA_44, names, specs);
                    break;
                }
                case MLDSA65_ECDSA_P256_SHA512: 
                case MLDSA65_ECDSA_brainpoolP256r1_SHA512: {
                    this.setSigParameter(this.componentSignatures.get(0), ML_DSA_65, names, specs);
                    break;
                }
                case MLDSA87_ECDSA_P384_SHA512: 
                case MLDSA87_ECDSA_brainpoolP384r1_SHA512: {
                    this.setSigParameter(this.componentSignatures.get(0), ML_DSA_87, names, specs);
                    break;
                }
                default: {
                    throw new InvalidAlgorithmParameterException("unknown composite algorithm");
                }
            }
        } else {
            throw new InvalidAlgorithmParameterException("unknown parameterSpec passed to composite signature");
        }
    }

    private void setSigParameter(Signature targetSig, String targetSigName, List<String> names, List<AlgorithmParameterSpec> specs) throws InvalidAlgorithmParameterException {
        for (int i = 0; i != names.size(); ++i) {
            String canonicalName = this.getCanonicalName(names.get(i));
            if (!names.get(i).equals(targetSigName)) continue;
            targetSig.setParameter(specs.get(i));
        }
    }

    private String getCanonicalName(String baseName) {
        String name = canonicalNames.get(baseName);
        if (name != null) {
            return name;
        }
        return baseName;
    }

    @Override
    protected void engineSetParameter(String s, Object o) throws InvalidParameterException {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String s) throws InvalidParameterException {
        throw new UnsupportedOperationException("engineGetParameter unsupported");
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    static {
        canonicalNames.put("MLDSA44", ML_DSA_44);
        canonicalNames.put("MLDSA65", ML_DSA_65);
        canonicalNames.put("MLDSA87", ML_DSA_87);
        canonicalNames.put(NISTObjectIdentifiers.id_ml_dsa_44.getId(), ML_DSA_44);
        canonicalNames.put(NISTObjectIdentifiers.id_ml_dsa_65.getId(), ML_DSA_65);
        canonicalNames.put(NISTObjectIdentifiers.id_ml_dsa_87.getId(), ML_DSA_87);
    }

    public static final class Falcon512_ECDSA_P256_SHA256
    extends SignatureSpi {
        public Falcon512_ECDSA_P256_SHA256() {
            super(CompositeSignaturesConstants.CompositeName.Falcon512_ECDSA_P256_SHA256);
        }
    }

    public static final class Falcon512_ECDSA_brainpoolP256r1_SHA256
    extends SignatureSpi {
        public Falcon512_ECDSA_brainpoolP256r1_SHA256() {
            super(CompositeSignaturesConstants.CompositeName.Falcon512_ECDSA_brainpoolP256r1_SHA256);
        }
    }

    public static final class Falcon512_Ed25519_SHA512
    extends SignatureSpi {
        public Falcon512_Ed25519_SHA512() {
            super(CompositeSignaturesConstants.CompositeName.Falcon512_Ed25519_SHA512);
        }
    }

    public static final class MLDSA44_ECDSA_P256_SHA256
    extends SignatureSpi {
        public MLDSA44_ECDSA_P256_SHA256() {
            super(CompositeSignaturesConstants.CompositeName.MLDSA44_ECDSA_P256_SHA256);
        }
    }

    public static final class MLDSA44_ECDSA_brainpoolP256r1_SHA256
    extends SignatureSpi {
        public MLDSA44_ECDSA_brainpoolP256r1_SHA256() {
            super(CompositeSignaturesConstants.CompositeName.MLDSA44_ECDSA_brainpoolP256r1_SHA256);
        }
    }

    public static final class MLDSA44_Ed25519_SHA512
    extends SignatureSpi {
        public MLDSA44_Ed25519_SHA512() {
            super(CompositeSignaturesConstants.CompositeName.MLDSA44_Ed25519_SHA512);
        }
    }

    public static final class MLDSA44_RSA2048_PKCS15_SHA256
    extends SignatureSpi {
        public MLDSA44_RSA2048_PKCS15_SHA256() {
            super(CompositeSignaturesConstants.CompositeName.MLDSA44_RSA2048_PKCS15_SHA256);
        }
    }

    public static final class MLDSA44_RSA2048_PSS_SHA256
    extends SignatureSpi {
        public MLDSA44_RSA2048_PSS_SHA256() {
            super(CompositeSignaturesConstants.CompositeName.MLDSA44_RSA2048_PSS_SHA256);
        }
    }

    public static final class MLDSA65_ECDSA_P256_SHA512
    extends SignatureSpi {
        public MLDSA65_ECDSA_P256_SHA512() {
            super(CompositeSignaturesConstants.CompositeName.MLDSA65_ECDSA_P256_SHA512);
        }
    }

    public static final class MLDSA65_ECDSA_brainpoolP256r1_SHA512
    extends SignatureSpi {
        public MLDSA65_ECDSA_brainpoolP256r1_SHA512() {
            super(CompositeSignaturesConstants.CompositeName.MLDSA65_ECDSA_brainpoolP256r1_SHA512);
        }
    }

    public static final class MLDSA65_Ed25519_SHA512
    extends SignatureSpi {
        public MLDSA65_Ed25519_SHA512() {
            super(CompositeSignaturesConstants.CompositeName.MLDSA65_Ed25519_SHA512);
        }
    }

    public static final class MLDSA65_RSA3072_PKCS15_SHA512
    extends SignatureSpi {
        public MLDSA65_RSA3072_PKCS15_SHA512() {
            super(CompositeSignaturesConstants.CompositeName.MLDSA65_RSA3072_PKCS15_SHA512);
        }
    }

    public static final class MLDSA65_RSA3072_PSS_SHA512
    extends SignatureSpi {
        public MLDSA65_RSA3072_PSS_SHA512() {
            super(CompositeSignaturesConstants.CompositeName.MLDSA65_RSA3072_PSS_SHA512);
        }
    }

    public static final class MLDSA87_ECDSA_P384_SHA512
    extends SignatureSpi {
        public MLDSA87_ECDSA_P384_SHA512() {
            super(CompositeSignaturesConstants.CompositeName.MLDSA87_ECDSA_P384_SHA512);
        }
    }

    public static final class MLDSA87_ECDSA_brainpoolP384r1_SHA512
    extends SignatureSpi {
        public MLDSA87_ECDSA_brainpoolP384r1_SHA512() {
            super(CompositeSignaturesConstants.CompositeName.MLDSA87_ECDSA_brainpoolP384r1_SHA512);
        }
    }

    public static final class MLDSA87_Ed448_SHA512
    extends SignatureSpi {
        public MLDSA87_Ed448_SHA512() {
            super(CompositeSignaturesConstants.CompositeName.MLDSA87_Ed448_SHA512);
        }
    }
}

