/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.crystals.kyber;

import java.security.SecureRandom;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberIndCpa;
import org.bouncycastle.pqc.crypto.crystals.kyber.Symmetric;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class KyberEngine {
    private SecureRandom random;
    private KyberIndCpa indCpa;
    public static final int KyberN = 256;
    public static final int KyberQ = 3329;
    public static final int KyberQinv = 62209;
    public static final int KyberSymBytes = 32;
    private static final int KyberSharedSecretBytes = 32;
    public static final int KyberPolyBytes = 384;
    private static final int KyberEta2 = 2;
    private static final int KyberIndCpaMsgBytes = 32;
    private final int KyberK;
    private final int KyberPolyVecBytes;
    private final int KyberPolyCompressedBytes;
    private final int KyberPolyVecCompressedBytes;
    private final int KyberEta1;
    private final int KyberIndCpaPublicKeyBytes;
    private final int KyberIndCpaSecretKeyBytes;
    private final int KyberIndCpaBytes;
    private final int KyberPublicKeyBytes;
    private final int KyberSecretKeyBytes;
    private final int KyberCipherTextBytes;
    private final int CryptoBytes;
    private final int CryptoSecretKeyBytes;
    private final int CryptoPublicKeyBytes;
    private final int CryptoCipherTextBytes;
    private final int sessionKeyLength;
    private final Symmetric symmetric;

    public Symmetric getSymmetric() {
        return this.symmetric;
    }

    public static int getKyberEta2() {
        return 2;
    }

    public static int getKyberIndCpaMsgBytes() {
        return 32;
    }

    public int getCryptoCipherTextBytes() {
        return this.CryptoCipherTextBytes;
    }

    public int getCryptoPublicKeyBytes() {
        return this.CryptoPublicKeyBytes;
    }

    public int getCryptoSecretKeyBytes() {
        return this.CryptoSecretKeyBytes;
    }

    public int getCryptoBytes() {
        return this.CryptoBytes;
    }

    public int getKyberCipherTextBytes() {
        return this.KyberCipherTextBytes;
    }

    public int getKyberSecretKeyBytes() {
        return this.KyberSecretKeyBytes;
    }

    public int getKyberIndCpaPublicKeyBytes() {
        return this.KyberIndCpaPublicKeyBytes;
    }

    public int getKyberIndCpaSecretKeyBytes() {
        return this.KyberIndCpaSecretKeyBytes;
    }

    public int getKyberIndCpaBytes() {
        return this.KyberIndCpaBytes;
    }

    public int getKyberPublicKeyBytes() {
        return this.KyberPublicKeyBytes;
    }

    public int getKyberPolyCompressedBytes() {
        return this.KyberPolyCompressedBytes;
    }

    public int getKyberK() {
        return this.KyberK;
    }

    public int getKyberPolyVecBytes() {
        return this.KyberPolyVecBytes;
    }

    public int getKyberPolyVecCompressedBytes() {
        return this.KyberPolyVecCompressedBytes;
    }

    public int getKyberEta1() {
        return this.KyberEta1;
    }

    public KyberEngine(int k, boolean usingAes) {
        this.KyberK = k;
        switch (k) {
            case 2: {
                this.KyberEta1 = 3;
                this.KyberPolyCompressedBytes = 128;
                this.KyberPolyVecCompressedBytes = k * 320;
                this.sessionKeyLength = 32;
                break;
            }
            case 3: {
                this.KyberEta1 = 2;
                this.KyberPolyCompressedBytes = 128;
                this.KyberPolyVecCompressedBytes = k * 320;
                this.sessionKeyLength = 32;
                break;
            }
            case 4: {
                this.KyberEta1 = 2;
                this.KyberPolyCompressedBytes = 160;
                this.KyberPolyVecCompressedBytes = k * 352;
                this.sessionKeyLength = 32;
                break;
            }
            default: {
                throw new IllegalArgumentException("K: " + k + " is not supported for Crystals Kyber");
            }
        }
        this.KyberPolyVecBytes = k * 384;
        this.KyberIndCpaPublicKeyBytes = this.KyberPolyVecBytes + 32;
        this.KyberIndCpaSecretKeyBytes = this.KyberPolyVecBytes;
        this.KyberIndCpaBytes = this.KyberPolyVecCompressedBytes + this.KyberPolyCompressedBytes;
        this.KyberPublicKeyBytes = this.KyberIndCpaPublicKeyBytes;
        this.KyberSecretKeyBytes = this.KyberIndCpaSecretKeyBytes + this.KyberIndCpaPublicKeyBytes + 64;
        this.KyberCipherTextBytes = this.KyberIndCpaBytes;
        this.CryptoBytes = 32;
        this.CryptoSecretKeyBytes = this.KyberSecretKeyBytes;
        this.CryptoPublicKeyBytes = this.KyberPublicKeyBytes;
        this.CryptoCipherTextBytes = this.KyberCipherTextBytes;
        this.symmetric = usingAes ? new Symmetric.AesSymmetric() : new Symmetric.ShakeSymmetric();
        this.indCpa = new KyberIndCpa(this);
    }

    public void init(SecureRandom random) {
        this.random = random;
    }

    public byte[][] generateKemKeyPair() {
        byte[][] indCpaKeyPair = this.indCpa.generateKeyPair();
        byte[] s = new byte[this.KyberIndCpaSecretKeyBytes];
        System.arraycopy(indCpaKeyPair[1], 0, s, 0, this.KyberIndCpaSecretKeyBytes);
        byte[] hashedPublicKey = new byte[32];
        this.symmetric.hash_h(hashedPublicKey, indCpaKeyPair[0], 0);
        byte[] z = new byte[32];
        this.random.nextBytes(z);
        byte[] outputPublicKey = new byte[this.KyberIndCpaPublicKeyBytes];
        System.arraycopy(indCpaKeyPair[0], 0, outputPublicKey, 0, this.KyberIndCpaPublicKeyBytes);
        return new byte[][]{Arrays.copyOfRange(outputPublicKey, 0, outputPublicKey.length - 32), Arrays.copyOfRange(outputPublicKey, outputPublicKey.length - 32, outputPublicKey.length), s, hashedPublicKey, z};
    }

    public byte[][] kemEncrypt(byte[] publicKeyInput) {
        byte[] buf = new byte[64];
        byte[] kr = new byte[64];
        byte[] randBytes = new byte[32];
        this.random.nextBytes(randBytes);
        System.arraycopy(randBytes, 0, buf, 0, 32);
        this.symmetric.hash_h(buf, publicKeyInput, 32);
        this.symmetric.hash_g(kr, buf);
        byte[] outputCipherText = this.indCpa.encrypt(Arrays.copyOfRange(buf, 0, 32), publicKeyInput, Arrays.copyOfRange(kr, 32, kr.length));
        byte[] outputSharedSecret = new byte[this.sessionKeyLength];
        System.arraycopy(kr, 0, outputSharedSecret, 0, outputSharedSecret.length);
        byte[][] outBuf = new byte[][]{outputSharedSecret, outputCipherText};
        return outBuf;
    }

    public byte[] kemDecrypt(byte[] cipherText, byte[] secretKey) {
        byte[] buf = new byte[64];
        byte[] kr = new byte[64];
        byte[] publicKey = Arrays.copyOfRange(secretKey, this.KyberIndCpaSecretKeyBytes, secretKey.length);
        System.arraycopy(this.indCpa.decrypt(cipherText, secretKey), 0, buf, 0, 32);
        System.arraycopy(secretKey, this.KyberSecretKeyBytes - 64, buf, 32, 32);
        this.symmetric.hash_g(kr, buf);
        byte[] cmp = this.indCpa.encrypt(Arrays.copyOfRange(buf, 0, 32), publicKey, Arrays.copyOfRange(kr, 32, kr.length));
        boolean fail = !Arrays.constantTimeAreEqual(cipherText, cmp);
        this.symmetric.hash_h(kr, cipherText, 32);
        this.cmov(kr, Arrays.copyOfRange(secretKey, this.KyberSecretKeyBytes - 32, this.KyberSecretKeyBytes), 32, fail);
        return Arrays.copyOfRange(kr, 0, this.sessionKeyLength);
    }

    private void cmov(byte[] r, byte[] x, int xlen, boolean b) {
        if (b) {
            System.arraycopy(x, 0, r, 0, xlen);
        } else {
            System.arraycopy(r, 0, r, 0, xlen);
        }
    }

    public void getRandomBytes(byte[] buf) {
        this.random.nextBytes(buf);
    }
}

