/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.falcon;

import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.falcon.FalconParameters;
import org.bouncycastle.pqc.crypto.falcon.FalconPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.falcon.FalconSigner;
import org.bouncycastle.pqc.jcajce.provider.falcon.BCFalconPrivateKey;
import org.bouncycastle.pqc.jcajce.provider.falcon.BCFalconPublicKey;
import org.bouncycastle.util.Strings;

public class SignatureSpi
extends Signature {
    private ByteArrayOutputStream bOut;
    private FalconSigner signer;
    private SecureRandom random;
    private FalconParameters parameters;

    protected SignatureSpi(FalconSigner signer) {
        super("FALCON");
        this.bOut = new ByteArrayOutputStream();
        this.signer = signer;
        this.parameters = null;
    }

    protected SignatureSpi(FalconSigner signer, FalconParameters parameters) {
        super(Strings.toUpperCase(parameters.getName()));
        this.parameters = parameters;
        this.bOut = new ByteArrayOutputStream();
        this.signer = signer;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        String canonicalAlg;
        if (!(publicKey instanceof BCFalconPublicKey)) {
            try {
                publicKey = new BCFalconPublicKey(SubjectPublicKeyInfo.getInstance(publicKey.getEncoded()));
            }
            catch (Exception e) {
                throw new InvalidKeyException("unknown public key passed to Falcon: " + e.getMessage(), e);
            }
        }
        BCFalconPublicKey key = (BCFalconPublicKey)publicKey;
        if (this.parameters != null && !(canonicalAlg = Strings.toUpperCase(this.parameters.getName())).equals(key.getAlgorithm())) {
            throw new InvalidKeyException("signature configured for " + canonicalAlg);
        }
        this.signer.init(false, key.getKeyParams());
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.random = random;
        this.engineInitSign(privateKey);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof BCFalconPrivateKey) {
            String canonicalAlg;
            BCFalconPrivateKey key = (BCFalconPrivateKey)privateKey;
            FalconPrivateKeyParameters param = key.getKeyParams();
            if (this.parameters != null && !(canonicalAlg = Strings.toUpperCase(this.parameters.getName())).equals(key.getAlgorithm())) {
                throw new InvalidKeyException("signature configured for " + canonicalAlg);
            }
            if (this.random != null) {
                this.signer.init(true, new ParametersWithRandom(param, this.random));
            } else {
                this.signer.init(true, param);
            }
        } else {
            throw new InvalidKeyException("unknown private key passed to Falcon");
        }
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.bOut.write(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.bOut.write(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] message = this.bOut.toByteArray();
            this.bOut.reset();
            return this.signer.generateSignature(message);
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        byte[] message = this.bOut.toByteArray();
        this.bOut.reset();
        return this.signer.verifySignature(message, sigBytes);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class Base
    extends SignatureSpi {
        public Base() {
            super(new FalconSigner());
        }
    }

    public static class Falcon1024
    extends SignatureSpi {
        public Falcon1024() {
            super(new FalconSigner(), FalconParameters.falcon_1024);
        }
    }

    public static class Falcon512
    extends SignatureSpi {
        public Falcon512() {
            super(new FalconSigner(), FalconParameters.falcon_512);
        }
    }
}

