/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.ntruprime;

import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimePrivateKeyParameters;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimePublicKeyParameters;
import org.bouncycastle.pqc.crypto.ntruprime.Utils;
import org.bouncycastle.util.Arrays;

public class SNTRUPrimeKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SNTRUPrimeKeyGenerationParameters params;

    public SNTRUPrimeKeyGenerationParameters getParams() {
        return this.params;
    }

    @Override
    public void init(KeyGenerationParameters param) {
        this.params = (SNTRUPrimeKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        int p = this.params.getSntrupParams().getP();
        int q = this.params.getSntrupParams().getQ();
        int w = this.params.getSntrupParams().getW();
        byte[] g = new byte[p];
        byte[] ginv = new byte[p];
        do {
            Utils.getRandomSmallPolynomial(this.params.getRandom(), g);
        } while (!Utils.isInvertiblePolynomialInR3(g, ginv, p));
        byte[] f = new byte[p];
        Utils.getRandomShortPolynomial(this.params.getRandom(), f, p, w);
        short[] finv3 = new short[p];
        Utils.getOneThirdInverseInRQ(finv3, f, p, q);
        short[] h = new short[p];
        Utils.multiplicationInRQ(h, finv3, g, p, q);
        byte[] pk = new byte[this.params.getSntrupParams().getPublicKeyBytes()];
        Utils.getEncodedPolynomial(pk, h, p, q);
        SNTRUPrimePublicKeyParameters publicKey = new SNTRUPrimePublicKeyParameters(this.params.getSntrupParams(), pk);
        byte[] encF = new byte[(p + 3) / 4];
        Utils.getEncodedSmallPolynomial(encF, f, p);
        byte[] encGinv = new byte[(p + 3) / 4];
        Utils.getEncodedSmallPolynomial(encGinv, ginv, p);
        byte[] rho = new byte[(p + 3) / 4];
        this.params.getRandom().nextBytes(rho);
        byte[] prefix = new byte[]{4};
        byte[] hash = Utils.getHashWithPrefix(prefix, pk);
        SNTRUPrimePrivateKeyParameters privateKey = new SNTRUPrimePrivateKeyParameters(this.params.getSntrupParams(), encF, encGinv, pk, rho, Arrays.copyOfRange(hash, 0, hash.length / 2));
        return new AsymmetricCipherKeyPair(publicKey, privateKey);
    }
}

