/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.asn1;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SPHINCSPLUSPublicKey
extends ASN1Object {
    private byte[] pkseed;
    private byte[] pkroot;

    public SPHINCSPLUSPublicKey(byte[] pkseed, byte[] pkroot) {
        this.pkseed = pkseed;
        this.pkroot = pkroot;
    }

    public SPHINCSPLUSPublicKey(ASN1Sequence seq) {
        this.pkseed = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(0)).getOctets());
        this.pkroot = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(1)).getOctets());
    }

    public byte[] getPkseed() {
        return Arrays.clone(this.pkseed);
    }

    public byte[] getPkroot() {
        return Arrays.clone(this.pkroot);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new DEROctetString(this.pkseed));
        v.add(new DEROctetString(this.pkroot));
        return new DERSequence(v);
    }

    public static SPHINCSPLUSPublicKey getInstance(Object o) {
        if (o instanceof SPHINCSPLUSPublicKey) {
            return (SPHINCSPLUSPublicKey)o;
        }
        if (o != null) {
            return new SPHINCSPLUSPublicKey(ASN1Sequence.getInstance(o));
        }
        return null;
    }
}

