/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.asn1;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.pqc.asn1.KyberPublicKey;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class KyberPrivateKey
extends ASN1Object {
    private int version;
    private byte[] s;
    private KyberPublicKey publicKey;
    private byte[] hpk;
    private byte[] nonce;

    public KyberPrivateKey(int version, byte[] s, byte[] hpk, byte[] nonce, KyberPublicKey publicKey) {
        this.version = version;
        this.s = s;
        this.publicKey = publicKey;
        this.hpk = hpk;
        this.nonce = nonce;
    }

    public KyberPrivateKey(int version, byte[] s, byte[] hpk, byte[] nonce) {
        this(version, s, hpk, nonce, null);
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] getS() {
        return Arrays.clone(this.s);
    }

    public KyberPublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] getHpk() {
        return Arrays.clone(this.hpk);
    }

    public byte[] getNonce() {
        return Arrays.clone(this.nonce);
    }

    private KyberPrivateKey(ASN1Sequence seq) {
        this.version = ASN1Integer.getInstance(seq.getObjectAt(0)).intValueExact();
        if (this.version != 0) {
            throw new IllegalArgumentException("unrecognized version");
        }
        this.s = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(1)).getOctets());
        int skipPubKey = 1;
        if (seq.size() == 5) {
            skipPubKey = 0;
            this.publicKey = KyberPublicKey.getInstance(seq.getObjectAt(2));
        }
        this.hpk = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(3 - skipPubKey)).getOctets());
        this.nonce = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(4 - skipPubKey)).getOctets());
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(this.version));
        v.add(new DEROctetString(this.s));
        if (this.publicKey != null) {
            v.add(new KyberPublicKey(this.publicKey.getT(), this.publicKey.getRho()));
        }
        v.add(new DEROctetString(this.hpk));
        v.add(new DEROctetString(this.nonce));
        return new DERSequence(v);
    }

    public static KyberPrivateKey getInstance(Object o) {
        if (o instanceof KyberPrivateKey) {
            return (KyberPrivateKey)o;
        }
        if (o != null) {
            return new KyberPrivateKey(ASN1Sequence.getInstance(o));
        }
        return null;
    }
}

