/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.bouncycastle.crypto.digests.SparkleDigest;
import org.bouncycastle.crypto.engines.Utils;
import org.bouncycastle.crypto.modes.AEADCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Pack;

public class SparkleEngine
implements AEADCipher {
    private static final int[] RCON = new int[]{-1209970334, -1083090816, 951376470, 844003128, -1156479509, 1333558103, -809524792, -1028445891};
    private String algorithmName;
    private final int[] state;
    private final int[] k;
    private final int[] npub;
    private byte[] tag;
    private boolean encrypted;
    private State m_state = State.Uninitialized;
    private byte[] initialAssociatedText;
    private final int m_bufferSizeDecrypt;
    private final byte[] m_buf;
    private int m_bufPos = 0;
    private final int SCHWAEMM_KEY_LEN;
    private final int SCHWAEMM_NONCE_LEN;
    private final int SPARKLE_STEPS_SLIM;
    private final int SPARKLE_STEPS_BIG;
    private final int KEY_WORDS;
    private final int KEY_BYTES;
    private final int TAG_WORDS;
    private final int TAG_BYTES;
    private final int STATE_WORDS;
    private final int RATE_WORDS;
    private final int RATE_BYTES;
    private final int CAP_MASK;
    private final int _A0;
    private final int _A1;
    private final int _M2;
    private final int _M3;

    public SparkleEngine(SparkleParameters sparkleParameters) {
        int SPARKLE_CAPACITY;
        int SPARKLE_STATE;
        int SCHWAEMM_TAG_LEN;
        switch (sparkleParameters) {
            case SCHWAEMM128_128: {
                this.SCHWAEMM_KEY_LEN = 128;
                this.SCHWAEMM_NONCE_LEN = 128;
                SCHWAEMM_TAG_LEN = 128;
                SPARKLE_STATE = 256;
                SPARKLE_CAPACITY = 128;
                this.SPARKLE_STEPS_SLIM = 7;
                this.SPARKLE_STEPS_BIG = 10;
                this.algorithmName = "SCHWAEMM128-128";
                break;
            }
            case SCHWAEMM256_128: {
                this.SCHWAEMM_KEY_LEN = 128;
                this.SCHWAEMM_NONCE_LEN = 256;
                SCHWAEMM_TAG_LEN = 128;
                SPARKLE_STATE = 384;
                SPARKLE_CAPACITY = 128;
                this.SPARKLE_STEPS_SLIM = 7;
                this.SPARKLE_STEPS_BIG = 11;
                this.algorithmName = "SCHWAEMM256-128";
                break;
            }
            case SCHWAEMM192_192: {
                this.SCHWAEMM_KEY_LEN = 192;
                this.SCHWAEMM_NONCE_LEN = 192;
                SCHWAEMM_TAG_LEN = 192;
                SPARKLE_STATE = 384;
                SPARKLE_CAPACITY = 192;
                this.SPARKLE_STEPS_SLIM = 7;
                this.SPARKLE_STEPS_BIG = 11;
                this.algorithmName = "SCHWAEMM192-192";
                break;
            }
            case SCHWAEMM256_256: {
                this.SCHWAEMM_KEY_LEN = 256;
                this.SCHWAEMM_NONCE_LEN = 256;
                SCHWAEMM_TAG_LEN = 256;
                SPARKLE_STATE = 512;
                SPARKLE_CAPACITY = 256;
                this.SPARKLE_STEPS_SLIM = 8;
                this.SPARKLE_STEPS_BIG = 12;
                this.algorithmName = "SCHWAEMM256-256";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid definition of SCHWAEMM instance");
            }
        }
        this.KEY_WORDS = this.SCHWAEMM_KEY_LEN >>> 5;
        this.KEY_BYTES = this.SCHWAEMM_KEY_LEN >>> 3;
        this.TAG_WORDS = SCHWAEMM_TAG_LEN >>> 5;
        this.TAG_BYTES = SCHWAEMM_TAG_LEN >>> 3;
        this.STATE_WORDS = SPARKLE_STATE >>> 5;
        this.RATE_WORDS = this.SCHWAEMM_NONCE_LEN >>> 5;
        this.RATE_BYTES = this.SCHWAEMM_NONCE_LEN >>> 3;
        int CAP_BRANS = SPARKLE_CAPACITY >>> 6;
        int CAP_WORDS = SPARKLE_CAPACITY >>> 5;
        this.CAP_MASK = this.RATE_WORDS > CAP_WORDS ? CAP_WORDS - 1 : -1;
        this._A0 = 1 << CAP_BRANS << 24;
        this._A1 = (1 ^ 1 << CAP_BRANS) << 24;
        this._M2 = (2 ^ 1 << CAP_BRANS) << 24;
        this._M3 = (3 ^ 1 << CAP_BRANS) << 24;
        this.state = new int[this.STATE_WORDS];
        this.k = new int[this.KEY_WORDS];
        this.npub = new int[this.RATE_WORDS];
        this.m_bufferSizeDecrypt = this.RATE_BYTES + this.TAG_BYTES;
        this.m_buf = new byte[this.m_bufferSizeDecrypt];
    }

    public int getKeyBytesSize() {
        return this.KEY_BYTES;
    }

    public int getIVBytesSize() {
        return this.RATE_BYTES;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        byte[] iv;
        KeyParameter key = null;
        if (params instanceof AEADParameters) {
            AEADParameters aeadParameters = (AEADParameters)params;
            key = aeadParameters.getKey();
            iv = aeadParameters.getNonce();
            this.initialAssociatedText = aeadParameters.getAssociatedText();
            int macSizeBits = aeadParameters.getMacSize();
            if (macSizeBits != this.TAG_BYTES * 8) {
                throw new IllegalArgumentException("Invalid value for MAC size: " + macSizeBits);
            }
        } else if (params instanceof ParametersWithIV) {
            ParametersWithIV withIV = (ParametersWithIV)params;
            CipherParameters ivParameters = withIV.getParameters();
            if (ivParameters instanceof KeyParameter) {
                key = (KeyParameter)ivParameters;
            }
            iv = withIV.getIV();
            this.initialAssociatedText = null;
        } else {
            throw new IllegalArgumentException("invalid parameters passed to Sparkle");
        }
        if (key == null) {
            throw new IllegalArgumentException("Sparkle init parameters must include a key");
        }
        int expectedKeyLength = this.KEY_WORDS * 4;
        if (expectedKeyLength != key.getKeyLength()) {
            throw new IllegalArgumentException(this.algorithmName + " requires exactly " + expectedKeyLength + " bytes of key");
        }
        int expectedIVLength = this.RATE_WORDS * 4;
        if (iv == null || expectedIVLength != iv.length) {
            throw new IllegalArgumentException(this.algorithmName + " requires exactly " + expectedIVLength + " bytes of IV");
        }
        Pack.littleEndianToInt(key.getKey(), 0, this.k);
        Pack.littleEndianToInt(iv, 0, this.npub);
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 128, params, Utils.getPurpose(forEncryption)));
        this.m_state = forEncryption ? State.EncInit : State.DecInit;
        this.reset();
    }

    @Override
    public void processAADByte(byte in) {
        this.checkAAD();
        if (this.m_bufPos == this.RATE_BYTES) {
            this.processBufferAAD(this.m_buf, 0);
            this.m_bufPos = 0;
        }
        this.m_buf[this.m_bufPos++] = in;
    }

    @Override
    public void processAADBytes(byte[] in, int inOff, int len) {
        if (inOff > in.length - len) {
            throw new DataLengthException("input buffer too short");
        }
        if (len <= 0) {
            return;
        }
        this.checkAAD();
        if (this.m_bufPos > 0) {
            int available = this.RATE_BYTES - this.m_bufPos;
            if (len <= available) {
                System.arraycopy(in, inOff, this.m_buf, this.m_bufPos, len);
                this.m_bufPos += len;
                return;
            }
            System.arraycopy(in, inOff, this.m_buf, this.m_bufPos, available);
            inOff += available;
            len -= available;
            this.processBufferAAD(this.m_buf, 0);
        }
        while (len > this.RATE_BYTES) {
            this.processBufferAAD(in, inOff);
            inOff += this.RATE_BYTES;
            len -= this.RATE_BYTES;
        }
        System.arraycopy(in, inOff, this.m_buf, 0, len);
        this.m_bufPos = len;
    }

    @Override
    public int processByte(byte in, byte[] out, int outOff) throws DataLengthException {
        return this.processBytes(new byte[]{in}, 0, 1, out, outOff);
    }

    @Override
    public int processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException {
        if (inOff > in.length - len) {
            throw new DataLengthException("input buffer too short");
        }
        boolean forEncryption = this.checkData();
        int resultLength = 0;
        if (forEncryption) {
            if (this.m_bufPos > 0) {
                int available = this.RATE_BYTES - this.m_bufPos;
                if (len <= available) {
                    System.arraycopy(in, inOff, this.m_buf, this.m_bufPos, len);
                    this.m_bufPos += len;
                    return 0;
                }
                System.arraycopy(in, inOff, this.m_buf, this.m_bufPos, available);
                inOff += available;
                len -= available;
                this.processBufferEncrypt(this.m_buf, 0, out, outOff);
                resultLength = this.RATE_BYTES;
            }
            while (len > this.RATE_BYTES) {
                this.processBufferEncrypt(in, inOff, out, outOff + resultLength);
                inOff += this.RATE_BYTES;
                len -= this.RATE_BYTES;
                resultLength += this.RATE_BYTES;
            }
        } else {
            int available = this.m_bufferSizeDecrypt - this.m_bufPos;
            if (len <= available) {
                System.arraycopy(in, inOff, this.m_buf, this.m_bufPos, len);
                this.m_bufPos += len;
                return 0;
            }
            if (this.m_bufPos > this.RATE_BYTES) {
                this.processBufferDecrypt(this.m_buf, 0, out, outOff);
                this.m_bufPos -= this.RATE_BYTES;
                System.arraycopy(this.m_buf, this.RATE_BYTES, this.m_buf, 0, this.m_bufPos);
                resultLength = this.RATE_BYTES;
                if (len <= (available += this.RATE_BYTES)) {
                    System.arraycopy(in, inOff, this.m_buf, this.m_bufPos, len);
                    this.m_bufPos += len;
                    return resultLength;
                }
            }
            available = this.RATE_BYTES - this.m_bufPos;
            System.arraycopy(in, inOff, this.m_buf, this.m_bufPos, available);
            inOff += available;
            len -= available;
            this.processBufferDecrypt(this.m_buf, 0, out, outOff + resultLength);
            resultLength += this.RATE_BYTES;
            while (len > this.m_bufferSizeDecrypt) {
                this.processBufferDecrypt(in, inOff, out, outOff + resultLength);
                inOff += this.RATE_BYTES;
                len -= this.RATE_BYTES;
                resultLength += this.RATE_BYTES;
            }
        }
        System.arraycopy(in, inOff, this.m_buf, 0, len);
        this.m_bufPos = len;
        return resultLength;
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws IllegalStateException, InvalidCipherTextException {
        int resultLength;
        boolean forEncryption = this.checkData();
        if (forEncryption) {
            resultLength = this.m_bufPos + this.TAG_BYTES;
        } else {
            if (this.m_bufPos < this.TAG_BYTES) {
                throw new InvalidCipherTextException("data too short");
            }
            this.m_bufPos -= this.TAG_BYTES;
            resultLength = this.m_bufPos;
        }
        if (outOff > out.length - resultLength) {
            throw new OutputLengthException("output buffer too short");
        }
        if (this.encrypted || this.m_bufPos > 0) {
            int i;
            int n = this.STATE_WORDS - 1;
            this.state[n] = this.state[n] ^ (this.m_bufPos < this.RATE_BYTES ? this._M2 : this._M3);
            int[] buffer = new int[this.RATE_WORDS];
            for (i = 0; i < this.m_bufPos; ++i) {
                int n2 = i >>> 2;
                buffer[n2] = buffer[n2] | (this.m_buf[i] & 0xFF) << ((i & 3) << 3);
            }
            if (this.m_bufPos < this.RATE_BYTES) {
                if (!forEncryption) {
                    int tmp = (this.m_bufPos & 3) << 3;
                    int n3 = this.m_bufPos >>> 2;
                    buffer[n3] = buffer[n3] | this.state[this.m_bufPos >>> 2] >>> tmp << tmp;
                    tmp = (this.m_bufPos >>> 2) + 1;
                    System.arraycopy(this.state, tmp, buffer, tmp, this.RATE_WORDS - tmp);
                }
                int n4 = this.m_bufPos >>> 2;
                buffer[n4] = buffer[n4] ^ 128 << ((this.m_bufPos & 3) << 3);
            }
            i = 0;
            while (i < this.RATE_WORDS / 2) {
                int j = i + this.RATE_WORDS / 2;
                int s_i = this.state[i];
                int s_j = this.state[j];
                if (forEncryption) {
                    this.state[i] = s_j ^ buffer[i] ^ this.state[this.RATE_WORDS + i];
                    this.state[j] = s_i ^ s_j ^ buffer[j] ^ this.state[this.RATE_WORDS + (j & this.CAP_MASK)];
                } else {
                    this.state[i] = s_i ^ s_j ^ buffer[i] ^ this.state[this.RATE_WORDS + i];
                    this.state[j] = s_i ^ buffer[j] ^ this.state[this.RATE_WORDS + (j & this.CAP_MASK)];
                }
                int n5 = i++;
                buffer[n5] = buffer[n5] ^ s_i;
                int n6 = j;
                buffer[n6] = buffer[n6] ^ s_j;
            }
            for (i = 0; i < this.m_bufPos; ++i) {
                out[outOff++] = (byte)(buffer[i >>> 2] >>> ((i & 3) << 3));
            }
            SparkleEngine.sparkle_opt(this.state, this.SPARKLE_STEPS_BIG);
        }
        for (int i = 0; i < this.KEY_WORDS; ++i) {
            int n = this.RATE_WORDS + i;
            this.state[n] = this.state[n] ^ this.k[i];
        }
        this.tag = new byte[this.TAG_BYTES];
        Pack.intToLittleEndian(this.state, this.RATE_WORDS, this.TAG_WORDS, this.tag, 0);
        if (forEncryption) {
            System.arraycopy(this.tag, 0, out, outOff, this.TAG_BYTES);
        } else if (!Arrays.constantTimeAreEqual(this.TAG_BYTES, this.tag, 0, this.m_buf, this.m_bufPos)) {
            throw new InvalidCipherTextException(this.algorithmName + " mac does not match");
        }
        this.reset(!forEncryption);
        return resultLength;
    }

    @Override
    public byte[] getMac() {
        return this.tag;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        int total = Math.max(0, len) - 1;
        switch (this.m_state) {
            case DecInit: 
            case DecAad: {
                total = Math.max(0, total - this.TAG_BYTES);
                break;
            }
            case DecData: 
            case DecFinal: {
                total = Math.max(0, total + this.m_bufPos - this.TAG_BYTES);
                break;
            }
            case EncData: 
            case EncFinal: {
                total = Math.max(0, total + this.m_bufPos);
                break;
            }
        }
        return total - total % this.RATE_BYTES;
    }

    @Override
    public int getOutputSize(int len) {
        int total = Math.max(0, len);
        switch (this.m_state) {
            case DecInit: 
            case DecAad: {
                return Math.max(0, total - this.TAG_BYTES);
            }
            case DecData: 
            case DecFinal: {
                return Math.max(0, total + this.m_bufPos - this.TAG_BYTES);
            }
            case EncData: 
            case EncFinal: {
                return total + this.m_bufPos + this.TAG_BYTES;
            }
        }
        return total + this.TAG_BYTES;
    }

    @Override
    public void reset() {
        this.reset(true);
    }

    private void checkAAD() {
        switch (this.m_state) {
            case DecInit: {
                this.m_state = State.DecAad;
                break;
            }
            case EncInit: {
                this.m_state = State.EncAad;
                break;
            }
            case DecAad: 
            case EncAad: {
                break;
            }
            case EncFinal: {
                throw new IllegalStateException(this.getAlgorithmName() + " cannot be reused for encryption");
            }
            default: {
                throw new IllegalStateException(this.getAlgorithmName() + " needs to be initialized");
            }
        }
    }

    private boolean checkData() {
        switch (this.m_state) {
            case DecInit: 
            case DecAad: {
                this.finishAAD(State.DecData);
                return false;
            }
            case EncInit: 
            case EncAad: {
                this.finishAAD(State.EncData);
                return true;
            }
            case DecData: {
                return false;
            }
            case EncData: {
                return true;
            }
            case EncFinal: {
                throw new IllegalStateException(this.getAlgorithmName() + " cannot be reused for encryption");
            }
        }
        throw new IllegalStateException(this.getAlgorithmName() + " needs to be initialized");
    }

    private void finishAAD(State nextState) {
        switch (this.m_state) {
            case DecAad: 
            case EncAad: {
                this.processFinalAAD();
                break;
            }
        }
        this.m_bufPos = 0;
        this.m_state = nextState;
    }

    private void processBufferAAD(byte[] buffer, int bufOff) {
        for (int i = 0; i < this.RATE_WORDS / 2; ++i) {
            int j = i + this.RATE_WORDS / 2;
            int s_i = this.state[i];
            int s_j = this.state[j];
            int d_i = Pack.littleEndianToInt(buffer, bufOff + i * 4);
            int d_j = Pack.littleEndianToInt(buffer, bufOff + j * 4);
            this.state[i] = s_j ^ d_i ^ this.state[this.RATE_WORDS + i];
            this.state[j] = s_i ^ s_j ^ d_j ^ this.state[this.RATE_WORDS + (j & this.CAP_MASK)];
        }
        SparkleEngine.sparkle_opt(this.state, this.SPARKLE_STEPS_SLIM);
    }

    private void processBufferDecrypt(byte[] buffer, int bufOff, byte[] output, int outOff) {
        if (outOff > output.length - this.RATE_BYTES) {
            throw new OutputLengthException("output buffer too short");
        }
        for (int i = 0; i < this.RATE_WORDS / 2; ++i) {
            int j = i + this.RATE_WORDS / 2;
            int s_i = this.state[i];
            int s_j = this.state[j];
            int d_i = Pack.littleEndianToInt(buffer, bufOff + i * 4);
            int d_j = Pack.littleEndianToInt(buffer, bufOff + j * 4);
            this.state[i] = s_i ^ s_j ^ d_i ^ this.state[this.RATE_WORDS + i];
            this.state[j] = s_i ^ d_j ^ this.state[this.RATE_WORDS + (j & this.CAP_MASK)];
            Pack.intToLittleEndian(d_i ^ s_i, output, outOff + i * 4);
            Pack.intToLittleEndian(d_j ^ s_j, output, outOff + j * 4);
        }
        SparkleEngine.sparkle_opt(this.state, this.SPARKLE_STEPS_SLIM);
        this.encrypted = true;
    }

    private void processBufferEncrypt(byte[] buffer, int bufOff, byte[] output, int outOff) {
        if (outOff > output.length - this.RATE_BYTES) {
            throw new OutputLengthException("output buffer too short");
        }
        for (int i = 0; i < this.RATE_WORDS / 2; ++i) {
            int j = i + this.RATE_WORDS / 2;
            int s_i = this.state[i];
            int s_j = this.state[j];
            int d_i = Pack.littleEndianToInt(buffer, bufOff + i * 4);
            int d_j = Pack.littleEndianToInt(buffer, bufOff + j * 4);
            this.state[i] = s_j ^ d_i ^ this.state[this.RATE_WORDS + i];
            this.state[j] = s_i ^ s_j ^ d_j ^ this.state[this.RATE_WORDS + (j & this.CAP_MASK)];
            Pack.intToLittleEndian(d_i ^ s_i, output, outOff + i * 4);
            Pack.intToLittleEndian(d_j ^ s_j, output, outOff + j * 4);
        }
        SparkleEngine.sparkle_opt(this.state, this.SPARKLE_STEPS_SLIM);
        this.encrypted = true;
    }

    private void processFinalAAD() {
        if (this.m_bufPos < this.RATE_BYTES) {
            int n = this.STATE_WORDS - 1;
            this.state[n] = this.state[n] ^ this._A0;
            this.m_buf[this.m_bufPos] = -128;
            while (++this.m_bufPos < this.RATE_BYTES) {
                this.m_buf[this.m_bufPos] = 0;
            }
        } else {
            int n = this.STATE_WORDS - 1;
            this.state[n] = this.state[n] ^ this._A1;
        }
        for (int i = 0; i < this.RATE_WORDS / 2; ++i) {
            int j = i + this.RATE_WORDS / 2;
            int s_i = this.state[i];
            int s_j = this.state[j];
            int d_i = Pack.littleEndianToInt(this.m_buf, i * 4);
            int d_j = Pack.littleEndianToInt(this.m_buf, j * 4);
            this.state[i] = s_j ^ d_i ^ this.state[this.RATE_WORDS + i];
            this.state[j] = s_i ^ s_j ^ d_j ^ this.state[this.RATE_WORDS + (j & this.CAP_MASK)];
        }
        SparkleEngine.sparkle_opt(this.state, this.SPARKLE_STEPS_BIG);
    }

    private void reset(boolean clearMac) {
        if (clearMac) {
            this.tag = null;
        }
        Arrays.clear(this.m_buf);
        this.m_bufPos = 0;
        this.encrypted = false;
        switch (this.m_state) {
            case DecInit: 
            case EncInit: {
                break;
            }
            case DecAad: 
            case DecData: 
            case DecFinal: {
                this.m_state = State.DecInit;
                break;
            }
            case EncData: 
            case EncFinal: 
            case EncAad: {
                this.m_state = State.EncFinal;
                return;
            }
            default: {
                throw new IllegalStateException(this.getAlgorithmName() + " needs to be initialized");
            }
        }
        System.arraycopy(this.npub, 0, this.state, 0, this.RATE_WORDS);
        System.arraycopy(this.k, 0, this.state, this.RATE_WORDS, this.KEY_WORDS);
        SparkleEngine.sparkle_opt(this.state, this.SPARKLE_STEPS_BIG);
        if (this.initialAssociatedText != null) {
            this.processAADBytes(this.initialAssociatedText, 0, this.initialAssociatedText.length);
        }
    }

    private static int ELL(int x) {
        return Integers.rotateRight(x, 16) ^ x & 0xFFFF;
    }

    private static void sparkle_opt(int[] state, int steps) {
        switch (state.length) {
            case 8: {
                SparkleEngine.sparkle_opt8(state, steps);
                break;
            }
            case 12: {
                SparkleEngine.sparkle_opt12(state, steps);
                break;
            }
            case 16: {
                SparkleEngine.sparkle_opt16(state, steps);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    static void sparkle_opt8(int[] state, int steps) {
        int s00 = state[0];
        int s01 = state[1];
        int s02 = state[2];
        int s03 = state[3];
        int s04 = state[4];
        int s05 = state[5];
        int s06 = state[6];
        int s07 = state[7];
        for (int step = 0; step < steps; ++step) {
            s03 ^= step;
            int rc = RCON[0];
            s00 += Integers.rotateRight(s01 ^= RCON[step & 7], 31);
            s01 ^= Integers.rotateRight(s00, 24);
            s00 ^= rc;
            s00 += Integers.rotateRight(s01, 17);
            s01 ^= Integers.rotateRight(s00, 17);
            s00 ^= rc;
            s00 += s01;
            s01 ^= Integers.rotateRight(s00, 31);
            s00 ^= rc;
            s00 += Integers.rotateRight(s01, 24);
            s01 ^= Integers.rotateRight(s00, 16);
            s00 ^= rc;
            rc = RCON[1];
            s02 += Integers.rotateRight(s03, 31);
            s03 ^= Integers.rotateRight(s02, 24);
            s02 ^= rc;
            s02 += Integers.rotateRight(s03, 17);
            s03 ^= Integers.rotateRight(s02, 17);
            s02 ^= rc;
            s02 += s03;
            s03 ^= Integers.rotateRight(s02, 31);
            s02 ^= rc;
            s02 += Integers.rotateRight(s03, 24);
            s03 ^= Integers.rotateRight(s02, 16);
            s02 ^= rc;
            rc = RCON[2];
            s04 += Integers.rotateRight(s05, 31);
            s05 ^= Integers.rotateRight(s04, 24);
            s04 ^= rc;
            s04 += Integers.rotateRight(s05, 17);
            s05 ^= Integers.rotateRight(s04, 17);
            s04 ^= rc;
            s04 += s05;
            s05 ^= Integers.rotateRight(s04, 31);
            s04 ^= rc;
            s04 += Integers.rotateRight(s05, 24);
            s05 ^= Integers.rotateRight(s04, 16);
            s04 ^= rc;
            rc = RCON[3];
            s06 += Integers.rotateRight(s07, 31);
            s07 ^= Integers.rotateRight(s06, 24);
            s06 ^= rc;
            s06 += Integers.rotateRight(s07, 17);
            s07 ^= Integers.rotateRight(s06, 17);
            s06 ^= rc;
            s06 += s07;
            s07 ^= Integers.rotateRight(s06, 31);
            s06 ^= rc;
            s06 += Integers.rotateRight(s07, 24);
            s07 ^= Integers.rotateRight(s06, 16);
            int t02 = SparkleEngine.ELL(s00 ^ s02);
            int t13 = SparkleEngine.ELL(s01 ^ s03);
            int u00 = s00 ^ s04;
            int u01 = s01 ^ s05;
            int u02 = s02 ^ (s06 ^= rc);
            int u03 = s03 ^ s07;
            s04 = s00;
            s05 = s01;
            s06 = s02;
            s07 = s03;
            s00 = u02 ^ t13;
            s01 = u03 ^ t02;
            s02 = u00 ^ t13;
            s03 = u01 ^ t02;
        }
        state[0] = s00;
        state[1] = s01;
        state[2] = s02;
        state[3] = s03;
        state[4] = s04;
        state[5] = s05;
        state[6] = s06;
        state[7] = s07;
    }

    static void sparkle_opt12(int[] state, int steps) {
        int s00 = state[0];
        int s01 = state[1];
        int s02 = state[2];
        int s03 = state[3];
        int s04 = state[4];
        int s05 = state[5];
        int s06 = state[6];
        int s07 = state[7];
        int s08 = state[8];
        int s09 = state[9];
        int s10 = state[10];
        int s11 = state[11];
        for (int step = 0; step < steps; ++step) {
            s03 ^= step;
            int rc = RCON[0];
            s00 += Integers.rotateRight(s01 ^= RCON[step & 7], 31);
            s01 ^= Integers.rotateRight(s00, 24);
            s00 ^= rc;
            s00 += Integers.rotateRight(s01, 17);
            s01 ^= Integers.rotateRight(s00, 17);
            s00 ^= rc;
            s00 += s01;
            s01 ^= Integers.rotateRight(s00, 31);
            s00 ^= rc;
            s00 += Integers.rotateRight(s01, 24);
            s01 ^= Integers.rotateRight(s00, 16);
            s00 ^= rc;
            rc = RCON[1];
            s02 += Integers.rotateRight(s03, 31);
            s03 ^= Integers.rotateRight(s02, 24);
            s02 ^= rc;
            s02 += Integers.rotateRight(s03, 17);
            s03 ^= Integers.rotateRight(s02, 17);
            s02 ^= rc;
            s02 += s03;
            s03 ^= Integers.rotateRight(s02, 31);
            s02 ^= rc;
            s02 += Integers.rotateRight(s03, 24);
            s03 ^= Integers.rotateRight(s02, 16);
            s02 ^= rc;
            rc = RCON[2];
            s04 += Integers.rotateRight(s05, 31);
            s05 ^= Integers.rotateRight(s04, 24);
            s04 ^= rc;
            s04 += Integers.rotateRight(s05, 17);
            s05 ^= Integers.rotateRight(s04, 17);
            s04 ^= rc;
            s04 += s05;
            s05 ^= Integers.rotateRight(s04, 31);
            s04 ^= rc;
            s04 += Integers.rotateRight(s05, 24);
            s05 ^= Integers.rotateRight(s04, 16);
            s04 ^= rc;
            rc = RCON[3];
            s06 += Integers.rotateRight(s07, 31);
            s07 ^= Integers.rotateRight(s06, 24);
            s06 ^= rc;
            s06 += Integers.rotateRight(s07, 17);
            s07 ^= Integers.rotateRight(s06, 17);
            s06 ^= rc;
            s06 += s07;
            s07 ^= Integers.rotateRight(s06, 31);
            s06 ^= rc;
            s06 += Integers.rotateRight(s07, 24);
            s07 ^= Integers.rotateRight(s06, 16);
            s06 ^= rc;
            rc = RCON[4];
            s08 += Integers.rotateRight(s09, 31);
            s09 ^= Integers.rotateRight(s08, 24);
            s08 ^= rc;
            s08 += Integers.rotateRight(s09, 17);
            s09 ^= Integers.rotateRight(s08, 17);
            s08 ^= rc;
            s08 += s09;
            s09 ^= Integers.rotateRight(s08, 31);
            s08 ^= rc;
            s08 += Integers.rotateRight(s09, 24);
            s09 ^= Integers.rotateRight(s08, 16);
            s08 ^= rc;
            rc = RCON[5];
            s10 += Integers.rotateRight(s11, 31);
            s11 ^= Integers.rotateRight(s10, 24);
            s10 ^= rc;
            s10 += Integers.rotateRight(s11, 17);
            s11 ^= Integers.rotateRight(s10, 17);
            s10 ^= rc;
            s10 += s11;
            s11 ^= Integers.rotateRight(s10, 31);
            s10 ^= rc;
            s10 += Integers.rotateRight(s11, 24);
            s11 ^= Integers.rotateRight(s10, 16);
            s10 ^= rc;
            int t024 = SparkleEngine.ELL(s00 ^ s02 ^ s04);
            int t135 = SparkleEngine.ELL(s01 ^ s03 ^ s05);
            int u00 = s00 ^ s06;
            int u01 = s01 ^ s07;
            int u02 = s02 ^ s08;
            int u03 = s03 ^ s09;
            int u04 = s04 ^ s10;
            int u05 = s05 ^ s11;
            s06 = s00;
            s07 = s01;
            s08 = s02;
            s09 = s03;
            s10 = s04;
            s11 = s05;
            s00 = u02 ^ t135;
            s01 = u03 ^ t024;
            s02 = u04 ^ t135;
            s03 = u05 ^ t024;
            s04 = u00 ^ t135;
            s05 = u01 ^ t024;
        }
        state[0] = s00;
        state[1] = s01;
        state[2] = s02;
        state[3] = s03;
        state[4] = s04;
        state[5] = s05;
        state[6] = s06;
        state[7] = s07;
        state[8] = s08;
        state[9] = s09;
        state[10] = s10;
        state[11] = s11;
    }

    public static void sparkle_opt12(SparkleDigest.Friend friend, int[] state, int steps) {
        if (null == friend) {
            throw new NullPointerException("This method is only for use by SparkleDigest");
        }
        SparkleEngine.sparkle_opt12(state, steps);
    }

    static void sparkle_opt16(int[] state, int steps) {
        int s00 = state[0];
        int s01 = state[1];
        int s02 = state[2];
        int s03 = state[3];
        int s04 = state[4];
        int s05 = state[5];
        int s06 = state[6];
        int s07 = state[7];
        int s08 = state[8];
        int s09 = state[9];
        int s10 = state[10];
        int s11 = state[11];
        int s12 = state[12];
        int s13 = state[13];
        int s14 = state[14];
        int s15 = state[15];
        for (int step = 0; step < steps; ++step) {
            s03 ^= step;
            int rc = RCON[0];
            s00 += Integers.rotateRight(s01 ^= RCON[step & 7], 31);
            s01 ^= Integers.rotateRight(s00, 24);
            s00 ^= rc;
            s00 += Integers.rotateRight(s01, 17);
            s01 ^= Integers.rotateRight(s00, 17);
            s00 ^= rc;
            s00 += s01;
            s01 ^= Integers.rotateRight(s00, 31);
            s00 ^= rc;
            s00 += Integers.rotateRight(s01, 24);
            s01 ^= Integers.rotateRight(s00, 16);
            s00 ^= rc;
            rc = RCON[1];
            s02 += Integers.rotateRight(s03, 31);
            s03 ^= Integers.rotateRight(s02, 24);
            s02 ^= rc;
            s02 += Integers.rotateRight(s03, 17);
            s03 ^= Integers.rotateRight(s02, 17);
            s02 ^= rc;
            s02 += s03;
            s03 ^= Integers.rotateRight(s02, 31);
            s02 ^= rc;
            s02 += Integers.rotateRight(s03, 24);
            s03 ^= Integers.rotateRight(s02, 16);
            s02 ^= rc;
            rc = RCON[2];
            s04 += Integers.rotateRight(s05, 31);
            s05 ^= Integers.rotateRight(s04, 24);
            s04 ^= rc;
            s04 += Integers.rotateRight(s05, 17);
            s05 ^= Integers.rotateRight(s04, 17);
            s04 ^= rc;
            s04 += s05;
            s05 ^= Integers.rotateRight(s04, 31);
            s04 ^= rc;
            s04 += Integers.rotateRight(s05, 24);
            s05 ^= Integers.rotateRight(s04, 16);
            s04 ^= rc;
            rc = RCON[3];
            s06 += Integers.rotateRight(s07, 31);
            s07 ^= Integers.rotateRight(s06, 24);
            s06 ^= rc;
            s06 += Integers.rotateRight(s07, 17);
            s07 ^= Integers.rotateRight(s06, 17);
            s06 ^= rc;
            s06 += s07;
            s07 ^= Integers.rotateRight(s06, 31);
            s06 ^= rc;
            s06 += Integers.rotateRight(s07, 24);
            s07 ^= Integers.rotateRight(s06, 16);
            s06 ^= rc;
            rc = RCON[4];
            s08 += Integers.rotateRight(s09, 31);
            s09 ^= Integers.rotateRight(s08, 24);
            s08 ^= rc;
            s08 += Integers.rotateRight(s09, 17);
            s09 ^= Integers.rotateRight(s08, 17);
            s08 ^= rc;
            s08 += s09;
            s09 ^= Integers.rotateRight(s08, 31);
            s08 ^= rc;
            s08 += Integers.rotateRight(s09, 24);
            s09 ^= Integers.rotateRight(s08, 16);
            s08 ^= rc;
            rc = RCON[5];
            s10 += Integers.rotateRight(s11, 31);
            s11 ^= Integers.rotateRight(s10, 24);
            s10 ^= rc;
            s10 += Integers.rotateRight(s11, 17);
            s11 ^= Integers.rotateRight(s10, 17);
            s10 ^= rc;
            s10 += s11;
            s11 ^= Integers.rotateRight(s10, 31);
            s10 ^= rc;
            s10 += Integers.rotateRight(s11, 24);
            s11 ^= Integers.rotateRight(s10, 16);
            s10 ^= rc;
            rc = RCON[6];
            s12 += Integers.rotateRight(s13, 31);
            s13 ^= Integers.rotateRight(s12, 24);
            s12 ^= rc;
            s12 += Integers.rotateRight(s13, 17);
            s13 ^= Integers.rotateRight(s12, 17);
            s12 ^= rc;
            s12 += s13;
            s13 ^= Integers.rotateRight(s12, 31);
            s12 ^= rc;
            s12 += Integers.rotateRight(s13, 24);
            s13 ^= Integers.rotateRight(s12, 16);
            s12 ^= rc;
            rc = RCON[7];
            s14 += Integers.rotateRight(s15, 31);
            s15 ^= Integers.rotateRight(s14, 24);
            s14 ^= rc;
            s14 += Integers.rotateRight(s15, 17);
            s15 ^= Integers.rotateRight(s14, 17);
            s14 ^= rc;
            s14 += s15;
            s15 ^= Integers.rotateRight(s14, 31);
            s14 ^= rc;
            s14 += Integers.rotateRight(s15, 24);
            s15 ^= Integers.rotateRight(s14, 16);
            s14 ^= rc;
            int t0246 = SparkleEngine.ELL(s00 ^ s02 ^ s04 ^ s06);
            int t1357 = SparkleEngine.ELL(s01 ^ s03 ^ s05 ^ s07);
            int u00 = s00 ^ s08;
            int u01 = s01 ^ s09;
            int u02 = s02 ^ s10;
            int u03 = s03 ^ s11;
            int u04 = s04 ^ s12;
            int u05 = s05 ^ s13;
            int u06 = s06 ^ s14;
            int u07 = s07 ^ s15;
            s08 = s00;
            s09 = s01;
            s10 = s02;
            s11 = s03;
            s12 = s04;
            s13 = s05;
            s14 = s06;
            s15 = s07;
            s00 = u02 ^ t1357;
            s01 = u03 ^ t0246;
            s02 = u04 ^ t1357;
            s03 = u05 ^ t0246;
            s04 = u06 ^ t1357;
            s05 = u07 ^ t0246;
            s06 = u00 ^ t1357;
            s07 = u01 ^ t0246;
        }
        state[0] = s00;
        state[1] = s01;
        state[2] = s02;
        state[3] = s03;
        state[4] = s04;
        state[5] = s05;
        state[6] = s06;
        state[7] = s07;
        state[8] = s08;
        state[9] = s09;
        state[10] = s10;
        state[11] = s11;
        state[12] = s12;
        state[13] = s13;
        state[14] = s14;
        state[15] = s15;
    }

    public static void sparkle_opt16(SparkleDigest.Friend friend, int[] state, int steps) {
        if (null == friend) {
            throw new NullPointerException("This method is only for use by SparkleDigest");
        }
        SparkleEngine.sparkle_opt16(state, steps);
    }

    public static enum SparkleParameters {
        SCHWAEMM128_128,
        SCHWAEMM256_128,
        SCHWAEMM192_192,
        SCHWAEMM256_256;

    }

    private static enum State {
        Uninitialized,
        EncInit,
        EncAad,
        EncData,
        EncFinal,
        DecInit,
        DecAad,
        DecData,
        DecFinal;

    }
}

