/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1ApplicationSpecific;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERFactory;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DERApplicationSpecific
extends ASN1ApplicationSpecific {
    public DERApplicationSpecific(int tagNo, byte[] contentsOctets) {
        super(new DERTaggedObject(false, 64, tagNo, (ASN1Encodable)new DEROctetString(contentsOctets)));
    }

    public DERApplicationSpecific(int tag, ASN1Encodable baseEncodable) throws IOException {
        this(true, tag, baseEncodable);
    }

    public DERApplicationSpecific(boolean explicit, int tagNo, ASN1Encodable baseEncodable) throws IOException {
        super(new DERTaggedObject(explicit, 64, tagNo, baseEncodable));
    }

    public DERApplicationSpecific(int tagNo, ASN1EncodableVector contentsElements) {
        super(new DERTaggedObject(false, 64, tagNo, (ASN1Encodable)DERFactory.createSequence(contentsElements)));
    }

    DERApplicationSpecific(ASN1TaggedObject taggedObject) {
        super(taggedObject);
    }

    @Override
    ASN1Primitive toDERObject() {
        return this;
    }

    @Override
    ASN1Primitive toDLObject() {
        return this;
    }
}

