/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcUtil;

public class BcSessionKeyDataDecryptorFactory
implements SessionKeyDataDecryptorFactory {
    private final PGPSessionKey sessionKey;

    public BcSessionKeyDataDecryptorFactory(PGPSessionKey pGPSessionKey) {
        this.sessionKey = pGPSessionKey;
    }

    public PGPSessionKey getSessionKey() {
        return this.sessionKey;
    }

    public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
        BlockCipher blockCipher = BcImplProvider.createBlockCipher(n);
        return BcUtil.createDataDecryptor(bl, blockCipher, byArray);
    }

    public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aEADEncDataPacket, PGPSessionKey pGPSessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV5DataDecryptor(aEADEncDataPacket, pGPSessionKey);
    }

    public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket symmetricEncIntegrityPacket, PGPSessionKey pGPSessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV6DataDecryptor(symmetricEncIntegrityPacket, pGPSessionKey);
    }
}

