/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.general.PBKD;
import org.bouncycastle.jcajce.provider.AlgorithmProvider;
import org.bouncycastle.jcajce.provider.BaseKDFSecretKeyFactory;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.util.Strings;

class ProvOpenSSLPBKDF
extends AlgorithmProvider {
    private static final String PREFIX = ProvOpenSSLPBKDF.class.getName();

    ProvOpenSSLPBKDF() {
    }

    void configure(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.PBKDF-OPENSSL", PREFIX + "$PBKDF", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new PBKDF();
            }
        }));
    }

    static class PBKDF
    extends BaseKDFSecretKeyFactory {
        PBKDF() {
        }

        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PBEKeySpec) {
                PBEKeySpec pBEKeySpec = (PBEKeySpec)keySpec;
                if (pBEKeySpec.getSalt() == null) {
                    throw new InvalidKeySpecException("Missing required salt");
                }
                if (pBEKeySpec.getKeyLength() <= 0) {
                    throw new InvalidKeySpecException("Positive key length required: " + pBEKeySpec.getKeyLength());
                }
                PasswordBasedDeriver<PBKD.Parameters> passwordBasedDeriver = new PBKD.DeriverFactory().createDeriver(PBKD.OpenSSL.using(Strings.toByteArray(pBEKeySpec.getPassword())).withSalt(pBEKeySpec.getSalt()));
                return new SecretKeySpec(passwordBasedDeriver.deriveKey(PasswordBasedDeriver.KeyType.CIPHER, pBEKeySpec.getKeyLength() / 8), "PBKDF-OpenSSL");
            }
            throw new InvalidKeySpecException("Invalid KeySpec: " + keySpec.getClass().getName());
        }
    }
}

