/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.mvs;

import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.abst.feature.describe.DescriptorInfo;
import boofcv.alg.mvs.video.RelativeBetter;
import boofcv.alg.mvs.video.SelectFramesForReconstruction3D;
import boofcv.factory.feature.associate.ConfigAssociate;
import boofcv.factory.feature.associate.FactoryAssociation;
import boofcv.factory.feature.describe.ConfigDescribeRegionPoint;
import boofcv.factory.feature.describe.FactoryDescribeRegionPoint;
import boofcv.factory.geo.ConfigLMedS;
import boofcv.factory.geo.FactoryMultiViewRobust;
import boofcv.factory.mvs.ConfigSelectFrames3D;
import boofcv.factory.tracker.ConfigPointTracker;
import boofcv.factory.tracker.FactoryPointTracker;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.homography.Homography2D_F64;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class FactoryMultiViewStereo {
    public static <T extends ImageGray<T>> SelectFramesForReconstruction3D<T> frameSelector3D(@Nullable ConfigSelectFrames3D config, ImageType<T> imageType) {
        if (config == null) {
            config = new ConfigSelectFrames3D();
        }
        Class grayType = imageType.getImageClass();
        DescribeRegionPoint describe = FactoryDescribeRegionPoint.generic((ConfigDescribeRegionPoint)config.describe, imageType);
        SelectFramesForReconstruction3D alg = new SelectFramesForReconstruction3D(describe);
        alg.config.setTo(config);
        alg.setTracker(FactoryPointTracker.tracker((ConfigPointTracker)config.tracker, (Class)grayType, null));
        alg.setAssociate((AssociateDescription2D<TupleDesc_F64>)FactoryAssociation.generic2((ConfigAssociate)config.associate, (DescriptorInfo)describe));
        ConfigLMedS configRobust = new ConfigLMedS();
        configRobust.totalCycles = config.robustIterations;
        configRobust.errorFraction = 0.75;
        alg.setRobust3D((ModelMatcher<DMatrixRMaj, AssociatedPair>)FactoryMultiViewRobust.fundamentalLMedS(null, (ConfigLMedS)configRobust));
        alg.setRobustH((ModelMatcher<Homography2D_F64, AssociatedPair>)FactoryMultiViewRobust.homographyLMedS(null, (ConfigLMedS)configRobust));
        alg.setCompareFit(new RelativeBetter.ErrorHardRatioSq(config.motionInlierPx));
        return alg;
    }

    public static boolean isErrorSignificant3D(double error3D, double errorH, double significant, double tol) {
        if (errorH < significant) {
            return false;
        }
        return errorH - error3D >= errorH * tol;
    }
}

