/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure;

import boofcv.alg.geo.bundle.cameras.BundlePinholeSimplified;
import boofcv.alg.sfm.structure.PairwiseImageGraph;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.ImageDimension;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastArray;
import org.ejml.data.DMatrixRMaj;

public class SceneWorkingGraph {
    public final Map<String, View> views = new HashMap<String, View>();
    public final List<View> viewList = new ArrayList<View>();
    public final List<Feature> features = new ArrayList<Feature>();

    public void reset() {
        this.views.clear();
        this.viewList.clear();
        this.features.clear();
    }

    public View lookupView(String id) {
        return this.views.get(id);
    }

    public boolean isKnown(PairwiseImageGraph.View pview) {
        return this.views.containsKey(pview.id);
    }

    public View addView(PairwiseImageGraph.View pview) {
        View v = new View();
        v.pview = pview;
        BoofMiscOps.checkTrue((null == this.views.put(v.pview.id, v) ? 1 : 0) != 0, (String)("There shouldn't be an existing view with the same key: '" + v.pview.id + "'"));
        v.index = this.viewList.size();
        this.viewList.add(v);
        return v;
    }

    public Feature createFeature() {
        Feature f = new Feature();
        f.reset();
        this.features.add(f);
        return f;
    }

    public List<View> getAllViews() {
        return this.viewList;
    }

    public static class View {
        public PairwiseImageGraph.View pview;
        public final TIntObjectHashMap<Feature> obs_to_feat = new TIntObjectHashMap();
        public final InlierInfo inliers = new InlierInfo();
        public final DMatrixRMaj projective = new DMatrixRMaj(3, 4);
        public final BundlePinholeSimplified intrinsic = new BundlePinholeSimplified();
        public final Se3_F64 world_to_view = new Se3_F64();
        public final ImageDimension imageDimension = new ImageDimension();
        public int index = -1;

        public Feature getFeatureFromObs(int observationIdx) {
            return (Feature)this.obs_to_feat.get(observationIdx);
        }

        public void setObsToFeature(int observationIdx, Feature feature) {
            this.obs_to_feat.put(observationIdx, (Object)feature);
        }

        public void reset() {
            this.index = -1;
            this.pview = null;
            this.imageDimension.setTo(-1, -1);
            this.obs_to_feat.clear();
            this.projective.zero();
            this.intrinsic.reset();
            this.inliers.reset();
        }

        public String toString() {
            return "View{id='" + this.pview.id + "' inliers=" + !this.inliers.isEmpty() + "}";
        }
    }

    public static class Feature {
        public final Point4D_F64 location = new Point4D_F64();
        public final List<Observation> observations = new ArrayList<Observation>();

        public void reset() {
            this.location.setTo(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
            this.observations.clear();
        }

        public Point2D_F64 findObservation(View v) {
            for (int i = 0; i < this.observations.size(); ++i) {
                if (this.observations.get((int)i).view != v) continue;
                return this.observations.get((int)i).pixel;
            }
            return null;
        }
    }

    public static class InlierInfo {
        public final FastArray<PairwiseImageGraph.View> views = new FastArray(PairwiseImageGraph.View.class);
        public final DogArray<DogArray_I32> observations = new DogArray(DogArray_I32::new, DogArray_I32::reset);

        public boolean isEmpty() {
            return this.observations.size == 0;
        }

        public int getInlierCount() {
            return ((DogArray_I32)this.observations.get((int)0)).size;
        }

        public void reset() {
            this.views.reset();
            this.observations.reset();
        }
    }

    public static class Observation {
        public View view;
        public int observationIdx;
        public final Point2D_F64 pixel = new Point2D_F64();

        public Observation() {
        }

        public Observation(View view, int observationIdx) {
            this.view = view;
            this.observationIdx = observationIdx;
        }

        public void reset() {
            this.view = null;
            this.observationIdx = -1;
            this.pixel.setTo(Double.NaN, Double.NaN);
        }
    }
}

