/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure;

import boofcv.struct.feature.AssociatedIndex;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.FastArray;
import org.ejml.data.DMatrixRMaj;

public class PairwiseImageGraph {
    public DogArray<View> nodes = new DogArray(View::new);
    public DogArray<Motion> edges = new DogArray(Motion::new);
    public Map<String, View> mapNodes = new HashMap<String, View>();

    public void reset() {
        this.mapNodes.clear();
        this.nodes.reset();
        this.edges.reset();
    }

    public View createNode(String id) {
        View v = (View)this.nodes.grow();
        v.init(id);
        this.mapNodes.put(id, v);
        return v;
    }

    public View lookupNode(String id) {
        return this.mapNodes.get(id);
    }

    public Motion connect(View a, View b) {
        Motion m = (Motion)this.edges.grow();
        m.src = a;
        m.dst = b;
        m.index = this.edges.size - 1;
        a.connections.add((Object)m);
        b.connections.add((Object)m);
        return m;
    }

    public static class View {
        public String id;
        public int totalObservations;
        public FastArray<Motion> connections = new FastArray(Motion.class);

        void init(String id) {
            this.id = id;
            this.connections.reset();
        }

        public View connection(int index) {
            return ((Motion)this.connections.get(index)).other(this);
        }

        public Motion findMotion(View target) {
            int idx = this.findMotionIdx(target);
            if (idx == -1) {
                return null;
            }
            return (Motion)this.connections.get(idx);
        }

        public int findMotionIdx(View target) {
            for (int i = 0; i < this.connections.size; ++i) {
                Motion m = (Motion)this.connections.get(i);
                if (m.src != target && m.dst != target) continue;
                return i;
            }
            return -1;
        }

        public void getConnections(int[] indexes, int length, List<View> views) {
            views.clear();
            for (int i = 0; i < length; ++i) {
                views.add(((Motion)this.connections.get(indexes[i])).other(this));
            }
        }

        public String toString() {
            return "PView{id=" + this.id + ", conn=" + this.connections.size + ", obs=" + this.totalObservations + "}";
        }
    }

    public static class Motion {
        public final DMatrixRMaj F = new DMatrixRMaj(3, 3);
        public boolean is3D;
        public int countF;
        public int countH;
        public final DogArray<AssociatedIndex> inliers = new DogArray(AssociatedIndex::new);
        public View src;
        public View dst;
        public int index;

        public void init() {
            this.F.zero();
            this.is3D = false;
            this.index = -1;
            this.src = null;
            this.dst = null;
        }

        public boolean isConnected(View v) {
            return v == this.src || v == this.dst;
        }

        public View other(View src) {
            if (src == this.src) {
                return this.dst;
            }
            if (src == this.dst) {
                return this.src;
            }
            throw new RuntimeException("BUG!");
        }

        public String toString() {
            return "Motion( " + (this.is3D ? "3D " : "") + " '" + this.src.id + "' <-> '" + this.dst.id + "')";
        }
    }
}

