/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure;

import boofcv.abst.geo.TriangulateNViewsProjective;
import boofcv.abst.geo.bundle.BundleAdjustment;
import boofcv.abst.geo.bundle.ScaleSceneStructure;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructure;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureProjective;
import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.geo.pose.PoseFromPairLinear6;
import boofcv.alg.sfm.structure.ConfigProjectiveReconstruction;
import boofcv.alg.sfm.structure.LookUpSimilarImages;
import boofcv.alg.sfm.structure.PairwiseImageGraph;
import boofcv.alg.sfm.structure.SceneWorkingGraph;
import boofcv.factory.geo.ConfigBundleAdjustment;
import boofcv.factory.geo.ConfigRansac;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.ConfigTrifocal;
import boofcv.factory.geo.ConfigTrifocalError;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.factory.geo.FactoryMultiViewRobust;
import boofcv.misc.BoofMiscOps;
import boofcv.misc.ConfigConverge;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.geo.AssociatedTriple;
import boofcv.struct.geo.TrifocalTensor;
import boofcv.struct.image.ImageDimension;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point4D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_B;
import org.ddogleg.struct.DogArray_I32;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class PairwiseGraphUtils {
    LookUpSimilarImages db;
    DogArray_B visibleAll = new DogArray_B();
    DogArray_B visibleMotion = new DogArray_B();
    public ConfigConverge configConvergeSBA = new ConfigConverge(1.0E-8, 1.0E-8, 50);
    public boolean configScaleSBA = false;
    protected final SceneStructureProjective structure = new SceneStructureProjective(true);
    protected final SceneObservations observations = new SceneObservations();
    protected ModelMatcher<TrifocalTensor, AssociatedTriple> ransac;
    protected TriangulateNViewsProjective triangulator;
    protected PoseFromPairLinear6 poseEstimator = new PoseFromPairLinear6();
    protected BundleAdjustment<SceneStructureProjective> sba;
    protected ScaleSceneStructure scaler = new ScaleSceneStructure();
    public PairwiseImageGraph.View seed;
    public PairwiseImageGraph.View viewB;
    public PairwiseImageGraph.View viewC;
    public ImageDimension dimenA = new ImageDimension();
    public ImageDimension dimenB = new ImageDimension();
    public ImageDimension dimenC = new ImageDimension();
    public final DogArray<AssociatedTriple> matchesTriple = new DogArray(AssociatedTriple::new);
    public List<AssociatedTriple> inliersThreeView;
    public final DMatrixRMaj P1 = new DMatrixRMaj(3, 4);
    public final DMatrixRMaj P2 = new DMatrixRMaj(3, 4);
    public final DMatrixRMaj P3 = new DMatrixRMaj(3, 4);
    public final DogArray<Point2D_F64> featsA = new DogArray(Point2D_F64::new);
    public final DogArray<Point2D_F64> featsB = new DogArray(Point2D_F64::new);
    public final DogArray<Point2D_F64> featsC = new DogArray(Point2D_F64::new);
    public final DogArray_I32 table_A_to_B = new DogArray_I32();
    public final DogArray_I32 table_A_to_C = new DogArray_I32();
    public final DogArray_I32 table_B_to_C = new DogArray_I32();
    public final DogArray_I32 table_C_to_A = new DogArray_I32();
    public final DogArray_I32 commonIdx = new DogArray_I32();
    public ScoreMotion scoreMotion = new DefaultScoreMotion();
    protected final ImageDimension shape = new ImageDimension();

    public PairwiseGraphUtils(TriangulateNViewsProjective triangulator, ModelMatcher<TrifocalTensor, AssociatedTriple> ransac, BundleAdjustment<SceneStructureProjective> sba) {
        this.triangulator = triangulator;
        this.ransac = ransac;
        this.sba = sba;
    }

    public PairwiseGraphUtils(ConfigProjectiveReconstruction config) {
        config.checkValidity();
        this.triangulator = FactoryMultiView.triangulateNViewProj((ConfigTriangulation)ConfigTriangulation.GEOMETRIC());
        this.ransac = FactoryMultiViewRobust.trifocalRansac((ConfigTrifocal)config.ransacTrifocal, (ConfigTrifocalError)config.ransacError, (ConfigRansac)config.ransac);
        this.sba = FactoryMultiView.bundleSparseProjective((ConfigBundleAdjustment)config.sba);
        this.configConvergeSBA.setTo(config.sbaConverge);
        this.configScaleSBA = config.sbaScale;
    }

    protected PairwiseGraphUtils() {
    }

    public DogArray_I32 findCommonFeatures(PairwiseImageGraph.View seed, DogArray_I32 connectIdx) {
        if (connectIdx.size < 1) {
            throw new RuntimeException("Called when there are no connections");
        }
        this.visibleAll.resize(seed.totalObservations);
        this.visibleMotion.resize(seed.totalObservations);
        for (int idxMotion = 0; idxMotion < connectIdx.size; ++idxMotion) {
            int i;
            PairwiseImageGraph.Motion m = (PairwiseImageGraph.Motion)seed.connections.get(connectIdx.get(idxMotion));
            boolean seedIsSrc = m.src == seed;
            this.visibleMotion.fill(false);
            for (i = 0; i < m.inliers.size; ++i) {
                AssociatedIndex a = (AssociatedIndex)m.inliers.get(i);
                this.visibleMotion.data[seedIsSrc ? a.src : a.dst] = true;
            }
            if (idxMotion == 0) {
                this.visibleAll.setTo(this.visibleMotion);
                continue;
            }
            for (i = 0; i < seed.totalObservations; ++i) {
                int n = i;
                this.visibleAll.data[n] = this.visibleAll.data[n] & this.visibleMotion.data[i];
            }
        }
        DogArray_I32 common = new DogArray_I32(this.visibleAll.count(true));
        for (int i = 0; i < seed.totalObservations; ++i) {
            if (!this.visibleAll.data[i]) continue;
            common.add(i);
        }
        return common;
    }

    public void createThreeViewLookUpTables() {
        PairwiseImageGraph.Motion connAB = this.seed.findMotion(this.viewB);
        PairwiseImageGraph.Motion connAC = this.seed.findMotion(this.viewC);
        PairwiseImageGraph.Motion connBC = this.viewB.findMotion(this.viewC);
        PairwiseGraphUtils.createTableViewAtoB(this.seed, connAB, this.table_A_to_B);
        PairwiseGraphUtils.createTableViewAtoB(this.seed, connAC, this.table_A_to_C);
        PairwiseGraphUtils.createTableViewAtoB(this.viewB, connBC, this.table_B_to_C);
        PairwiseGraphUtils.createTableViewAtoB(this.viewC, connAC, this.table_C_to_A);
    }

    public void findCommonFeatures() {
        int N = this.seed.totalObservations;
        this.commonIdx.reset();
        for (int featureIdxA = 0; featureIdxA < N; ++featureIdxA) {
            int featureIdxB;
            int featureIdxC;
            if (this.table_A_to_B.data[featureIdxA] < 0 || this.table_A_to_C.data[featureIdxA] < 0 || (featureIdxC = this.table_B_to_C.data[featureIdxB = this.table_A_to_B.data[featureIdxA]]) < 0 || this.table_C_to_A.data[featureIdxC] != featureIdxA) continue;
            this.commonIdx.add(featureIdxA);
        }
    }

    public void findCommonFeatures(DogArray_I32 selectedIdxA) {
        this.commonIdx.reset();
        for (int selectedIdx = 0; selectedIdx < selectedIdxA.size; ++selectedIdx) {
            int featureIdxA = selectedIdxA.get(selectedIdx);
            int featureIdxB = this.table_A_to_B.data[featureIdxA];
            int featureIdxC = this.table_B_to_C.data[featureIdxB];
            if (featureIdxC < 0 || this.table_C_to_A.data[featureIdxC] != featureIdxA) continue;
            this.commonIdx.add(featureIdxA);
        }
    }

    public void createTripleFromCommon() {
        this.db.lookupShape(this.seed.id, this.dimenA);
        this.db.lookupShape(this.viewB.id, this.dimenB);
        this.db.lookupShape(this.viewC.id, this.dimenC);
        this.db.lookupPixelFeats(this.seed.id, this.featsA);
        this.db.lookupPixelFeats(this.viewB.id, this.featsB);
        this.db.lookupPixelFeats(this.viewC.id, this.featsC);
        BoofMiscOps.offsetPixels((List)this.featsA.toList(), (double)(-this.dimenA.width / 2), (double)(-this.dimenA.height / 2));
        BoofMiscOps.offsetPixels((List)this.featsB.toList(), (double)(-this.dimenB.width / 2), (double)(-this.dimenB.height / 2));
        BoofMiscOps.offsetPixels((List)this.featsC.toList(), (double)(-this.dimenC.width / 2), (double)(-this.dimenC.height / 2));
        this.matchesTriple.reset();
        this.matchesTriple.resize(this.commonIdx.size);
        for (int i = 0; i < this.commonIdx.size; ++i) {
            int indexA = this.commonIdx.get(i);
            int indexB = this.table_A_to_B.data[indexA];
            int indexC = this.table_A_to_C.data[indexA];
            ((AssociatedTriple)this.matchesTriple.get(i)).setTo((Point2D_F64)this.featsA.get(indexA), (Point2D_F64)this.featsB.get(indexB), (Point2D_F64)this.featsC.get(indexC));
        }
    }

    public boolean estimateProjectiveCamerasRobustly() {
        if (!this.ransac.process(this.matchesTriple.toList())) {
            return false;
        }
        TrifocalTensor model = (TrifocalTensor)this.ransac.getModelParameters();
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.P1);
        MultiViewOps.trifocalCameraMatrices((TrifocalTensor)model, (DMatrixRMaj)this.P2, (DMatrixRMaj)this.P3);
        this.inliersThreeView = this.ransac.getMatchSet();
        return true;
    }

    public void saveRansacInliers(SceneWorkingGraph.View view) {
        int[] nArray;
        int viewIdx = this.seed == view.pview ? 0 : (this.viewB == view.pview ? 1 : (this.viewC == view.pview ? 2 : -1));
        switch (viewIdx) {
            case 0: {
                int[] nArray2 = new int[3];
                nArray2[0] = 0;
                nArray2[1] = 1;
                nArray = nArray2;
                nArray2[2] = 2;
                break;
            }
            case 1: {
                int[] nArray3 = new int[3];
                nArray3[0] = 1;
                nArray3[1] = 0;
                nArray = nArray3;
                nArray3[2] = 2;
                break;
            }
            case 2: {
                int[] nArray4 = new int[3];
                nArray4[0] = 2;
                nArray4[1] = 1;
                nArray = nArray4;
                nArray4[2] = 0;
                break;
            }
            default: {
                throw new RuntimeException("Passed in view is not any of the three expected");
            }
        }
        int[] order = nArray;
        int numInliers = this.inliersThreeView.size();
        SceneWorkingGraph.InlierInfo info = view.inliers;
        BoofMiscOps.checkTrue((info.views.size == 0 ? 1 : 0) != 0, (String)"Inliers should not have already been set for this view");
        info.observations.reset();
        info.observations.resize(3);
        DogArray_I32 indexesA = (DogArray_I32)info.observations.get(order[0]);
        DogArray_I32 indexesB = (DogArray_I32)info.observations.get(order[1]);
        DogArray_I32 indexesC = (DogArray_I32)info.observations.get(order[2]);
        for (int inlierCnt = 0; inlierCnt < numInliers; ++inlierCnt) {
            int inputIdx = this.ransac.getInputIndex(inlierCnt);
            int indexA = this.commonIdx.get(inputIdx);
            indexesA.add(indexA);
            indexesB.add(this.table_A_to_B.data[indexA]);
            indexesC.add(this.table_A_to_C.data[indexA]);
        }
        info.views.resize(3);
        for (int i = 0; i < 3; ++i) {
            PairwiseImageGraph.View view2;
            switch (i) {
                case 0: {
                    view2 = this.seed;
                    break;
                }
                case 1: {
                    view2 = this.viewB;
                    break;
                }
                case 2: {
                    view2 = this.viewC;
                    break;
                }
                default: {
                    throw new RuntimeException("BUG");
                }
            }
            PairwiseImageGraph.View v = view2;
            info.views.set(order[i], (Object)v);
        }
    }

    public void initializeSbaSceneThreeView(boolean fixedSeed) {
        this.structure.initialize(3, this.inliersThreeView.size());
        this.db.lookupShape(this.seed.id, this.shape);
        this.structure.setView(0, fixedSeed, this.P1, this.shape.width, this.shape.height);
        this.db.lookupShape(this.viewB.id, this.shape);
        this.structure.setView(1, !fixedSeed, this.P2, this.shape.width, this.shape.height);
        this.db.lookupShape(this.viewC.id, this.shape);
        this.structure.setView(2, !fixedSeed, this.P3, this.shape.width, this.shape.height);
        this.triangulateFeatures();
    }

    protected void triangulateFeatures() {
        BoofMiscOps.checkTrue((this.structure.views.size > 0 ? 1 : 0) != 0, (String)"Must initialize the structure first");
        BoofMiscOps.checkTrue((this.structure.points.size == this.inliersThreeView.size() ? 1 : 0) != 0, (String)"Number of inliers must match the number of points in the scene");
        ArrayList<DMatrixRMaj> cameraMatrices = new ArrayList<DMatrixRMaj>();
        cameraMatrices.add(this.P1);
        cameraMatrices.add(this.P2);
        cameraMatrices.add(this.P3);
        ArrayList<Point2D_F64> triangObs = new ArrayList<Point2D_F64>();
        triangObs.add(null);
        triangObs.add(null);
        triangObs.add(null);
        Point4D_F64 X = new Point4D_F64();
        for (int i = 0; i < this.inliersThreeView.size(); ++i) {
            AssociatedTriple t = this.inliersThreeView.get(i);
            triangObs.set(0, t.p1);
            triangObs.set(1, t.p2);
            triangObs.set(2, t.p3);
            if (!this.triangulator.triangulate(triangObs, cameraMatrices, X)) {
                throw new RuntimeException("Failed to triangulate a point in the inlier set?! Handle if this is common");
            }
            ((SceneStructureCommon.Point[])this.structure.points.data)[i].set(X.x, X.y, X.z, X.w);
        }
    }

    public void initializeSbaObservationsThreeView() {
        this.observations.initialize(3);
        SceneObservations.View view1 = this.observations.getView(0);
        SceneObservations.View view2 = this.observations.getView(1);
        SceneObservations.View view3 = this.observations.getView(2);
        for (int i = 0; i < this.inliersThreeView.size(); ++i) {
            AssociatedTriple t = this.inliersThreeView.get(i);
            view1.add(i, (float)t.p1.x, (float)t.p1.y);
            view2.add(i, (float)t.p2.x, (float)t.p2.y);
            view3.add(i, (float)t.p3.x, (float)t.p3.y);
        }
    }

    public boolean refineWithBundleAdjustment() {
        if (this.configConvergeSBA.maxIterations <= 0) {
            return true;
        }
        if (this.configScaleSBA) {
            this.scaler.applyScale(this.structure, this.observations);
        }
        this.sba.setParameters((SceneStructure)this.structure, this.observations);
        this.sba.configure(this.configConvergeSBA.ftol, this.configConvergeSBA.gtol, this.configConvergeSBA.maxIterations);
        if (!this.sba.optimize((SceneStructure)this.structure)) {
            return false;
        }
        if (this.configScaleSBA) {
            this.scaler.undoScale(this.structure, this.observations);
        }
        return true;
    }

    public static void createTableViewAtoB(PairwiseImageGraph.View viewA, PairwiseImageGraph.Motion edge, DogArray_I32 table_a_to_b) {
        table_a_to_b.resize(viewA.totalObservations, -1);
        boolean src_is_A = edge.src == viewA;
        for (int i = 0; i < edge.inliers.size; ++i) {
            AssociatedIndex assoc = (AssociatedIndex)edge.inliers.get(i);
            table_a_to_b.data[src_is_A ? assoc.src : assoc.dst] = src_is_A ? assoc.dst : assoc.src;
        }
    }

    public SceneStructureProjective getStructure() {
        return this.structure;
    }

    public SceneObservations getObservations() {
        return this.observations;
    }

    public ModelMatcher<TrifocalTensor, AssociatedTriple> getRansac() {
        return this.ransac;
    }

    public TriangulateNViewsProjective getTriangulator() {
        return this.triangulator;
    }

    public PoseFromPairLinear6 getPoseEstimator() {
        return this.poseEstimator;
    }

    public BundleAdjustment<SceneStructureProjective> getSba() {
        return this.sba;
    }

    public ScaleSceneStructure getScaler() {
        return this.scaler;
    }

    public static class DefaultScoreMotion
    implements ScoreMotion {
        @Override
        public double score(PairwiseImageGraph.Motion m) {
            double score = Math.min(5.0, (double)m.countF / (double)(m.countH + 1));
            return score *= (double)m.countF;
        }
    }

    public static interface ScoreMotion {
        public double score(PairwiseImageGraph.Motion var1);
    }
}

