/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.robust;

import boofcv.alg.geo.NormalizedToPixelError;
import boofcv.alg.sfm.overhead.CameraPlaneProjection;
import boofcv.struct.sfm.PlanePtPixel;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se2_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.List;
import org.ddogleg.fitting.modelset.DistanceFromModel;

public class DistancePlane2DToPixelSq
implements DistanceFromModel<Se2_F64, PlanePtPixel> {
    private Se2_F64 keyToCurr;
    private final Point2D_F64 curr2D = new Point2D_F64();
    private final Point2D_F64 normalizedPred = new Point2D_F64();
    private final CameraPlaneProjection planeProjection = new CameraPlaneProjection();
    private final NormalizedToPixelError errorCamera = new NormalizedToPixelError();

    public void setExtrinsic(Se3_F64 planeToCamera) {
        this.planeProjection.setPlaneToCamera(planeToCamera, false);
    }

    public void setIntrinsic(double fx, double fy, double skew) {
        this.errorCamera.set(fx, fy, skew);
    }

    public void setModel(Se2_F64 keyToCurr) {
        this.keyToCurr = keyToCurr;
    }

    public double distance(PlanePtPixel sample) {
        SePointOps_F64.transform((Se2_F64)this.keyToCurr, (Point2D_F64)sample.planeKey, (Point2D_F64)this.curr2D);
        if (!this.planeProjection.planeToNormalized(this.curr2D.x, this.curr2D.y, this.normalizedPred)) {
            return Double.MAX_VALUE;
        }
        return this.errorCamera.errorSq(sample.normalizedCurr, this.normalizedPred);
    }

    public void distances(List<PlanePtPixel> samples, double[] distance) {
        for (int i = 0; i < samples.size(); ++i) {
            distance[i] = this.distance(samples.get(i));
        }
    }

    public Class<PlanePtPixel> getPointType() {
        return PlanePtPixel.class;
    }

    public Class<Se2_F64> getModelType() {
        return Se2_F64.class;
    }
}

