/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.d2;

import boofcv.abst.tracker.PointTrack;
import boofcv.abst.tracker.PointTracker;
import boofcv.alg.sfm.d2.ImageMotionPointTrackerKey;
import boofcv.alg.tracker.PruneCloseTracks;
import boofcv.struct.ImageRectangle_F64;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.image.ImageBase;
import georegression.struct.InvertibleTransform;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;

public class ImageMotionPtkSmartRespawn<I extends ImageBase<I>, IT extends InvertibleTransform> {
    private final ImageMotionPointTrackerKey<I, IT> motion;
    protected PruneCloseTracks<PointTrack> pruneClose = PruneCloseTracks.prunePointTrack((int)3);
    private final List<PointTrack> prune = new ArrayList<PointTrack>();
    private final int absoluteMinimumTracks;
    private final double relativeInlierFraction;
    private final double respawnCoverageFraction;
    protected boolean previousWasKeyFrame = false;
    private final ImageRectangle_F64 contRect = new ImageRectangle_F64();
    protected double containment;
    private double maxContainment;
    private int maxInliers;

    public ImageMotionPtkSmartRespawn(ImageMotionPointTrackerKey<I, IT> motion, int absoluteMinimumTracks, double relativeInlierFraction, double respawnCoverageFraction) {
        this.motion = motion;
        this.absoluteMinimumTracks = absoluteMinimumTracks;
        this.relativeInlierFraction = relativeInlierFraction;
        this.respawnCoverageFraction = respawnCoverageFraction;
    }

    public boolean process(I input) {
        if (!this.motion.process(input)) {
            return false;
        }
        boolean setKeyFrame = false;
        PointTracker<I> tracker = this.motion.getTracker();
        List inliers = this.motion.getModelMatcher().getMatchSet();
        int inlierSetSize = inliers.size();
        this.computeContainment(((ImageBase)input).width * ((ImageBase)input).height);
        if (inlierSetSize < this.absoluteMinimumTracks) {
            setKeyFrame = true;
        } else if (this.previousWasKeyFrame) {
            this.previousWasKeyFrame = false;
            this.maxContainment = this.containment;
            this.maxInliers = inliers.size();
        } else {
            if ((double)inlierSetSize < (double)this.maxInliers * this.relativeInlierFraction) {
                setKeyFrame = true;
            }
            if (this.containment < this.respawnCoverageFraction * this.maxContainment) {
                setKeyFrame = true;
            }
        }
        if (setKeyFrame) {
            this.pruneClosePoints(tracker, ((ImageBase)input).width, ((ImageBase)input).height);
            this.motion.changeKeyFrame();
            this.previousWasKeyFrame = true;
        }
        return true;
    }

    private void pruneClosePoints(PointTracker<I> tracker, int width, int height) {
        this.pruneClose.init(width, height);
        this.prune.clear();
        this.pruneClose.process(tracker.getActiveTracks(null), this.prune);
        for (int pruneIdx = 0; pruneIdx < this.prune.size(); ++pruneIdx) {
            tracker.dropTrack(this.prune.get(pruneIdx));
        }
    }

    private void computeContainment(int imageArea) {
        this.contRect.y0 = Double.MAX_VALUE;
        this.contRect.x0 = Double.MAX_VALUE;
        this.contRect.y1 = -1.7976931348623157E308;
        this.contRect.x1 = -1.7976931348623157E308;
        List matchSet = this.motion.getModelMatcher().getMatchSet();
        for (int matchIdx = 0; matchIdx < matchSet.size(); ++matchIdx) {
            AssociatedPair p = (AssociatedPair)matchSet.get(matchIdx);
            Point2D_F64 t = p.p2;
            if (t.x > this.contRect.x1) {
                this.contRect.x1 = t.x;
            }
            if (t.y > this.contRect.y1) {
                this.contRect.y1 = t.y;
            }
            if (t.x < this.contRect.x0) {
                this.contRect.x0 = t.x;
            }
            if (!(t.y < this.contRect.y0)) continue;
            this.contRect.y0 = t.y;
        }
        this.containment = this.contRect.area() / (double)imageArea;
    }

    public ImageMotionPointTrackerKey<I, IT> getMotion() {
        return this.motion;
    }
}

