/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.mvs;

import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.misc.IteratorReset;
import boofcv.struct.geo.PointIndex;
import georegression.struct.GeoTuple;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import org.ddogleg.struct.DogArray_I32;

public class ScenePointsSetIterator<T extends PointIndex<T, P>, P extends GeoTuple<P>>
implements IteratorReset<T> {
    SceneStructureCommon scene;
    DogArray_I32 indexes;
    int index;
    T point;

    public ScenePointsSetIterator(SceneStructureCommon scene, DogArray_I32 indexes, T point) {
        this(point);
        this.initialize(scene, indexes);
    }

    public ScenePointsSetIterator(T point) {
        this.point = point;
    }

    public void initialize(SceneStructureCommon scene, DogArray_I32 indexes) {
        if (scene.isHomogenous() != ((PointIndex)this.point).p instanceof Point4D_F64) {
            throw new IllegalArgumentException("Scene point type does not match provided point type");
        }
        this.scene = scene;
        this.indexes = indexes;
        this.index = 0;
    }

    public void reset() {
        this.index = 0;
    }

    public boolean hasNext() {
        return this.index < this.indexes.size;
    }

    public T next() {
        int indexScene = this.indexes.get(this.index++);
        if (this.scene.isHomogenous()) {
            ((SceneStructureCommon.Point)this.scene.points.get(indexScene)).get((Point4D_F64)((PointIndex)this.point).p);
        } else {
            ((SceneStructureCommon.Point)this.scene.points.get(indexScene)).get((Point3D_F64)((PointIndex)this.point).p);
        }
        ((PointIndex)this.point).index = indexScene;
        return this.point;
    }
}

