/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.fiducial;

import boofcv.abst.shapes.polyline.ConfigPolylineSplitMerge;
import boofcv.factory.shape.ConfigPolygonDetector;
import boofcv.struct.ConfigLength;
import boofcv.struct.Configuration;

public class ConfigFiducialImage
implements Configuration {
    public double maxErrorFraction = 0.2;
    public double borderWidthFraction = 0.25;
    public double minimumBlackBorderFraction = 0.65;
    public ConfigPolygonDetector squareDetector = new ConfigPolygonDetector();

    public ConfigFiducialImage() {
        ((ConfigPolylineSplitMerge)this.squareDetector.detector.contourToPoly).cornerScorePenalty = 0.2;
        ((ConfigPolylineSplitMerge)this.squareDetector.detector.contourToPoly).thresholdSideSplitScore = 0.0;
        this.squareDetector.detector.minimumContour = ConfigLength.fixed((double)20.0);
        this.squareDetector.refineGray.cornerOffset = 0.0;
    }

    public void setTo(ConfigFiducialImage src) {
        this.maxErrorFraction = src.maxErrorFraction;
        this.borderWidthFraction = src.borderWidthFraction;
        this.minimumBlackBorderFraction = src.minimumBlackBorderFraction;
        this.squareDetector.setTo(src.squareDetector);
    }

    public void checkValidity() {
        if (this.borderWidthFraction <= 0.0 || this.borderWidthFraction >= 0.5) {
            throw new IllegalArgumentException("Border width fraction must be 0 < fraction < 0.5");
        }
    }

    public double getMaxErrorFraction() {
        return this.maxErrorFraction;
    }

    public void setMaxErrorFraction(double maxErrorFraction) {
        this.maxErrorFraction = maxErrorFraction;
    }

    public ConfigPolygonDetector getSquareDetector() {
        return this.squareDetector;
    }

    public void setSquareDetector(ConfigPolygonDetector squareDetector) {
        this.squareDetector = squareDetector;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ maxErrorFraction=" + this.maxErrorFraction + " borderWidthFraction=" + this.borderWidthFraction + " squareDetector=" + this.squareDetector + " }";
    }
}

